/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.text.Html;
import android.text.TextUtils;
import android.widget.RemoteViews;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.google.gson.Gson;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.CampaignActivity;
import com.hippo.activity.ChannelActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.calling.CallConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.helper.P2pUnreadCount;
import com.hippo.helper.PushHandler;
import com.hippo.langs.Restring;
import com.hippo.model.FuguConversation;
import com.hippo.model.UnreadCountModel;
import com.hippo.model.promotional.CustomAttributes;
import com.hippo.model.promotional.Data;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.receiver.NotificationReceiver;
import com.hippo.service.AdvanceSpecService;
import com.hippo.service.AppLifecycleListener;
import com.hippo.service.NotificationWorkManager;
import com.hippo.service.TokenService;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UnreadCountPush;
import io.paperdb.Paper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HippoNotificationConfig
implements FuguAppConstant {
    public static String fuguDeviceToken = "";
    public static final String CHANNEL_ONE_ID = "com.hippo.ONE";
    public static final String CHANNEL_ONE_NAME = "Default notification";
    private static final String TAG = HippoNotificationConfig.class.getSimpleName();
    public static Long pushChannelId = -1L;
    public static Long pushLabelId = -1L;
    public static Long agentPushChannelId = -1L;
    public static boolean isChannelActivityOnPause = false;
    public static NotificationManager notificationManager;
    private boolean notificationSoundEnabled = true;
    private int smallIcon = -1;
    private int largeIcon;
    private int priority;
    private RemoteViews smallContentView;
    private RemoteViews bigContentView;
    Intent notificationIntent;

    public static void handleHippoPushNotification(final Context context, final Bundle bundle) {
        if (bundle == null) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (bundle.containsKey("is_announcement_push") && bundle.getBoolean("is_announcement_push")) {
                    Intent broadcastIntent = new Intent(context, CampaignActivity.class);
                    broadcastIntent.putExtra("isFromPush", true);
                    broadcastIntent.putExtra("message", bundle.get("message").toString());
                    context.startActivity(broadcastIntent);
                } else {
                    FuguConversation conversation = (FuguConversation)new Gson().fromJson(bundle.getString("conversation"), FuguConversation.class);
                    if (conversation != null && conversation.isStartChannelsActivity() && HippoConfig.getInstance() != null) {
                        if (conversation.getTransactionId() != null && !conversation.getTransactionId().isEmpty()) {
                            conversation.setOriginalTransactionId(conversation.getTransactionId());
                        }
                        HippoLog.e(TAG, "conversation: " + new Gson().toJson((Object)conversation));
                        Intent conversationIntent = new Intent(context, FuguChatActivity.class);
                        if (conversation.getChannelId() < 0L && conversation.getLabelId() < 0L) {
                            conversationIntent = new Intent(context, ChannelActivity.class);
                        }
                        if (conversation.getChannelType() == 7 || conversation.getChannelType() == 6) {
                            conversationIntent.putExtra("isfromPush", true);
                        }
                        conversationIntent.putExtra("channel_Id_push", conversation.getChannelIdPush());
                        conversationIntent.putExtra("message", bundle.get("conversation").toString());
                        conversationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                        context.startActivity(conversationIntent);
                    }
                }
            }
        }, 1000L);
    }

    public static void cancelNotification(Context ctx, int notifyId) {
        String ns = "notification";
        NotificationManager nMgr = (NotificationManager)ctx.getSystemService(ns);
        nMgr.cancel(notifyId);
    }

    public static void clearNotifications(Context context, ArrayList<Integer> ids) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (ids != null && ids.size() > 0) {
            for (Integer integer : ids) {
                notificationManager.cancel(integer.intValue());
            }
        }
    }

    public static long getTimeMilliSec(String timeStamp) {
        block3: {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            try {
                if (!TextUtils.isEmpty((CharSequence)timeStamp)) {
                    Date date = format.parse(timeStamp);
                    return date.getTime();
                }
            }
            catch (ParseException e) {
                if (!HippoConfig.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return 0L;
    }

    @TargetApi(value=21)
    private static AudioAttributes getRingtoneAudioAttributes() {
        return new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
    }

    public void setNotificationSoundEnabled(boolean notificationSoundEnabled) {
        this.notificationSoundEnabled = notificationSoundEnabled;
    }

    public void setSmallIcon(int smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLargeIcon(int largeIcon) {
        this.largeIcon = largeIcon;
    }

    public boolean isHippoNotification(Map<String, String> data) {
        return data.containsKey("push_source") && data.get("push_source").equalsIgnoreCase("FUGU");
    }

    public boolean isHippoCallNotification(Context context, Map<String, String> data) {
        block9: {
            try {
                Paper.init((Context)context);
                JSONObject messageJson = new JSONObject(data.get("message"));
                try {
                    if (this.isCallEnabled(context, messageJson.optString("call_type")) && messageJson.optInt("notification_type") == 14 && (messageJson.optString("video_call_type").equalsIgnoreCase("START_CALL") || messageJson.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                        return true;
                    }
                    if (messageJson.optInt("notification_type") == 14) {
                        return false;
                    }
                    if (messageJson.optInt("notification_type") == 20) {
                        return true;
                    }
                    if (messageJson.optInt("notification_type") == 25) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (HippoConfig.DEBUG) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block9;
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean isCallEnabled(Context context, String callType) {
        Paper.init((Context)context);
        if (callType.equalsIgnoreCase("AUDIO")) {
            return CommonData.getAudioCallStatus();
        }
        return CommonData.getVideoCallStatus();
    }

    public void showNotification(Context context, Map<String, String> data) {
        block2: {
            try {
                Paper.init((Context)context);
                HippoLog.e("showing", "showing push");
                HippoConfig.getInstance().setContext(context);
                this.showUserNotification(context, data);
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private int getPriority() {
        if (Build.VERSION.SDK_INT >= 24) {
            return 5;
        }
        return 2;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    private void showUserNotification(Context context, Map<String, String> data) throws Exception {
        block55: {
            CommonData.setPushBoolean(true);
            if (CommonData.getConversationList() != null && CommonData.getConversationList().size() <= 0) {
                CommonData.setNotificationFirstClick(true);
            }
            try {
                JSONObject messageJson;
                block54: {
                    messageJson = new JSONObject(data.get("message"));
                    try {
                        if (CommonData.getVideoCallStatus() && messageJson.optInt("notification_type") == 14 && (messageJson.optString("video_call_type").equalsIgnoreCase("START_CALL") || messageJson.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                            if (HippoConfig.getInstance().getCallData() != null) {
                                HippoConfig.getInstance().getCallData().onNotificationReceived(context, messageJson);
                            } else {
                                HippoConfig.getInstance().setCallListener(new CallData(){

                                    @Override
                                    public void onNotificationReceived(Context context, JSONObject data) {
                                    }

                                    @Override
                                    public void onConfNotificationReceived(Context context, JSONObject data) {
                                    }

                                    @Override
                                    public void onGroupNotificationReceived(Context context, JSONObject data) {
                                    }

                                    @Override
                                    public void networkStatus(int status) {
                                    }

                                    @Override
                                    public void onCallClick(Context context, int callType, Long channelId, Long userId, boolean isAgentFlow, boolean isAllowCall, String fullname, String image, String myImagePath, String transactionId, String videoSdkToken, String videoSdkMeetId, String videoSdkUrl) {
                                    }

                                    @Override
                                    public void onExternalClick(Context context, String callType, Long userid, String otherUserName, String fuguPeerChatParams, String otherUserImagePath, String myImagePath, String transactionId) {
                                    }

                                    @Override
                                    public void openDirectLink(Context context, String roomId, String userName, String callType, String imagePath, Long channelId, String transactionId, int isAudioEnabled, int isVideoEnabled) {
                                    }

                                    @Override
                                    public void leaveGroupCall(Context context, String transactionId) {
                                    }

                                    @Override
                                    public void joinCallUrl(Context context, String url, String currentChannelId, String transectionId, String userName, String callType, String audioVideoCallType) {
                                    }

                                    @Override
                                    public void launchJitsi(Context context, URL url, String userName, String roomName, String image, Boolean isAudioOnly) {
                                    }

                                    @Override
                                    public void rejoinCall(Context context, String inviteLink, String connectingMeeting) {
                                    }

                                    @Override
                                    public void hungUpCall() {
                                    }
                                });
                            }
                            return;
                        }
                        if (messageJson.optInt("notification_type") == 14) {
                            return;
                        }
                        if (messageJson.optInt("notification_type") == 20) {
                            block53: {
                                try {
                                    new CallConfig().getInstance().onStartConferenceCall(context, messageJson);
                                }
                                catch (Exception e) {
                                    if (!HippoConfig.DEBUG) break block53;
                                    e.printStackTrace();
                                }
                            }
                            return;
                        }
                        if (messageJson.optInt("notification_type") == 25) {
                            if (HippoConfig.getInstance().getCallData() != null) {
                                HippoConfig.getInstance().getCallData().onGroupNotificationReceived(context, messageJson);
                            }
                            return;
                        }
                        if (messageJson.optInt("notification_type") == 23) {
                            new PushHandler().notificationMissedCall(context, messageJson, this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon);
                            return;
                        }
                    }
                    catch (Exception e) {
                        if (!HippoConfig.DEBUG) break block54;
                        e.printStackTrace();
                    }
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
                    if (messageJson.optInt("notification_type") == 1) {
                        notificationChannel.setSound(Settings.System.DEFAULT_NOTIFICATION_URI, HippoNotificationConfig.getRingtoneAudioAttributes());
                    }
                    if (notificationManager == null) {
                        notificationManager = (NotificationManager)context.getSystemService("notification");
                    }
                    if (notificationManager != null) {
                        notificationManager.createNotificationChannel(notificationChannel);
                    }
                }
                Intent mIntent = new Intent("notification_received");
                Bundle dataBundle = new Bundle();
                for (String key : data.keySet()) {
                    dataBundle.putString(key, data.get(key));
                }
                mIntent.putExtras(dataBundle);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                Paper.init((Context)context);
                if (messageJson.has("is_silent") && messageJson.has("update_device_token") && messageJson.optInt("is_silent", 0) == 1) {
                    this.tokenApi(context);
                    break block55;
                }
                if (messageJson.has("is_announcement_push") && messageJson.optInt("is_announcement_push", 0) == 1) {
                    Intent broadcastIntent;
                    this.advanceStatsApi(context, messageJson);
                    String title = messageJson.optString("title", "");
                    String message = messageJson.optString("new_message", "");
                    int disableReply = messageJson.optInt("disable_reply", 0);
                    String removeLt = message.replaceAll("<", "&lt;");
                    String removeGt = removeLt.replaceAll(">", "&gt;");
                    String removeQuotes = removeGt.replaceAll("\"", "&quot;");
                    message = removeQuotes.replaceAll("'", "&#39;");
                    if (!AppLifecycleListener.isAppKilled) {
                        broadcastIntent = new Intent(context, CampaignActivity.class);
                    } else {
                        PackageManager pm = context.getPackageManager();
                        broadcastIntent = pm.getLaunchIntentForPackage(context.getPackageName());
                    }
                    broadcastIntent.setFlags(0x14000000);
                    broadcastIntent.putExtra("is_promotional_push", true);
                    broadcastIntent.putExtra("is_announcement_push", true);
                    broadcastIntent.putExtra("isFromPush", true);
                    broadcastIntent.putExtra("dataMessage", data.get("message"));
                    broadcastIntent.putExtra("message", data.get("message"));
                    int flags = 0x8000000;
                    if (Build.VERSION.SDK_INT >= 23) {
                        flags = 0xC000000;
                    }
                    PendingIntent pi = PendingIntent.getActivity((Context)context.getApplicationContext(), (int)((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE)), (Intent)broadcastIntent, (int)flags);
                    String imageUrl = "";
                    try {
                        imageUrl = messageJson.optJSONObject("custom_attributes").optJSONObject("image").optString("image_url", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Integer channelId = 0;
                    try {
                        if (messageJson.has("channel_id")) {
                            channelId = messageJson.optInt("channel_id", -1);
                            this.updateCount("" + channelId);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isAnnouncements()) {
                        JSONObject json = new JSONObject(data.get("message"));
                        PromotionResponse response = CommonData.getPromotionResponse();
                        boolean firstTime = false;
                        if (response == null) {
                            firstTime = true;
                            response = new PromotionResponse();
                        }
                        Data broadcast = new Data(Integer.parseInt(HippoConfig.getInstance().getUserData().getUserId().toString()));
                        broadcast.setChannelId(json.getInt("channel_id"));
                        broadcast.setCreatedAt(json.getString("date_time"));
                        broadcast.setDisableReply(json.getInt("disable_reply"));
                        broadcast.setDescription(json.getString("message"));
                        CustomAttributes attr2 = (CustomAttributes)new Gson().fromJson(json.getString("custom_attributes"), CustomAttributes.class);
                        broadcast.setCustomAttributes(attr2);
                        broadcast.setTitle(json.getString("title"));
                        broadcast.setAddedFromBroadcast(true);
                        if (!firstTime) {
                            response.getData().add(0, broadcast);
                            CommonData.savePromotionResponse(response);
                        } else {
                            ArrayList<Data> arrayData = new ArrayList<Data>();
                            arrayData.add(broadcast);
                            response.setData(arrayData);
                            CommonData.savePromotionResponse(response);
                        }
                        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
                            this.bigImageNotifAsync(context, title, message, imageUrl, pi, channelId);
                        } else {
                            this.showPromotionalPush(context, title, message, pi, null, channelId);
                        }
                    }
                    break block55;
                }
                if (messageJson.has("channel_type") && (messageJson.getInt("channel_type") == 6 || messageJson.getInt("channel_type") == 7)) {
                    this.advanceStatsApi(context, messageJson);
                }
                long channelId = -1L;
                long labelId = -1L;
                int disableReply = messageJson.optInt("disable_reply", 0);
                String label = messageJson.optString("label", "");
                String title = messageJson.optString("title", "");
                String message = messageJson.optString("new_message", "");
                int channelType = messageJson.optInt("channel_type", messageJson.getInt("channel_type"));
                String removeLt = message.replaceAll("<", "&lt;");
                String removeGt = removeLt.replaceAll(">", "&gt;");
                String removeQuotes = removeGt.replaceAll("\"", "&quot;");
                message = removeQuotes.replaceAll("'", "&#39;");
                message = Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)Html.fromHtml((String)message.replace("\n", "<br /> "), (int)0).toString()).toString() : Html.fromHtml((String)Html.fromHtml((String)message.replace("\n", "<br /> ")).toString()).toString();
                long channel_Id_push = -1L;
                if (messageJson.has("channel_id")) {
                    channel_Id_push = messageJson.getLong("channel_id");
                }
                if (messageJson.has("channel_id") && channelType != 6) {
                    channelId = messageJson.optLong("channel_id", -1L);
                }
                if (messageJson.has("label_id")) {
                    labelId = messageJson.optLong("label_id", -1L);
                }
                if (pushChannelId != null && channelId > 0L && pushChannelId.compareTo(channelId) == 0) {
                    return;
                }
                if (pushLabelId != null && labelId > 0L && pushLabelId.compareTo(labelId) == 0) {
                    return;
                }
                FuguConversation conversation = new FuguConversation();
                conversation.setChannelId(channelId);
                conversation.setEnUserId(CommonData.getUserDetails().getData().getEn_user_id());
                conversation.setUserId(CommonData.getUserDetails().getData().getUserId());
                conversation.setLabel(label);
                conversation.setChannelType(channelType);
                conversation.setChannelIdPush(channel_Id_push);
                conversation.setLabelId(labelId);
                conversation.setDisableReply(disableReply);
                if (channelId < 0L && labelId > 0L) {
                    conversation.setOpenChat(true);
                }
                Intent notificationIntent = this.getPendingIntent(context, conversation, labelId, channelId);
                int flags = 0x8000000;
                if (Build.VERSION.SDK_INT >= 23) {
                    flags = 0xC000000;
                }
                PendingIntent pi = PendingIntent.getActivity((Context)context, (int)((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE)), (Intent)notificationIntent, (int)flags);
                int notificationDefaults = -1;
                if (!this.notificationSoundEnabled) {
                    notificationDefaults = 4;
                }
                if (messageJson.has("custom_attributes") && (messageJson.optJSONObject("custom_attributes").has("notification_color") || messageJson.optJSONObject("custom_attributes").has("font_color") || messageJson.optJSONObject("custom_attributes").has("is_sticky"))) {
                    this.showCustomPromotionalPush(context, title, message, pi, null, Integer.parseInt(String.valueOf(channelId)), messageJson);
                } else {
                    int smallIconViewId;
                    NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)message))).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon)).setContentTitle((CharSequence)title).setContentText((CharSequence)Html.fromHtml((String)message)).setContentIntent(pi).setPriority(this.priority).setAutoCancel(true);
                    mBuilder.setDefaults(notificationDefaults);
                    mBuilder.setChannelId(CHANNEL_ONE_ID);
                    Notification notification = mBuilder.build();
                    if (Build.VERSION.SDK_INT >= 21 && (smallIconViewId = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                        if (notification.headsUpContentView != null) {
                            notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
                        }
                        if (notification.bigContentView != null) {
                            notification.bigContentView.setViewVisibility(smallIconViewId, 4);
                        }
                    }
                    if (notificationManager == null) {
                        notificationManager = (NotificationManager)context.getSystemService("notification");
                    }
                    notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
                }
                try {
                    this.updateLocalCount(messageJson);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateChannelCount(messageJson);
            }
            catch (JSONException e) {
                if (!HippoConfig.DEBUG) break block55;
                e.printStackTrace();
            }
        }
    }

    private void tokenApi(Context context) {
        Intent intent = new Intent(context, TokenService.class);
        if (Build.VERSION.SDK_INT >= 26) {
            context.startForegroundService(intent);
        } else {
            context.startService(intent);
        }
    }

    private void advanceStatsApi(Context context, JSONObject messageJson) {
        if (!AppLifecycleListener.isAppKilled) {
            Data.Builder data = new Data.Builder();
            OneTimeWorkRequest.Builder compressionWork = new OneTimeWorkRequest.Builder(NotificationWorkManager.class);
            data.putBoolean("isCtrSessionTime", true);
            if (CommonData.getAdvanceSpecData() != null && CommonData.getAdvanceSpecData().getStart_time_milis() > 0L) {
                data.putString("messageJson", CommonData.getAdvanceSpecData().getMessage());
                data.putBoolean("isCtrSessionTime", true);
            } else {
                data.putString("messageJson", messageJson.toString());
            }
            data.putBoolean("isDelivered", true);
            compressionWork.setInputData(data.build());
            WorkManager.getInstance((Context)context).enqueue(compressionWork.build());
        } else {
            Intent intent = new Intent(context, AdvanceSpecService.class);
            try {
                if (CommonData.getAdvanceSpecData() != null && CommonData.getAdvanceSpecData().getStart_time_milis() > 0L) {
                    intent.putExtra("messageJson", CommonData.getAdvanceSpecData().getMessage());
                    intent.putExtra("isCtrSessionTime", true);
                } else {
                    intent.putExtra("messageJson", messageJson.toString());
                }
                intent.putExtra("isDelivered", true);
                if (Build.VERSION.SDK_INT >= 26) {
                    context.startForegroundService(intent);
                } else {
                    context.startService(intent);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLocalCount(JSONObject messageJson) {
        try {
            if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isChannelActivity() && (messageJson.has("channel_id") && pushChannelId.compareTo(messageJson.getLong("channel_id")) != 0 || messageJson.has("label_id") && pushLabelId.compareTo(messageJson.getLong("label_id")) != 0)) {
                try {
                    long channelId = messageJson.optLong("channel_id", -1L);
                    if (channelId < 1L) {
                        channelId = messageJson.optLong("label_id", -1L);
                    }
                    new UnreadCountPush().execute(new Long[]{channelId, 1L});
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateChannelCount(JSONObject messageJson) {
        block4: {
            try {
                String transactionId = messageJson.optString("chat_transaction_id", "");
                String muid = messageJson.optString("muid", "");
                long channelId = messageJson.optLong("channel_id", -1L);
                if (TextUtils.isEmpty((CharSequence)transactionId)) break block4;
                if (messageJson.has("user_unique_key")) {
                    JSONArray jsonarray = messageJson.getJSONArray("user_unique_key");
                    String myUniqueId = CommonData.getAttributes().getCaptureUserData().getUserUniqueKey();
                    for (int i = 0; i < jsonarray.length(); ++i) {
                        String jsonobject = jsonarray.getString(i);
                        if (jsonobject.equalsIgnoreCase(myUniqueId) || !P2pUnreadCount.INSTANCE.hasTransactionId(transactionId + "_" + jsonobject)) continue;
                        P2pUnreadCount.INSTANCE.updateChannelId(transactionId, channelId, muid);
                        break block4;
                    }
                    break block4;
                }
                P2pUnreadCount.INSTANCE.updateChannelId(transactionId, channelId, muid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateCount(String channelId) {
        if (HippoConfig.getInstance().getCallbackListener() == null) {
            return;
        }
        if (!HippoConfig.getInstance().isAnnouncements()) {
            HashSet<String> count = CommonData.getAnnouncementCount();
            count.add(channelId);
            CommonData.setAnnouncementCount(count);
            if (HippoConfig.getInstance().getCallbackListener() != null) {
                HippoConfig.getInstance().getCallbackListener().unreadAnnouncementsCount(count.size());
            }
        }
    }

    private void addUnreadCount(Long channelId, Long labelId) {
        block12: {
            try {
                HippoLog.e(TAG, "In count");
                if (HippoConfig.getInstance().getCallbackListener() == null) {
                    return;
                }
                if (!HippoConfig.getInstance().isChannelActivity()) {
                    int channelCount;
                    ArrayList<UnreadCountModel> unreadCountModels;
                    int i;
                    int index = -1;
                    if (channelId > 0L) {
                        index = CommonData.getUnreadCountModel().indexOf(new UnreadCountModel(channelId));
                    } else if (labelId > 0L && CommonData.getUnreadCountModel() != null) {
                        ArrayList<UnreadCountModel> unreadCountModel = CommonData.getUnreadCountModel();
                        for (i = 0; i < unreadCountModel.size(); ++i) {
                            if (unreadCountModel.get(i).getLabelId().compareTo(labelId) != 0) continue;
                            index = i;
                            break;
                        }
                    }
                    HippoLog.v(TAG, "index = " + index);
                    if (index > -1) {
                        unreadCountModels = CommonData.getUnreadCountModel();
                        HippoLog.v(TAG, "unreadCountModels = " + unreadCountModels.size());
                        HippoLog.v(TAG, "unreadCountModels.get(index).getCount() = " + unreadCountModels.get(index).getCount());
                        channelCount = unreadCountModels.get(index).getCount() + 1;
                        HippoLog.v(TAG, "channelCount = " + channelCount);
                        unreadCountModels.get(index).setCount(channelCount);
                        CommonData.setUnreadCount(new ArrayList<UnreadCountModel>());
                        CommonData.setUnreadCount(unreadCountModels);
                    } else {
                        channelCount = 1;
                        UnreadCountModel countModel = new UnreadCountModel(channelId, labelId, channelCount);
                        unreadCountModels = CommonData.getUnreadCountModel();
                        HippoLog.v(TAG, "unreadCountModels = " + unreadCountModels.size());
                        unreadCountModels.add(countModel);
                        CommonData.setUnreadCount(unreadCountModels);
                    }
                    int count = 0;
                    for (i = 0; i < unreadCountModels.size(); ++i) {
                        count += unreadCountModels.get(i).getCount();
                    }
                    HippoLog.v(TAG, "count = " + count);
                    if (HippoConfig.getInstance().getCallbackListener() != null) {
                        HippoConfig.getInstance().getCallbackListener().count(count);
                    }
                }
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block12;
                e.printStackTrace();
            }
        }
    }

    private void bigImageNotifAsync(final Context context, final String title, final String message, String url, final PendingIntent pi, final Integer ChannelID) {
        block2: {
            try {
                Glide.with((Context)context).asBitmap().load(url).into((Target)new CustomTarget<Bitmap>(){

                    public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition2) {
                        HippoNotificationConfig.this.showPromotionalPush(context, title, message, pi, resource, ChannelID);
                    }

                    public void onLoadCleared(@Nullable Drawable placeholder) {
                        HippoNotificationConfig.this.showPromotionalPush(context, title, message, pi, null, ChannelID);
                    }
                });
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block2;
                e.printStackTrace();
            }
        }
    }

    private void showPromotionalPush(Context context, String title, String message, PendingIntent pi, Bitmap bitmap, Integer channelId) {
        int smallIconViewId;
        int notificationDefaults = -1;
        if (!this.notificationSoundEnabled) {
            notificationDefaults = 4;
        }
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon)).setContentTitle((CharSequence)title).setContentText((CharSequence)Html.fromHtml((String)message)).setContentIntent(pi).setPriority(this.priority).setAutoCancel(true);
        if (bitmap == null) {
            mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)Html.fromHtml((String)message)));
        } else {
            mBuilder.setLargeIcon(bitmap);
            mBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bitmap).bigLargeIcon(null).setBigContentTitle((CharSequence)title).setSummaryText((CharSequence)Html.fromHtml((String)message)));
        }
        mBuilder.setDefaults(notificationDefaults);
        mBuilder.setChannelId(CHANNEL_ONE_ID);
        Notification notification = mBuilder.build();
        if (Build.VERSION.SDK_INT >= 21 && (smallIconViewId = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
            if (notification.headsUpContentView != null) {
                notification.headsUpContentView.setViewVisibility(smallIconViewId, 4);
            }
            if (notification.bigContentView != null) {
                notification.bigContentView.setViewVisibility(smallIconViewId, 4);
            }
        }
        notificationManager = (NotificationManager)context.getSystemService("notification");
        if (channelId != null && channelId > 0) {
            notificationManager.notify(channelId.intValue(), notification);
        } else {
            notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
        }
    }

    private void showCustomPromotionalPush(Context context, String title, String message, PendingIntent pi, String bitmap, Integer channelId, JSONObject data) {
        int notificationDefaults = -1;
        PendingIntent clickPendingIntent = null;
        if (!this.notificationSoundEnabled) {
            notificationDefaults = 4;
        }
        this.smallContentView = new RemoteViews(context.getPackageName(), R.layout.hippo_notification_collapsed);
        this.bigContentView = new RemoteViews(context.getPackageName(), R.layout.hippo_notification_expanded);
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setAutoCancel(false).setPriority(this.priority).setCustomContentView(this.smallContentView).setCustomBigContentView(this.bigContentView).setContentIntent(pi);
        try {
            if (!TextUtils.isEmpty((CharSequence)data.optJSONObject("custom_attributes").getString("is_sticky"))) {
                this.smallContentView.setViewVisibility(R.id.txtClear, 0);
                this.bigContentView.setViewVisibility(R.id.txtClear, 0);
                mBuilder.setOngoing(true);
                Intent clickIntent = new Intent(context, NotificationReceiver.class);
                clickIntent.putExtra("channelId", (Serializable)channelId);
                int flags = 0;
                if (Build.VERSION.SDK_INT >= 23) {
                    flags = 0x4000000;
                }
                clickPendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)clickIntent, (int)flags);
                this.smallContentView.setOnClickPendingIntent(R.id.txtClear, clickPendingIntent);
                this.bigContentView.setOnClickPendingIntent(R.id.txtClear, clickPendingIntent);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.smallContentView.setTextViewText(R.id.collapsed_notification_title, (CharSequence)title);
        this.smallContentView.setTextViewText(R.id.collapsed_notification_info, (CharSequence)message);
        this.bigContentView.setTextViewText(R.id.expanded_notification_info, (CharSequence)message);
        this.bigContentView.setTextViewText(R.id.expanded_notification_title, (CharSequence)title);
        if (bitmap != null) {
            Bitmap bit = HippoNotificationConfig.getBitmapFromURL(bitmap);
            this.bigContentView.setImageViewBitmap(R.id.image_view_expanded, bit);
            this.smallContentView.setImageViewBitmap(R.id.image_view_collapsed, bit);
        } else {
            this.bigContentView.setViewVisibility(R.id.image_view_expanded, 8);
            this.smallContentView.setViewVisibility(R.id.image_view_collapsed, 8);
        }
        mBuilder.setDefaults(notificationDefaults);
        mBuilder.setChannelId(CHANNEL_ONE_ID);
        Notification notification = mBuilder.build();
        try {
            if (!TextUtils.isEmpty((CharSequence)data.optJSONObject("custom_attributes").getString("font_color"))) {
                this.smallContentView.setTextColor(R.id.collapsed_notification_title, Color.parseColor((String)("#" + data.optJSONObject("custom_attributes").getString("font_color"))));
                this.smallContentView.setTextColor(R.id.collapsed_notification_info, Color.parseColor((String)("#" + data.optJSONObject("custom_attributes").getString("font_color"))));
                this.bigContentView.setTextColor(R.id.expanded_notification_info, Color.parseColor((String)("#" + data.optJSONObject("custom_attributes").getString("font_color"))));
                this.bigContentView.setTextColor(R.id.expanded_notification_title, Color.parseColor((String)("#" + data.optJSONObject("custom_attributes").getString("font_color"))));
            }
            if (!TextUtils.isEmpty((CharSequence)data.optJSONObject("custom_attributes").getString("notification_color"))) {
                this.smallContentView.setInt(R.id.ll_Collapsed, "setBackgroundColor", Color.parseColor((String)("#" + data.optJSONObject("custom_attributes").getString("notification_color"))));
                this.bigContentView.setInt(R.id.ll_Expanded, "setBackgroundColor", Color.parseColor((String)("#" + data.optJSONObject("custom_attributes").getString("notification_color"))));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        notification.bigContentView = this.bigContentView;
        notification.contentView = this.smallContentView;
        notificationManager = (NotificationManager)context.getSystemService("notification");
        try {
            if (channelId != null && channelId > 0) {
                notificationManager.notify(channelId.intValue(), notification);
                if (!TextUtils.isEmpty((CharSequence)data.optJSONObject("custom_attributes").getString("is_sticky"))) {
                    CommonData.saveData("sticky_channelId", channelId);
                }
            } else if (!TextUtils.isEmpty((CharSequence)data.optJSONObject("custom_attributes").getString("is_sticky"))) {
                int channel = (int)(new Date().getTime() / 1000L % Integer.MAX_VALUE);
                CommonData.saveData("sticky_channelId", channel);
                notificationManager.notify(channel, notification);
            } else {
                notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static Bitmap getBitmapFromURL(String strURL) {
        try {
            URL url = new URL(strURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.connect();
            InputStream input = connection.getInputStream();
            Bitmap myBitmap = BitmapFactory.decodeStream((InputStream)input);
            return myBitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Intent getPendingIntent(Context context, FuguConversation conversation, long labelId, long channelId) {
        if (!AppLifecycleListener.isAppKilled) {
            this.notificationIntent = new Intent(context, FuguChatActivity.class);
            if (conversation.getChannelType() == 7 || conversation.getChannelType() == 6) {
                this.notificationIntent.putExtra("isfromPush", true);
            }
            this.notificationIntent.putExtra("channel_Id_push", conversation.getChannelIdPush());
            this.notificationIntent.putExtra("message", new Gson().toJson((Object)conversation, FuguConversation.class).toString());
            if (channelId < 0L && labelId < 0L) {
                this.notificationIntent = new Intent(context, ChannelActivity.class);
                String title = CommonData.getChatTitleContext();
                if (TextUtils.isEmpty((CharSequence)title)) {
                    title = Restring.getString(context, R.string.fugu_support);
                }
                this.notificationIntent.putExtra("title", title);
                this.notificationIntent.setFlags(0x14000000);
                return this.notificationIntent;
            }
            if (pushChannelId.compareTo(-1L) == 0) {
                this.notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                this.notificationIntent.setFlags(0x14000000);
                return this.notificationIntent;
            }
            Intent mIntent = new Intent("notification_tapped");
            mIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
            return mIntent;
        }
        PackageManager pm = context.getPackageManager();
        this.notificationIntent = pm.getLaunchIntentForPackage(context.getPackageName());
        conversation.setStartChannelsActivity(true);
        this.notificationIntent.putExtra("startChatActivity", true);
        this.notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
        this.notificationIntent.setFlags(0x14000000);
        return this.notificationIntent;
    }
}

