/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.hippo.encription.JsEncryptor;
import com.hippo.service.AppLifecycleListener;
import com.hippo.utils.HippoLog;
import java.util.HashSet;

public final class HippoActivityLifecycleCallback {
    static boolean registered = false;
    public static boolean isAppKilled = false;
    private static final String TAG = HippoActivityLifecycleCallback.class.getSimpleName();
    public static HashSet<String> hippoClasses;
    public static JsEncryptor mJsEncryptor;

    @TargetApi(value=14)
    public static synchronized void registerApplication(Application application) {
        if (application == null) {
            HippoLog.i("register", "Application instance is null/system API is too old");
            return;
        }
        Fresco.initialize((Context)application.getApplicationContext());
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)new AppLifecycleListener(application.getApplicationContext()));
        if (registered) {
            HippoLog.v("register", "Lifecycle callbacks have already been registered");
            return;
        }
        hippoClasses = new HashSet();
        registered = true;
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle bundle) {
                hippoClasses.add(activity.getClass().getName());
                HippoLog.v(TAG, "onActivityCreated " + activity.getClass().getName());
            }

            public void onActivityStarted(Activity activity) {
                HippoLog.v(TAG, "onActivityStarted " + activity.getClass().getSimpleName());
            }

            public void onActivityResumed(Activity activity) {
                isAppKilled = false;
                HippoLog.v(TAG, "onActivityResumed " + activity.getClass().getSimpleName());
            }

            public void onActivityPaused(Activity activity) {
                HippoLog.v(TAG, "onActivityPaused " + activity.getClass().getSimpleName());
            }

            public void onActivityStopped(Activity activity) {
                HippoLog.v(TAG, "onActivityStopped " + activity.getClass().getSimpleName());
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                HippoLog.v(TAG, "onActivitySaveInstanceState " + activity.getClass().getSimpleName());
            }

            public void onActivityDestroyed(Activity activity) {
                HippoLog.v(TAG, "onActivityDestroyed " + activity.getClass().getSimpleName());
                isAppKilled = true;
                hippoClasses.remove(activity.getClass().getSimpleName());
                if (hippoClasses.size() == 0) {
                    HippoLog.w(TAG, "SDK's All classes Destroyed");
                }
            }
        });
        HippoLog.i("In callback", "Activity Lifecycle Callback successfully registered");
    }

    @TargetApi(value=14)
    public static synchronized void register(Application application) {
        HippoActivityLifecycleCallback.registerApplication(application);
        mJsEncryptor = JsEncryptor.evaluateAllScripts(application.getApplicationContext());
    }
}

