/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Property;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.Image;
import com.hippo.utils.HippoLog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.photoview.OnDoubleTap;
import com.hippo.utils.photoview.PhotoView;
import com.hippo.utils.swipeLayout.frame.SwipeableLayout;
import com.hippo.utils.swipeLayout.listener.LayoutShiftListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutPercentageChangeListener;
import com.hippo.utils.swipeLayout.listener.OnLayoutSwipedListener;
import java.io.File;
import java.util.List;

public class ImageDisplayActivityNew
extends FuguBaseActivity
implements EasyPermissions.PermissionCallbacks {
    private boolean hideDownloadBtn = false;
    private SwipeableLayout swipeableLayout;
    private PhotoView ivImageBig;
    private ImageView ivImageGif;
    private Toolbar toolbar;
    private ImageView ivBack;
    private FrameLayout colorContainer;
    private ImageView ivDownload;
    private Image imageUrl = null;
    private int swipedFromDefault = 1;
    private float lastPerc = 0.0f;
    private boolean isTopBarVisivle = true;
    BroadcastReceiver onComplete = new BroadcastReceiver(){

        public void onReceive(Context ctxt, Intent intent) {
            if (intent.getAction() == "android.intent.action.DOWNLOAD_COMPLETE") {
                ImageDisplayActivityNew.this.downloadcompleted();
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_new_image);
        this.imageUrl = (Image)this.getIntent().getSerializableExtra("image");
        this.hideDownloadBtn = this.getIntent().getBooleanExtra("hide_download", false);
        this.swipeableLayout = (SwipeableLayout)this.findViewById(R.id.swipeableLayout);
        this.ivImageBig = (PhotoView)this.findViewById(R.id.ivImageBigNew);
        this.ivImageGif = (ImageView)this.findViewById(R.id.ivImageGif);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.ivBack = (ImageView)this.findViewById(R.id.ivBack);
        this.ivDownload = (ImageView)this.findViewById(R.id.ivDownload);
        this.colorContainer = (FrameLayout)this.findViewById(R.id.colorContainer);
        if (this.hideDownloadBtn) {
            this.ivDownload.setVisibility(8);
        }
        this.ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageDisplayActivityNew.this.onBackPressed();
            }
        });
        this.ivDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageDisplayActivityNew.this.checkPermission()) {
                    ImageDisplayActivityNew.this.downloadFile(ImageDisplayActivityNew.this.imageUrl.getImageUrl());
                } else {
                    ImageDisplayActivityNew.this.requestPermission();
                }
            }
        });
        this.swipeableLayout.setOnLayoutPercentageChangeListener(new OnLayoutPercentageChangeListener(){

            @Override
            public void percentageX(float percentage) {
                super.percentageX(percentage);
            }

            @Override
            public void percentageY(float percentage) {
                super.percentageY(percentage);
                HippoLog.e("percent change", "percentage = " + percentage);
                if (ImageDisplayActivityNew.this.lastPerc != 1.0f) {
                    ImageDisplayActivityNew.this.colorContainer.setAlpha(1.0f - percentage);
                    ImageDisplayActivityNew.this.toolbar.setAlpha(1.0f - percentage);
                }
                ImageDisplayActivityNew.this.lastPerc = percentage;
            }
        });
        this.swipeableLayout.setLayoutShiftListener(new LayoutShiftListener(){

            @Override
            public void onLayoutShifted(float positionX, float positionY, boolean isTouched) {
                HippoLog.e("position Y", "positionY" + positionY);
                if (!isTouched && ImageDisplayActivityNew.this.lastPerc != 1.0f && ImageDisplayActivityNew.this.swipedFromDefault == 1) {
                    ImageDisplayActivityNew.this.colorContainer.setAlpha(1.0f);
                    ImageDisplayActivityNew.this.toolbar.setAlpha(1.0f);
                }
            }
        });
        this.swipeableLayout.setOnSwipedListener(new OnLayoutSwipedListener(){

            @Override
            public void onLayoutSwiped(int swipedFrom) {
                ImageDisplayActivityNew.this.swipedFromDefault = swipedFrom;
                ImageDisplayActivityNew.this.onBackPressed();
            }
        });
        this.ivImageBig.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageDisplayActivityNew.this.isTopBarVisivle) {
                    ImageDisplayActivityNew.this.toolbar.animate().translationY(-150.0f).setDuration(100L);
                } else {
                    ImageDisplayActivityNew.this.toolbar.animate().translationY(0.0f).setDuration(100L);
                }
                ImageDisplayActivityNew.this.isTopBarVisivle = !ImageDisplayActivityNew.this.isTopBarVisivle;
            }
        });
        RequestOptions requestOptions = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).dontTransform();
        this.supportPostponeEnterTransition();
        if (Build.VERSION.SDK_INT >= 21) {
            this.ivImageBig.setTransitionName(this.imageUrl.getTransitionName());
        }
        String fileExt = Util.getExtension(this.imageUrl.getImageUrl());
        boolean isGif = false;
        if (!TextUtils.isEmpty((CharSequence)fileExt) && fileExt.equalsIgnoreCase("gif")) {
            isGif = true;
        } else if (!TextUtils.isEmpty((CharSequence)this.imageUrl.getImageUrl()) && this.imageUrl.getImageUrl().contains("giphy")) {
            isGif = true;
        }
        if (isGif) {
            ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)this.toolbar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
            alphaAnimation.setDuration(500L);
            alphaAnimation.setStartDelay(200L);
            alphaAnimation.start();
            this.supportStartPostponedEnterTransition();
            this.ivImageGif.setVisibility(0);
            this.ivImageBig.setVisibility(8);
            ((RequestBuilder)((RequestBuilder)Glide.with((FragmentActivity)this).asGif().load(this.imageUrl.getImageUrl()).error(R.drawable.hippo_placeholder)).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.ivImageGif);
        } else {
            Glide.with((FragmentActivity)this).load(this.imageUrl.getImageUrl()).apply((BaseRequestOptions)requestOptions).into((Target)new SimpleTarget<Drawable>(){

                public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition2) {
                    ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)ImageDisplayActivityNew.this.toolbar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
                    alphaAnimation.setDuration(500L);
                    alphaAnimation.setStartDelay(200L);
                    alphaAnimation.start();
                    ImageDisplayActivityNew.this.supportStartPostponedEnterTransition();
                    ImageDisplayActivityNew.this.ivImageBig.setImageDrawable(resource);
                }
            });
        }
        this.ivImageBig.setOnDoubleTap(new OnDoubleTap(){

            @Override
            public void onDoubleTap(float zoom) {
                if (zoom <= 1.0f) {
                    ImageDisplayActivityNew.this.swipeableLayout.isSwipeable(true);
                } else {
                    ImageDisplayActivityNew.this.swipeableLayout.isSwipeable(false);
                }
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.supportFinishAfterTransition();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    private void downloadFile(String url) {
        try {
            String fileName = Util.extractFileNameWithoutSuffix(url);
            String ext = Util.getExtension(url);
            DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
            request.setDescription((CharSequence)CommonData.getUserDetails().getData().getBusinessName());
            request.setTitle((CharSequence)fileName);
            request.allowScanningByMediaScanner();
            request.setNotificationVisibility(1);
            String directory = Environment.DIRECTORY_DOWNLOADS + File.separator + "hippo" + File.separator;
            request.setDestinationInExternalFilesDir((Context)this, directory, fileName + "." + ext);
            request.setMimeType("image/jpeg");
            DownloadManager manager = (DownloadManager)this.getSystemService("download");
            this.registerReceiver(this.onComplete, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
            if (manager != null) {
                manager.enqueue(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void downloadcompleted() {
        try {
            ToastUtil.getInstance((Context)this).showToast(Restring.getString((Context)this, R.string.download_complete));
            if (this.onComplete != null) {
                this.unregisterReceiver(this.onComplete);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void requestPermission() {
        String text = Restring.getString((Context)this, R.string.vw_rationale_storage);
        if (Build.VERSION.SDK_INT < 33) {
            EasyPermissions.requestPermissions((Activity)this, text, 123, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        } else {
            EasyPermissions.requestPermissions((Activity)this, text, 123, "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_IMAGES");
        }
    }

    private boolean checkPermission() {
        if (Build.VERSION.SDK_INT < 33) {
            return EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
        return EasyPermissions.hasPermissions((Context)this, "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_IMAGES");
    }

    @Override
    public void onPermissionsGranted(int requestCode, @NonNull List<String> perms) {
        if (this.imageUrl != null && !TextUtils.isEmpty((CharSequence)this.imageUrl.getImageUrl())) {
            this.downloadFile(this.imageUrl.getImageUrl());
        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, @NonNull List<String> perms) {
        String text = Restring.getString((Context)this, R.string.hippo_storage_permission);
        ToastUtil.getInstance((Context)this).showToast(text);
    }
}

