/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.MediaController;
import android.widget.Toast;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.Toolbar;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.langs.Restring;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import java.util.List;

public class VideoPlayerActivity
extends FuguBaseActivity
implements EasyPermissions.PermissionCallbacks {
    private static final String TAG = VideoPlayerActivity.class.getSimpleName();
    private VideoView videoView;
    private Toolbar myToolbar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_video_player);
        this.myToolbar = (Toolbar)this.findViewById(R.id.my_toolbar);
        this.setSupportActionBar(this.myToolbar);
        this.videoView = (VideoView)this.findViewById(R.id.videoView);
        this.readExternalStorage();
        String text = Restring.getString((Context)this, R.string.fugu_video);
        String name = TextUtils.isEmpty((CharSequence)this.getIntent().getStringExtra("title")) ? text : this.getIntent().getStringExtra("title");
        this.setToolbar(this.myToolbar, name);
    }

    private void permissionGranted() {
        MediaController mediaController = new MediaController((Context)this);
        mediaController.setAnchorView((View)this.videoView);
        mediaController.setMediaPlayer((MediaController.MediaPlayerControl)this.videoView);
        mediaController.setEnabled(true);
        this.videoView.setMediaController(mediaController);
        this.videoView.setVideoURI(Uri.parse((String)this.getIntent().getStringExtra("url")));
        this.videoView.requestFocus();
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.start();
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                String text = Restring.getString((Context)VideoPlayerActivity.this, R.string.hippo_file_not_supported);
                String ok = Restring.getString((Context)VideoPlayerActivity.this, R.string.fugu_ok);
                VideoPlayerActivity.this.showErrorMessage(text, ok, VideoPlayerActivity.this.getIntent().getStringExtra("url"));
                return true;
            }
        });
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final String localPath) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String cancel = Restring.getString((Context)VideoPlayerActivity.this, R.string.fugu_cancel);
                new AlertDialog.Builder((Context)VideoPlayerActivity.this).setMessage((CharSequence)errorMessage).setPositiveButton((CharSequence)positiveButtonText, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        VideoPlayerActivity.this.openFile(localPath);
                        dialog.dismiss();
                    }
                }).setNegativeButton((CharSequence)cancel, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        VideoPlayerActivity.this.finish();
                    }
                }).setCancelable(false).show();
            }
        });
    }

    private void openFile(String localPath) {
        if (!TextUtils.isEmpty((CharSequence)localPath)) {
            FileManager.getInstance().openFileInDevice((Context)this, localPath, new FileManager.FileCopyListener(){

                @Override
                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                }

                @Override
                public void largeFileSize() {
                }

                @Override
                public void onError() {
                    String text = Restring.getString((Context)VideoPlayerActivity.this, R.string.no_handler);
                    Toast.makeText((Context)VideoPlayerActivity.this, (CharSequence)text, (int)1).show();
                    VideoPlayerActivity.this.finish();
                }
            });
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @AfterPermissionGranted(value=123)
    private void readExternalStorage() {
        boolean isGranted = Build.VERSION.SDK_INT >= 33 ? EasyPermissions.hasPermissions((Context)this, "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO") : EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (isGranted) {
            this.permissionGranted();
        } else {
            String text = Restring.getString((Context)this, R.string.vw_rationale_storage);
            if (Build.VERSION.SDK_INT >= 33) {
                EasyPermissions.requestPermissions((Activity)this, text, 123, "android.permission.READ_MEDIA_VIDEO", "android.permission.READ_MEDIA_IMAGES");
            } else {
                EasyPermissions.requestPermissions((Activity)this, text, 123, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
            }
        }
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsGranted:" + requestCode + ":" + perms.size()));
        this.permissionGranted();
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> perms) {
        Log.d((String)TAG, (String)("onPermissionsDenied:" + requestCode + ":" + perms.size()));
        if (EasyPermissions.somePermissionPermanentlyDenied((Activity)this, perms)) {
            new AppSettingsDialog.Builder((Activity)this).setIsManageStoragePermission(0).build().show();
        } else {
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 16061) {
            boolean isGranted = Build.VERSION.SDK_INT >= 33 ? EasyPermissions.hasPermissions((Context)this, "android.permission.READ_MEDIA_IMAGES", "android.permission.READ_MEDIA_VIDEO") : EasyPermissions.hasPermissions((Context)this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
            if (isGranted) {
                this.permissionGranted();
            } else {
                this.finish();
            }
        }
    }
}

