/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.activity.ImageDisplayActivity;
import com.hippo.activity.VideoPlayerActivity;
import com.hippo.model.Attachment;
import com.hippo.model.Image;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000245B-\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010 \u001a\u00020!2\u0016\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006J\b\u0010\"\u001a\u00020#H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020#H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020#H\u0016J0\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020/2\u0006\u00103\u001a\u00020/H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00066"}, d2={"Lcom/hippo/adapter/AttachmentAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/hippo/adapter/AttachmentAdapter$ViewHolder;", "attachment", "Ljava/util/ArrayList;", "Lcom/hippo/model/Attachment;", "Lkotlin/collections/ArrayList;", "activity", "Landroid/app/Activity;", "onAttachmentClick", "Lcom/hippo/adapter/AttachmentAdapter$OnAttachmentClick;", "(Ljava/util/ArrayList;Landroid/app/Activity;Lcom/hippo/adapter/AttachmentAdapter$OnAttachmentClick;)V", "getActivity", "()Landroid/app/Activity;", "setActivity", "(Landroid/app/Activity;)V", "getAttachment", "()Ljava/util/ArrayList;", "setAttachment", "(Ljava/util/ArrayList;)V", "mContext", "Landroid/content/Context;", "getMContext", "()Landroid/content/Context;", "setMContext", "(Landroid/content/Context;)V", "myOptions", "Lcom/bumptech/glide/request/RequestOptions;", "getOnAttachmentClick", "()Lcom/hippo/adapter/AttachmentAdapter$OnAttachmentClick;", "setOnAttachmentClick", "(Lcom/hippo/adapter/AttachmentAdapter$OnAttachmentClick;)V", "addAttachment", "", "getItemCount", "", "getRequestOption", "onBindViewHolder", "holder1", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "showImageDialog", "context", "imgUrl", "", "imageView", "Landroid/widget/ImageView;", "name", "time", "OnAttachmentClick", "ViewHolder", "hippo_release"})
public final class AttachmentAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NotNull
    private ArrayList<Attachment> attachment;
    @NotNull
    private Activity activity;
    public Context mContext;
    @Nullable
    private RequestOptions myOptions;
    @NotNull
    private OnAttachmentClick onAttachmentClick;

    public AttachmentAdapter(@NotNull ArrayList<Attachment> attachment, @NotNull Activity activity, @NotNull OnAttachmentClick onAttachmentClick) {
        Intrinsics.checkNotNullParameter(attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)onAttachmentClick, (String)"onAttachmentClick");
        this.attachment = attachment;
        this.activity = activity;
        this.onAttachmentClick = onAttachmentClick;
    }

    @NotNull
    public final ArrayList<Attachment> getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(@NotNull ArrayList<Attachment> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.attachment = arrayList;
    }

    @NotNull
    public final Activity getActivity() {
        return this.activity;
    }

    public final void setActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"<set-?>");
        this.activity = activity;
    }

    @NotNull
    public final Context getMContext() {
        Context context = this.mContext;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"mContext");
        return null;
    }

    public final void setMContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.mContext = context;
    }

    @NotNull
    public final OnAttachmentClick getOnAttachmentClick() {
        return this.onAttachmentClick;
    }

    public final void setOnAttachmentClick(@NotNull OnAttachmentClick onAttachmentClick) {
        Intrinsics.checkNotNullParameter((Object)onAttachmentClick, (String)"<set-?>");
        this.onAttachmentClick = onAttachmentClick;
    }

    public final void addAttachment(@NotNull ArrayList<Attachment> attachment) {
        Intrinsics.checkNotNullParameter(attachment, (String)"attachment");
        this.attachment = attachment;
        this.notifyDataSetChanged();
    }

    @NotNull
    public ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Context context = parent.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"parent.context");
        this.setMContext(context);
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.adapter_attachment, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"from(parent.context).inf\u2026_attachment,parent,false)");
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NotNull ViewHolder holder1, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder1), (String)"holder1");
        View view = holder1.itemView;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder1.itemView");
        View holder = view;
        Attachment attachment = this.attachment.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"attachment[position]");
        Attachment data = attachment;
        ((ImageView)holder.findViewById(R.id.ivAttachImage)).setOnClickListener(arg_0 -> AttachmentAdapter.onBindViewHolder$lambda-0(position, this, arg_0));
        ((ImageView)holder.findViewById(R.id.ivCross)).setOnClickListener(arg_0 -> AttachmentAdapter.onBindViewHolder$lambda-1(this, position, arg_0));
        if (data.showAddBtn()) {
            ((ImageView)holder.findViewById(R.id.ivAttachImage)).setImageResource(R.drawable.ticket_add);
            ((ImageView)holder.findViewById(R.id.ivCross)).setVisibility(8);
        } else {
            String string2 = data.getType();
            Intrinsics.checkNotNull((Object)string2);
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"image", (boolean)false, (int)2, null)) {
                ((ImageView)holder.findViewById(R.id.ivPlay)).setVisibility(8);
                RequestBuilder requestBuilder = Glide.with((Context)this.getMContext()).load(data.getPath());
                RequestOptions requestOptions = this.getRequestOption();
                Intrinsics.checkNotNull((Object)requestOptions);
                ((RequestBuilder)requestBuilder.apply((BaseRequestOptions)requestOptions).placeholder(R.drawable.ticket_image)).into((ImageView)holder.findViewById(R.id.ivAttachImage));
                ((ImageView)holder.findViewById(R.id.ivAttachImage)).setOnClickListener(arg_0 -> AttachmentAdapter.onBindViewHolder$lambda-2(this, data, holder, arg_0));
            } else {
                String string3 = data.getType();
                Intrinsics.checkNotNull((Object)string3);
                if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"video", (boolean)false, (int)2, null)) {
                    ((ImageView)holder.findViewById(R.id.ivPlay)).setVisibility(0);
                    RequestBuilder requestBuilder = Glide.with((Context)this.getMContext()).load(data.getPath());
                    RequestOptions requestOptions = this.getRequestOption();
                    Intrinsics.checkNotNull((Object)requestOptions);
                    ((RequestBuilder)requestBuilder.apply((BaseRequestOptions)requestOptions).placeholder(R.drawable.ticket_video)).into((ImageView)holder.findViewById(R.id.ivAttachImage));
                    ((ImageView)holder.findViewById(R.id.ivAttachImage)).setOnClickListener(arg_0 -> AttachmentAdapter.onBindViewHolder$lambda-3(this, data, arg_0));
                } else {
                    ((ImageView)holder.findViewById(R.id.ivPlay)).setVisibility(8);
                    ((ImageView)holder.findViewById(R.id.ivAttachImage)).setImageResource(R.drawable.ticket_document);
                }
            }
        }
    }

    public int getItemCount() {
        return this.attachment.size();
    }

    private final void showImageDialog(Activity context, String imgUrl, ImageView imageView, String name, String time) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            String thumbUrl = imgUrl;
            String fileUrl = imgUrl;
            Intent imageIntent = new Intent((Context)context, ImageDisplayActivity.class);
            Image image = new Image(fileUrl, thumbUrl, name, time, name);
            imageIntent.putExtra("image", (Serializable)image);
            imageIntent.putExtra("isFromTicket", true);
            ActivityOptionsCompat activityOptionsCompat = ActivityOptionsCompat.makeSceneTransitionAnimation((Activity)context, (View)((View)imageView), (String)name);
            Intrinsics.checkNotNullExpressionValue((Object)activityOptionsCompat, (String)"makeSceneTransitionAnima\u2026context, imageView, name)");
            ActivityOptionsCompat options = activityOptionsCompat;
            context.startActivity(imageIntent, options.toBundle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final RequestOptions getRequestOption() {
        if (this.myOptions == null) {
            this.myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation(this.getMContext(), 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.getMContext(), (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.getMContext(), (int)R.drawable.hippo_placeholder));
        }
        return this.myOptions;
    }

    private static final void onBindViewHolder$lambda-0(int $position, AttachmentAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if ($position == 0) {
            this$0.onAttachmentClick.onClick($position);
        }
    }

    private static final void onBindViewHolder$lambda-1(AttachmentAdapter this$0, int $position, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onAttachmentClick.onDelete($position);
    }

    private static final void onBindViewHolder$lambda-2(AttachmentAdapter this$0, Attachment $data, View $holder, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)$holder, (String)"$holder");
        Activity activity = this$0.activity;
        String string2 = $data.getPath();
        Intrinsics.checkNotNull((Object)string2);
        ImageView imageView = (ImageView)$holder.findViewById(R.id.ivAttachImage);
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"holder.ivAttachImage");
        String string3 = $data.getName();
        Intrinsics.checkNotNull((Object)string3);
        this$0.showImageDialog(activity, string2, imageView, string3, "");
    }

    private static final void onBindViewHolder$lambda-3(AttachmentAdapter this$0, Attachment $data, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intent intent = new Intent((Context)this$0.activity, VideoPlayerActivity.class);
        String string2 = $data.getPath();
        Intrinsics.checkNotNull((Object)string2);
        intent.putExtra("url", string2);
        String string3 = $data.getName();
        Intrinsics.checkNotNull((Object)string3);
        intent.putExtra("title", string3);
        this$0.activity.startActivity(intent);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/hippo/adapter/AttachmentAdapter$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "hippo_release"})
    public static final class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/hippo/adapter/AttachmentAdapter$OnAttachmentClick;", "", "onClick", "", "position", "", "onDelete", "hippo_release"})
    public static interface OnAttachmentClick {
        public void onClick(int var1);

        public void onDelete(int var1);
    }
}

