/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.model.attachmentData.AttachmentDataList;
import com.hippo.utils.filepicker.Util;
import java.util.ArrayList;

public class MediaFileItemAdapter
extends RecyclerView.Adapter {
    private final ItemListener mListener;
    Context mContext;
    ArrayList<AttachmentDataList> dataList = new ArrayList();

    public MediaFileItemAdapter(Context context, ArrayList<AttachmentDataList> values, ItemListener mListener) {
        this.mContext = context;
        this.dataList = values;
        this.mListener = mListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.media_list_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ViewHolder viewholder = (ViewHolder)holder;
        RequestOptions options = (RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).placeholder(R.drawable.hippo_placeholder)).error(R.drawable.hippo_placeholder);
        if (this.dataList.get(position).getDocument_type() != null && !this.dataList.get(position).getDocument_type().isEmpty() && this.dataList.get(position).getDocument_type().contains("video")) {
            viewholder.videoRL.setVisibility(0);
            Glide.with((Context)this.mContext).load(this.dataList.get(position).getThumbnailUrl()).apply((BaseRequestOptions)options).into(viewholder.imageView);
        } else if (this.dataList.get(position).getDocument_type() != null && !this.dataList.get(position).getDocument_type().isEmpty() && !this.dataList.get(position).getDocument_type().contains("image")) {
            viewholder.imageView.setImageDrawable(ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.doc));
            viewholder.videoRL.setVisibility(8);
        } else {
            viewholder.videoRL.setVisibility(8);
            String fileExt = Util.getExtension(this.dataList.get(position).getThumbnailUrl());
            boolean isGif = false;
            if (!TextUtils.isEmpty((CharSequence)fileExt) && fileExt.equalsIgnoreCase("gif")) {
                isGif = true;
            } else if (!TextUtils.isEmpty((CharSequence)this.dataList.get(position).getThumbnailUrl()) && this.dataList.get(position).getThumbnailUrl().contains("giphy")) {
                isGif = true;
            }
            if (isGif) {
                RequestOptions ops = (RequestOptions)new RequestOptions().fitCenter();
                ((RequestBuilder)Glide.with((Context)this.mContext).asGif().apply((BaseRequestOptions)ops).load(this.dataList.get(position).getImageUrl()).error(R.drawable.hippo_placeholder)).into(viewholder.imageView);
            } else {
                Glide.with((Context)this.mContext).load(this.dataList.get(position).getThumbnailUrl()).apply((BaseRequestOptions)options).into(viewholder.imageView);
            }
        }
        viewholder.llParent.setTag((Object)position);
        viewholder.llParent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int pos = (Integer)v.getTag();
                if (MediaFileItemAdapter.this.mListener != null) {
                    MediaFileItemAdapter.this.mListener.onItemClick(MediaFileItemAdapter.this.dataList.get(pos), v);
                }
            }
        });
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    public static interface ItemListener {
        public void onItemClick(AttachmentDataList var1, View var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        public ImageView imageView;
        public RelativeLayout llParent;
        public RelativeLayout videoRL;

        public ViewHolder(View v) {
            super(v);
            this.imageView = (ImageView)v.findViewById(R.id.imageView);
            this.llParent = (RelativeLayout)v.findViewById(R.id.llParent);
            this.videoRL = (RelativeLayout)v.findViewById(R.id.videoRL);
        }
    }
}

