/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.app.Activity;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.PagerAdapter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.callback.OnPromotionalDialogButtonClick;
import com.hippo.database.CommonData;
import com.hippo.model.promotionalPopupData.Button;
import com.hippo.model.promotionalPopupData.Datum;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.filepicker.Util;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import retrofit2.Callback;

public class ViewPagerAdapter
extends PagerAdapter {
    private Activity activity;
    private ArrayList<Datum> mResources;
    private OnPromotionalDialogButtonClick onPromotionalDialogButtonClick;
    private Dialog dialog;

    public ViewPagerAdapter(Activity activity, ArrayList<Datum> mResources, OnPromotionalDialogButtonClick onPromotionalDialogButtonClick, Dialog dialog) {
        this.activity = activity;
        this.mResources = mResources;
        this.onPromotionalDialogButtonClick = onPromotionalDialogButtonClick;
        this.dialog = dialog;
    }

    public int getCount() {
        return this.mResources.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == (RelativeLayout)object;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View itemView = LayoutInflater.from((Context)this.activity).inflate(R.layout.promotion_banner_view, container, false);
        Datum data = this.mResources.get(position);
        android.widget.Button buttonTwoBT = (android.widget.Button)itemView.findViewById(R.id.buttonTwoBT);
        android.widget.Button buttonOneBT = (android.widget.Button)itemView.findViewById(R.id.buttonOneBT);
        TextView descriptionTV = (TextView)itemView.findViewById(R.id.descriptionTV);
        TextView titleTV = (TextView)itemView.findViewById(R.id.titleTV);
        ImageView promoImageIV = (ImageView)itemView.findViewById(R.id.promoImageIV);
        titleTV.setText((CharSequence)data.getTitle());
        descriptionTV.setText((CharSequence)data.getDescription());
        buttonTwoBT.setVisibility(8);
        buttonOneBT.setVisibility(8);
        if (data.getCustomAttributes() != null && data.getCustomAttributes().getButtons() != null && data.getCustomAttributes().getButtons().size() > 0) {
            GradientDrawable drawable2;
            if (data.getCustomAttributes().getButtons().size() == 1) {
                buttonOneBT.setVisibility(0);
                buttonTwoBT.setVisibility(8);
                buttonOneBT.setText((CharSequence)data.getCustomAttributes().getButtons().get(0).getLabel());
                buttonOneBT.setTextColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(0).getTextColor()));
                buttonOneBT.setBackgroundColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
                buttonOneBT.setBackgroundResource(R.drawable.hippo_rounded_corners);
                drawable2 = (GradientDrawable)buttonOneBT.getBackground();
                drawable2.setColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
            } else if (data.getCustomAttributes().getButtons().size() == 2) {
                buttonTwoBT.setText((CharSequence)data.getCustomAttributes().getButtons().get(1).getLabel());
                buttonTwoBT.setTextColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(1).getTextColor()));
                buttonTwoBT.setBackgroundColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(1).getBackgroundColor()));
                buttonOneBT.setBackgroundColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
                buttonOneBT.setText((CharSequence)data.getCustomAttributes().getButtons().get(0).getLabel());
                buttonOneBT.setTextColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(0).getTextColor()));
                buttonTwoBT.setBackgroundResource(R.drawable.hippo_rounded_corners);
                buttonOneBT.setBackgroundResource(R.drawable.hippo_rounded_corners);
                drawable2 = (GradientDrawable)buttonOneBT.getBackground();
                GradientDrawable drawable1 = (GradientDrawable)buttonTwoBT.getBackground();
                drawable2.setColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(0).getBackgroundColor()));
                drawable1.setColor(Color.parseColor((String)data.getCustomAttributes().getButtons().get(1).getBackgroundColor()));
                buttonOneBT.setVisibility(0);
                buttonTwoBT.setVisibility(0);
            }
            buttonOneBT.setTag((Object)position);
            buttonOneBT.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int pos = (Integer)view.getTag();
                    ViewPagerAdapter.this.sendButtonClicked(((Datum)ViewPagerAdapter.this.mResources.get(pos)).getCustomAttributes().getButtons().get(0), ((Datum)ViewPagerAdapter.this.mResources.get(pos)).getChannelId().toString());
                    ViewPagerAdapter.this.dialog.dismiss();
                }
            });
            buttonTwoBT.setTag((Object)position);
            buttonTwoBT.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int pos = (Integer)view.getTag();
                    ViewPagerAdapter.this.sendButtonClicked(((Datum)ViewPagerAdapter.this.mResources.get(pos)).getCustomAttributes().getButtons().get(1), ((Datum)ViewPagerAdapter.this.mResources.get(pos)).getChannelId().toString());
                    ViewPagerAdapter.this.dialog.dismiss();
                }
            });
        } else {
            buttonTwoBT.setVisibility(8);
            buttonTwoBT.setVisibility(8);
        }
        if (data.getCustomAttributes().getImage() != null) {
            if (data.getCustomAttributes().getImage().getImageUrl() != null && !data.getCustomAttributes().getImage().getImageUrl().isEmpty()) {
                promoImageIV.setVisibility(0);
                String fileExt = Util.getExtension(data.getCustomAttributes().getImage().getImageUrl());
                Display display = this.activity.getWindowManager().getDefaultDisplay();
                int width = display.getWidth();
                int height = display.getHeight();
                LinearLayout.LayoutParams parms = new LinearLayout.LayoutParams(width, width);
                promoImageIV.setLayoutParams((ViewGroup.LayoutParams)parms);
                promoImageIV.setScaleX(0.93f);
                promoImageIV.requestLayout();
                RequestOptions myOptions = (RequestOptions)((RequestOptions)((RequestOptions)((RequestOptions)RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.activity, 10, 1)).placeholder(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder))).dontAnimate()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder));
                boolean isGif = false;
                if (!TextUtils.isEmpty((CharSequence)fileExt) && fileExt.equalsIgnoreCase("gif")) {
                    isGif = true;
                } else if (!TextUtils.isEmpty((CharSequence)data.getCustomAttributes().getImage().getImageUrl()) && data.getCustomAttributes().getImage().getImageUrl().contains("giphy")) {
                    isGif = true;
                }
                if (isGif) {
                    ((RequestBuilder)Glide.with((Activity)this.activity).load(data.getCustomAttributes().getImage().getImageUrl()).thumbnail(Glide.with((Activity)this.activity).load(data.getCustomAttributes().getImage().getImageUrl())).fitCenter()).into(promoImageIV);
                } else {
                    ((RequestBuilder)((RequestBuilder)Glide.with((Activity)this.activity).load(data.getCustomAttributes().getImage().getImageUrl()).fitCenter()).apply((BaseRequestOptions)myOptions).transform(new Transformation[]{new CenterCrop(), new RoundedCorners(1)})).into(promoImageIV);
                }
            } else {
                promoImageIV.setVisibility(8);
            }
        }
        container.addView(itemView);
        return itemView;
    }

    private void sendButtonClicked(Button butonData, String channelID) {
        block11: {
            try {
                JSONArray open_links = new JSONArray();
                JSONObject obj = new JSONObject();
                obj.put("time", (Object)(System.currentTimeMillis() + ""));
                obj.put("link", (Object)butonData.getUrl());
                open_links.put((Object)obj);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("channel_id", channelID);
                params.put("en_user_id", CommonData.getUserDetails().getData().getEn_user_id());
                params.put("app_secret_key", HippoConfig.getInstance().getAppKey());
                params.put("is_clicked", 1);
                if (butonData.getActionType() != 2) {
                    params.put("open_links", open_links);
                }
                RestClient.getApiInterface().advanceSpecApi(params).enqueue((Callback)new ResponseResolver<CommonResponse>(){

                    @Override
                    public void success(CommonResponse commonResponse) {
                    }

                    @Override
                    public void failure(APIError error) {
                    }
                });
                if (butonData.getActionType() == 2) {
                    try {
                        JSONObject jsonObject = ViewPagerAdapter.objectToJSONObject(butonData.getCallback_data());
                        if (this.onPromotionalDialogButtonClick != null) {
                            this.onPromotionalDialogButtonClick.OnButtonClick(jsonObject);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        if (HippoConfig.DEBUG) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                }
                if (butonData.getUrl().startsWith("http://") || butonData.getUrl().startsWith("https://")) {
                    try {
                        Intent myIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)butonData.getUrl()));
                        this.activity.startActivity(myIntent);
                    }
                    catch (ActivityNotFoundException e) {
                        Toast.makeText((Context)this.activity, (CharSequence)"No application can handle this request. Please install a webbrowser", (int)1).show();
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)((RelativeLayout)object));
    }

    public static JSONObject objectToJSONObject(Object object) {
        JSONObject jsonObject;
        Object json;
        block3: {
            json = null;
            jsonObject = null;
            try {
                json = new JSONTokener(object.toString()).nextValue();
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        if (json instanceof JSONObject) {
            jsonObject = (JSONObject)json;
        }
        return jsonObject;
    }

    public boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }
}

