/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.apis;

import android.app.Activity;
import android.text.TextUtils;
import com.hippo.HippoConfig;
import com.hippo.NotificationListener;
import com.hippo.interfaces.OnClearNotificationListener;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import java.util.ArrayList;
import retrofit2.Callback;

public class ApiGetMobileNotification {
    private Activity activity;
    private NotificationListener listener;
    private OnClearNotificationListener onClearNotificationListener;

    public ApiGetMobileNotification(Activity activity, NotificationListener listener) {
        this.activity = activity;
        this.listener = listener;
    }

    public ApiGetMobileNotification(Activity activity, OnClearNotificationListener onClearNotificationListener) {
        this.activity = activity;
        this.onClearNotificationListener = onClearNotificationListener;
    }

    public void getNotificationData(int startOffset, int endOffset, boolean isSeenStatus) {
        if (TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getAppKey()) || TextUtils.isEmpty((CharSequence)HippoConfig.getInstance().getUserData().getEnUserId())) {
            return;
        }
        CommonParams params = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId()).add("start_offset", startOffset).add("end_offset", endOffset).build();
        if (isSeenStatus) {
            params.getMap().put("seen_status", 1);
            params.getMap().put("app_opened_through_push", 1);
        }
        RestClient.getApiInterface().fetchMobilePush(params.getMap()).enqueue((Callback)new ResponseResolver<PromotionResponse>(){

            @Override
            public void success(PromotionResponse promotionResponse) {
                if (ApiGetMobileNotification.this.listener != null) {
                    ApiGetMobileNotification.this.listener.onSucessListener(promotionResponse);
                }
            }

            @Override
            public void failure(APIError error) {
                if (ApiGetMobileNotification.this.listener != null) {
                    ApiGetMobileNotification.this.listener.onFailureListener();
                }
            }
        });
    }

    public void clearNotification(long channelId, final int position) {
        CommonParams.Builder builder = new CommonParams.Builder();
        builder.add("app_secret_key", HippoConfig.getInstance().getAppKey());
        builder.add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId());
        if (channelId > 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(channelId);
            builder.add("channel_ids", ids);
            builder.add("delete_all_announcements", 0);
        } else {
            builder.add("delete_all_announcements", 1);
        }
        CommonParams params = builder.build();
        RestClient.getApiInterface().clearMobilePush(params.getMap()).enqueue((Callback)new ResponseResolver<CommonResponse>(this.activity, Boolean.valueOf(true), Boolean.valueOf(true)){

            @Override
            public void success(CommonResponse promotionResponse) {
                if (ApiGetMobileNotification.this.onClearNotificationListener != null) {
                    ApiGetMobileNotification.this.onClearNotificationListener.onSucessListener(position);
                }
            }

            @Override
            public void failure(APIError error) {
                if (ApiGetMobileNotification.this.onClearNotificationListener != null) {
                    ApiGetMobileNotification.this.onClearNotificationListener.onFailure();
                }
            }
        });
    }
}

