/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.calling;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.calling.CommonData;
import com.hippo.calling.WebRTCCallConstants;
import com.hippo.calling.confcall.HungUpBroadcast;
import com.hippo.calling.confcall.OngoingCallService;
import com.hippo.constant.FuguAppConstant;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import faye.ConnectionManager;
import faye.ConnectionUtils;
import java.util.HashMap;
import org.json.JSONObject;

public class CallConfig
implements FuguAppConstant {
    private static CallConfig jitsiConfig;
    private String jitsiURL = "";
    public HashMap<String, String> authObj = new HashMap();
    private int hippoCallPushIcon = R.drawable.hippo_default_notif_icon;
    private Context context;
    private JSONObject jsonObject;
    boolean emitUserBusy;

    public CallConfig getInstance() {
        if (jitsiConfig == null) {
            jitsiConfig = new CallConfig();
        }
        return jitsiConfig;
    }

    public String getJitsiURL() {
        if (TextUtils.isEmpty((CharSequence)this.jitsiURL) && com.hippo.database.CommonData.getUserDetails() != null && com.hippo.database.CommonData.getUserDetails().getData() != null && !TextUtils.isEmpty((CharSequence)com.hippo.database.CommonData.getUserDetails().getData().getJitsiUrl())) {
            this.jitsiURL = com.hippo.database.CommonData.getUserDetails().getData().getJitsiUrl();
        }
        return this.jitsiURL;
    }

    public Context getContext() {
        return HippoConfig.getInstance().getContext();
    }

    public void sendMessage(Long channelId, JSONObject jsonObject) {
        ConnectionManager.INSTANCE.publish("/" + channelId, jsonObject);
    }

    public void onStartConferenceCall(Context context, JSONObject jsonObject) throws Exception {
        HippoLog.v("TAG", "jsonObject = " + jsonObject.toString());
        this.context = context;
        this.jsonObject = jsonObject;
        if (jsonObject.has("video_call_type")) {
            if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.START_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.isConferenceConnected()) {
                    this.emitUserBusy = true;
                    this.sendBusyStatus(jsonObject);
                } else {
                    Long channelId = jsonObject.optLong("channel_id");
                    ConnectionManager.INSTANCE.initFayeConnection();
                    ConnectionManager.INSTANCE.subScribeChannel("/" + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
                    ConnectionManager.INSTANCE.unsubScribeChannel("/" + channelId);
                    ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.HUNGUP_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra("muid", jsonObject.getString("muid"));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    mIntent2.putExtra("jitsi_url", jsonObject.optString("jitsi_url"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                } else if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.REJECT_CONFERENCE.toString())) {
                if (OngoingCallService.NotificationServiceState.INSTANCE.getInviteLink().equals(jsonObject.optString("invite_link"))) {
                    Intent hungupIntent = new Intent(context, HungUpBroadcast.class);
                    hungupIntent.putExtra("action", "rejectCall");
                    hungupIntent.putExtra("muid", jsonObject.getString("muid"));
                    context.sendBroadcast(hungupIntent);
                    Intent mIntent = new Intent("CALL_HANGUP");
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent);
                    Intent mIntent2 = new Intent("video_conference_hungup_intent");
                    mIntent2.putExtra("invite_link", jsonObject.getString("invite_link"));
                    mIntent2.putExtra("jitsi_url", jsonObject.optString("jitsi_url"));
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(mIntent2);
                } else if (!ConnectionUtils.INSTANCE.isAppRunning(context)) {
                    ConnectionManager.INSTANCE.onClose();
                }
            } else if (jsonObject.getString("video_call_type").equals(FuguAppConstant.JitsiCallType.START_GROUP_CALL.toString())) {
                Long channelId = jsonObject.optLong("channel_id");
                ConnectionManager.INSTANCE.initFayeConnection();
                ConnectionManager.INSTANCE.subScribeChannel("/" + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
                ConnectionManager.INSTANCE.subScribeChannel("/" + channelId);
            }
        }
    }

    public int getHippoCallPushIcon() {
        return this.hippoCallPushIcon;
    }

    public JSONObject getDeviceDetails(Context context) {
        try {
            JSONObject devicePayload = new JSONObject();
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId(context));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)HippoConfig.getInstance().getVersionName());
            devicePayload.put("device_details", (Object)CommonData.deviceDetails(context));
            return devicePayload;
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public void saveData(String key, String value) {
        this.authObj.put(key, value);
    }

    public String getAuthObj(String key) {
        return this.authObj.get(key);
    }

    private void sendBusyStatus(JSONObject jsonObject) {
        this.sendBusyStatus(jsonObject, 1);
    }

    private void sendBusyStatus(JSONObject jsonObject, int type) {
        try {
            Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
            JSONObject startCallJson = new JSONObject();
            startCallJson.put("is_silent", false);
            if (type == 1) {
                startCallJson.put("video_call_type", (Object)FuguAppConstant.JitsiCallType.USER_BUSY_CONFERENCE);
                startCallJson.put("message_type", 18);
            } else {
                startCallJson.put("video_call_type", (Object)WebRTCCallConstants.VideoCallType.REJECT_GROUP_CALL);
                startCallJson.put("message_type", 27);
            }
            startCallJson.put("user_id", (Object)userId);
            startCallJson.put("channel_id", (Object)jsonObject.optString("channel_id"));
            startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
            startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails(this.context));
            startCallJson.put("invite_link", (Object)jsonObject.optString("invite_link"));
            startCallJson.put("muid", (Object)jsonObject.optString("muid"));
            startCallJson.put(WebRTCCallConstants.Companion.getFULL_NAME(), (Object)jsonObject.optString("full_name", ""));
            startCallJson.put("message", (Object)"");
            startCallJson.put("is_typing", 0);
            startCallJson.put("user_type", 1);
            this.sendMessage(jsonObject.optLong("channel_id"), startCallJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

