/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.calling;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.calling.CallConfig;
import com.hippo.calling.CommonData;
import com.hippo.calling.HippoCallingFlow;
import com.hippo.calling.MainCallingActivity;
import com.hippo.calling.VideoCallModel;
import com.hippo.calling.VideoCallService;
import com.hippo.calling.VideoSdkMeetingActivity;
import com.hippo.calling.WebRTCCallConstants;
import com.hippo.calling.confcall.HippoAudioManager;
import com.hippo.calling.confcall.HungUpBroadcast;
import com.hippo.calling.confcall.IncomingGroupCall;
import com.hippo.calling.confcall.IncomingJitsiCallActivity;
import com.hippo.calling.confcall.JitsiCallOutgoingActivity;
import com.hippo.calling.confcall.OngoingCallService;
import com.hippo.calling.model.FragmentFlow;
import com.hippo.calling.model.OnCreateChannel;
import com.hippo.eventbus.BusProvider;
import com.hippo.helper.BusEvents;
import com.hippo.helper.FayeMessage;
import com.hippo.model.FuguCreateConversationParams;
import com.hippo.model.FuguCreateConversationResponse;
import com.hippo.model.shareurl.ShareUrlModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import faye.ConnectionManager;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import retrofit2.Callback;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000b*\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010(\u001a\u00020 H\u0002J\b\u0010-\u001a\u00020\u0015H\u0016J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+H\u0007J\u0012\u0010/\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0014J\b\u00102\u001a\u00020\u0015H\u0014J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u000205H\u0007J\b\u00106\u001a\u00020\u0015H\u0014J\b\u00107\u001a\u00020\u0015H\u0014J\b\u00108\u001a\u00020\u0015H\u0014J\b\u00109\u001a\u00020\u0015H\u0002J\b\u0010:\u001a\u00020\u0015H\u0014J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\u0004H\u0002J\b\u0010=\u001a\u00020\u0015H\u0002J\b\u0010>\u001a\u00020\u0015H\u0002J\u0010\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u00020\u0004H\u0002J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000e0BH\u0002J\b\u0010C\u001a\u00020\u0015H\u0002J\b\u0010D\u001a\u00020\u0015H\u0002J\u0016\u0010E\u001a\u00020\u00152\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u001eJ\u0010\u0010I\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u000eH\u0002J\u0010\u0010J\u001a\u00020\u00152\u0006\u0010F\u001a\u00020\u000eH\u0002J\u0012\u0010K\u001a\u00020\u00152\b\u0010L\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010M\u001a\u00020\u0015H\u0002J\u0010\u0010N\u001a\u00020\u00152\u0006\u00104\u001a\u000205H\u0002J\b\u0010O\u001a\u00020\u0015H\u0002J\b\u0010P\u001a\u00020\u0015H\u0002J\b\u0010Q\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/hippo/calling/MainCallingActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "initOldCall", "", "isHungup", "isShareclick", "mLinkShare", "com/hippo/calling/MainCallingActivity$mLinkShare$1", "Lcom/hippo/calling/MainCallingActivity$mLinkShare$1;", "mVideoConferenceHungup", "com/hippo/calling/MainCallingActivity$mVideoConferenceHungup$1", "Lcom/hippo/calling/MainCallingActivity$mVideoConferenceHungup$1;", "meetingId", "", "micEnabled", "needToStartCall", "token", "videoCallModel", "Lcom/hippo/calling/VideoCallModel;", "answerConference", "", "answerGroupCall", "createConversation", "fuguCreateConversationParams", "Lcom/hippo/model/FuguCreateConversationParams;", "createUrl", "url", "getBaseUrl", "getDeviceDetails", "Lorg/json/JSONObject;", "getIndiaServerUrl", "Ljava/net/URL;", "getServerUrl", "link", "incomingBusOpration", "type", "", "incomingGroupBusOpration", "initCall", "serverURL", "jitsiActivityOperation", "data", "Lcom/hippo/calling/model/FragmentFlow;", "joinGroupCall", "onBackPressed", "onBusFragmentType", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onFayeMessageEvent", "event", "Lcom/hippo/helper/FayeMessage;", "onPause", "onResume", "onStart", "onStartCall", "onStop", "onVideoConfActivityCreate", "hasAnswer", "openIncommingCallFragment", "openIncommingGroupFragment", "openJitsiFragment", "isConnecting", "randomVideoConferenceLink", "Ljava/util/ArrayList;", "registerBroadcast", "rejectGroupCall", "sendMessage", "channelId", "", "jsonObject", "sendMessageOnUserChannel", "sendRejectOnUserChannel", "share", "meetUrl", "startMedia", "startOldCall", "startOngoingCallService", "stopForegroundService", "unregisterBroadcast", "hippo_release"})
public final class MainCallingActivity
extends AppCompatActivity {
    private boolean micEnabled = true;
    @Nullable
    private String meetingId = "";
    @Nullable
    private String token = "";
    @Nullable
    private VideoCallModel videoCallModel;
    private boolean needToStartCall;
    private boolean initOldCall;
    private boolean isHungup;
    private boolean isShareclick;
    @NotNull
    private final mLinkShare.1 mLinkShare;
    @NotNull
    private final mVideoConferenceHungup.1 mVideoConferenceHungup;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();

    public MainCallingActivity() {
        this.mLinkShare = new BroadcastReceiver(this){
            final /* synthetic */ MainCallingActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                block1: {
                    Intent intent2 = intent;
                    if (!StringsKt.equals((String)(intent2 != null ? intent2.getAction() : null), (String)"URL SHARED", (boolean)true) || MainCallingActivity.access$isShareclick$p(this.this$0)) break block1;
                    MainCallingActivity.access$setShareclick$p(this.this$0, true);
                    Object object = intent;
                    if (object != null && (object = object.getStringExtra("roomUrl")) != null) {
                        Object object2 = object;
                        MainCallingActivity mainCallingActivity = this.this$0;
                        Object it = object2;
                        boolean bl = false;
                        MainCallingActivity.access$createUrl(mainCallingActivity, (String)it);
                    }
                }
            }
        };
        this.mVideoConferenceHungup = new BroadcastReceiver(this){
            final /* synthetic */ MainCallingActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                HippoAudioManager.getInstance((Context)this.this$0).stop(false);
                this.this$0.finish();
            }
        };
    }

    private final void createUrl(String url) {
        if (com.hippo.database.CommonData.getUserDetails().getData().getIsCallInviteEnabled() == 1) {
            CommonParams params = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("en_creator_id", HippoConfig.getInstance().getUserData().getEnUserId()).add("en_user_id", HippoConfig.getInstance().getUserData().getEnUserId()).add("creator_id", HippoConfig.getInstance().getUserData().getUserId()).add("meet_url", url).build();
            RestClient.getApiInterface().createInviteLink((Map<String, Object>)params.getMap()).enqueue((Callback)new ResponseResolver<ShareUrlModel>(this){
                final /* synthetic */ MainCallingActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void success(@NotNull ShareUrlModel shareUrlModel) {
                    Intrinsics.checkNotNullParameter((Object)shareUrlModel, (String)"shareUrlModel");
                    MainCallingActivity.access$setShareclick$p(this.this$0, false);
                    MainCallingActivity.access$share(this.this$0, shareUrlModel.getData().getMeetUrl());
                }

                public void failure(@NotNull APIError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    MainCallingActivity.access$setShareclick$p(this.this$0, false);
                }
            });
        }
    }

    private final void share(String meetUrl) {
        Intent intent;
        Intent $this$share_u24lambda_u2d0 = intent = new Intent();
        boolean bl = false;
        $this$share_u24lambda_u2d0.setAction("android.intent.action.SEND");
        $this$share_u24lambda_u2d0.putExtra("android.intent.extra.TEXT", meetUrl);
        $this$share_u24lambda_u2d0.setType("text/plain");
        Intent sendIntent = intent;
        Intent shareIntent = Intent.createChooser((Intent)sendIntent, (CharSequence)"Share Call Link");
        this.startActivity(shareIntent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_maincalling);
        Window win = this.getWindow();
        win.addFlags(0x480000);
        win.addFlags(0x200000);
        if (this.getIntent().hasExtra("videoCallModel")) {
            Bundle bundle = this.getIntent().getExtras();
            VideoCallModel videoCallModel = bundle != null ? (VideoCallModel)bundle.getParcelable("videoCallModel") : null;
            Intrinsics.checkNotNull((Object)videoCallModel);
            this.videoCallModel = videoCallModel;
        }
        this.registerBroadcast();
        ConnectionManager.INSTANCE.initFayeConnection();
        if (this.getIntent().hasExtra("token")) {
            this.token = this.getIntent().getStringExtra("token");
        }
        if (this.getIntent().hasExtra("meetingId")) {
            this.meetingId = this.getIntent().getStringExtra("meetingId");
        }
        if (this.getIntent().hasExtra("peer_chat_params")) {
            FuguCreateConversationParams fuguCreateConversationParams;
            FuguCreateConversationParams fuguCreateConversationParams2 = fuguCreateConversationParams = (FuguCreateConversationParams)new Gson().fromJson(this.getIntent().getStringExtra("peer_chat_params"), FuguCreateConversationParams.class);
            Intrinsics.checkNotNullExpressionValue((Object)fuguCreateConversationParams2, (String)"fuguCreateConversationParams");
            this.createConversation(fuguCreateConversationParams2);
            this.openJitsiFragment(true);
            return;
        }
        if (this.videoCallModel != null) {
            VideoCallModel videoCallModel = this.videoCallModel;
            Boolean bl = videoCallModel != null ? videoCallModel.getHasGroupCall() : null;
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) {
                if (this.getIntent().hasExtra("answer_call")) {
                    this.answerGroupCall();
                    this.stopForegroundService();
                    HippoAudioManager.getInstance((Context)this).stop(false);
                    OngoingCallService.NotificationServiceState.INSTANCE.setConferenceConnected(true);
                    URL serverURL = this.getIndiaServerUrl();
                    this.joinGroupCall(serverURL);
                    this.startOngoingCallService();
                    this.finish();
                    return;
                } else {
                    this.openIncommingGroupFragment();
                    this.startMedia();
                }
                return;
            }
        }
        this.initOldCall = false;
        if (this.videoCallModel != null) {
            if (this.getIntent().hasExtra("answer_call")) {
                this.needToStartCall = false;
            } else if (this.getIntent().hasExtra("incomming_call")) {
                this.needToStartCall = false;
            } else {
                this.needToStartCall = true;
                ArrayList<String> linkArray = this.randomVideoConferenceLink();
                Object object = this.videoCallModel;
                Boolean bl = object != null && (object = ((VideoCallModel)object).getTransactionId()) != null ? Boolean.valueOf(((CharSequence)object).length() == 0) : null;
                Intrinsics.checkNotNull(bl);
                if (!bl.booleanValue()) {
                    ArrayList<Object> linkArray_ = new ArrayList<Object>();
                    linkArray_.add("https://conference.hippochat.io");
                    Object object2 = this.videoCallModel;
                    if (object2 != null && (object2 = ((VideoCallModel)object2).getTransactionId()) != null) {
                        Object it = object2;
                        boolean bl2 = false;
                        linkArray_.add(it);
                    }
                    VideoCallModel videoCallModel = this.videoCallModel;
                    if (videoCallModel != null) {
                        VideoCallModel videoCallModel2 = this.videoCallModel;
                        videoCallModel.setRoomName(videoCallModel2 != null ? videoCallModel2.getTransactionId() : null);
                    }
                    linkArray = linkArray_;
                }
                String jistsiLink = new CallConfig().getInstance().getJitsiURL() + '/' + linkArray.get(1);
                String inviteLink = linkArray.get(0) + '/' + linkArray.get(1);
                VideoCallModel videoCallModel = this.videoCallModel;
                String string2 = videoCallModel != null ? videoCallModel.getCallType() : null;
                Intrinsics.checkNotNull((Object)string2);
                if (Intrinsics.areEqual((Object)string2, (Object)"AUDIO")) {
                    jistsiLink = jistsiLink + "#config.startWithVideoMuted=true";
                }
                VideoCallModel videoCallModel3 = this.videoCallModel;
                String string3 = videoCallModel3 != null ? videoCallModel3.getCallType() : null;
                Intrinsics.checkNotNull((Object)string3);
                if (Intrinsics.areEqual((Object)string3, (Object)"AUDIO")) {
                    inviteLink = inviteLink + "#config.startWithVideoMuted=true";
                }
                if (com.hippo.database.CommonData.getUserDetails().getData().getCallingType() != 3) {
                    VideoCallModel videoCallModel4 = this.videoCallModel;
                    if (videoCallModel4 != null) {
                        videoCallModel4.setJitsiLink(jistsiLink);
                    }
                    VideoCallModel videoCallModel5 = this.videoCallModel;
                    if (videoCallModel5 != null) {
                        videoCallModel5.setInviteLink(inviteLink);
                    }
                } else {
                    VideoCallModel videoCallModel6 = this.videoCallModel;
                    if (videoCallModel6 != null) {
                        videoCallModel6.setJitsiLink(this.meetingId);
                    }
                    VideoCallModel videoCallModel7 = this.videoCallModel;
                    if (videoCallModel7 != null) {
                        videoCallModel7.setInviteLink(this.meetingId);
                    }
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append('/');
        VideoCallModel videoCallModel = this.videoCallModel;
        Long l = videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null;
        Intrinsics.checkNotNull((Object)l);
        ConnectionManager.INSTANCE.subScribeChannel(stringBuilder.append(l).toString());
        if (this.getIntent().hasExtra("incomming_call")) {
            this.openIncommingCallFragment();
            this.startMedia();
            return;
        } else if (this.getIntent().hasExtra("answer_call")) {
            this.onVideoConfActivityCreate(false);
            return;
        } else {
            this.openJitsiFragment(false);
            if (!ConnectionManager.INSTANCE.isConnected()) return;
            new Handler().postDelayed(() -> MainCallingActivity.onCreate$lambda-2(this), 200L);
        }
    }

    private final void registerBroadcast() {
        LocalBroadcastManager.getInstance((Context)((Context)this)).registerReceiver((BroadcastReceiver)this.mLinkShare, new IntentFilter("URL SHARED"));
    }

    private final void unregisterBroadcast() {
    }

    private final void onStartCall() {
        if (this.needToStartCall) {
            new Handler().postDelayed(() -> MainCallingActivity.onStartCall$lambda-3(this), 500L);
        }
    }

    protected void onResume() {
        super.onResume();
        this.registerBroadcast();
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onStart() {
        super.onStart();
        BusProvider.getInstance().register((Object)this);
    }

    protected void onStop() {
        super.onStop();
        BusProvider.getInstance().unregister((Object)this);
    }

    public void onBackPressed() {
    }

    protected void onDestroy() {
        super.onDestroy();
        HippoAudioManager.getInstance((Context)this).stop(false);
    }

    private final void openJitsiFragment(boolean isConnecting) {
        JitsiCallOutgoingActivity fragment = new JitsiCallOutgoingActivity();
        Bundle bundle = new Bundle();
        bundle.putBoolean("connecting", isConnecting);
        bundle.putParcelable("videoCallModel", (Parcelable)this.videoCallModel);
        bundle.putString("token", this.token);
        bundle.putString("meetingId", this.meetingId);
        fragment.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)fragment, JitsiCallOutgoingActivity.class.getSimpleName()).addToBackStack(JitsiCallOutgoingActivity.class.getSimpleName()).commitAllowingStateLoss();
    }

    private final void openIncommingCallFragment() {
        IncomingJitsiCallActivity fragment = new IncomingJitsiCallActivity();
        Bundle bundle = new Bundle();
        bundle.putParcelable("videoCallModel", (Parcelable)this.videoCallModel);
        fragment.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)fragment, IncomingJitsiCallActivity.class.getSimpleName()).addToBackStack(IncomingJitsiCallActivity.class.getSimpleName()).commitAllowingStateLoss();
    }

    private final void openIncommingGroupFragment() {
        IncomingGroupCall fragment = new IncomingGroupCall();
        Bundle bundle = new Bundle();
        bundle.putParcelable("videoCallModel", (Parcelable)this.videoCallModel);
        fragment.setArguments(bundle);
        this.getSupportFragmentManager().beginTransaction().add(R.id.main_layout, (Fragment)fragment, IncomingGroupCall.class.getSimpleName()).addToBackStack(IncomingGroupCall.class.getSimpleName()).commitAllowingStateLoss();
    }

    public final void sendMessage(long channelId, @NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        ConnectionManager.INSTANCE.publish("" + '/' + channelId, jsonObject, false);
    }

    @Subscribe
    public final void onBusFragmentType(@NotNull FragmentFlow data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string2 = data.getFragmentType();
        if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.BusFragmentType.INCOMMING_JITSI_CALL.toString())) {
            this.incomingBusOpration(data.getType());
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.BusFragmentType.JITSI_CALL.toString())) {
            this.jitsiActivityOperation(data);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.BusFragmentType.INCOMMING_GROUP_CALL.toString())) {
            this.incomingGroupBusOpration(data.getType());
        }
    }

    @Subscribe
    public final void onFayeMessageEvent(@NotNull FayeMessage event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HippoLog.d("onFayeMessageEvent", "onFayeMessageEvent -> " + event.type);
        String string2 = event.type;
        if (Intrinsics.areEqual((Object)string2, (Object)BusEvents.ERROR_RECEIVED.toString())) {
            this.startOldCall(event);
        } else if (Intrinsics.areEqual((Object)string2, (Object)WebRTCCallConstants.BusFragmentType.CALL_HUNGUP.toString())) {
            HippoAudioManager.getInstance((Context)this).stop(false);
            this.finish();
        }
    }

    private final synchronized void startOldCall(FayeMessage event) {
        try {
            if (!this.initOldCall) {
                this.initOldCall = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final ArrayList<String> randomVideoConferenceLink() {
        ArrayList<String> linkArray = new ArrayList<String>();
        String ALLOWED_CHARACTERS = "qwertyuiopasdfghjklzxcvbnm";
        Random random = new Random();
        StringBuilder sb = new StringBuilder(10);
        for (int i = 0; i < 10; ++i) {
            sb.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
        }
        linkArray.add("https://conference.hippochat.io");
        linkArray.add(sb.toString());
        VideoCallModel videoCallModel = this.videoCallModel;
        if (videoCallModel != null) {
            videoCallModel.setRoomName(sb.toString());
        }
        return linkArray;
    }

    private final void incomingGroupBusOpration(int type) {
        int n = type;
        if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getANSWERCALL()) {
            this.answerGroupCall();
            this.stopForegroundService();
            HippoAudioManager.getInstance((Context)this).stop(false);
            OngoingCallService.NotificationServiceState.INSTANCE.setConferenceConnected(true);
            OngoingCallService.NotificationServiceState.INSTANCE.setHasGroupCall(true);
            URL serverURL = this.getIndiaServerUrl();
            this.joinGroupCall(serverURL);
            this.startOngoingCallService();
            this.finish();
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getREJECTCALL()) {
            HippoAudioManager.getInstance((Context)this).stop(false);
            this.rejectGroupCall();
            Intent hungupIntent = new Intent((Context)this, HungUpBroadcast.class);
            hungupIntent.putExtra("action", "rejectCall");
            hungupIntent.putExtra(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), this.getDeviceDetails().toString());
            VideoCallModel videoCallModel = this.videoCallModel;
            hungupIntent.putExtra("invite_link", videoCallModel != null ? videoCallModel.getInviteLink() : null);
            VideoCallModel videoCallModel2 = this.videoCallModel;
            hungupIntent.putExtra("jitsi_url", videoCallModel2 != null ? videoCallModel2.getJitsiLink() : null);
            VideoCallModel videoCallModel3 = this.videoCallModel;
            hungupIntent.putExtra("channel_id", (Serializable)(videoCallModel3 != null ? Long.valueOf(videoCallModel3.getChannelId()) : null));
            VideoCallModel videoCallModel4 = this.videoCallModel;
            Boolean bl = videoCallModel4 != null ? videoCallModel4.getHasGroupCall() : null;
            Intrinsics.checkNotNull((Object)bl);
            if (bl.booleanValue()) {
                hungupIntent.putExtra("has_group_call", true);
            }
            hungupIntent.putExtra("auth0", OngoingCallService.NotificationServiceState.INSTANCE.getAuthObj());
            this.sendBroadcast(hungupIntent);
            this.finish();
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getUNREGISTER_BROADCAST()) {
            HippoAudioManager.getInstance((Context)this).stop(false);
            try {
                LocalBroadcastManager.getInstance((Context)((Context)this)).unregisterReceiver((BroadcastReceiver)this.mVideoConferenceHungup);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getREGISTER_BROADCAST()) {
            try {
                LocalBroadcastManager.getInstance((Context)((Context)this)).unregisterReceiver((BroadcastReceiver)this.mVideoConferenceHungup);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LocalBroadcastManager.getInstance((Context)((Context)this)).registerReceiver((BroadcastReceiver)this.mVideoConferenceHungup, new IntentFilter("video_conference_hungup_intent"));
        }
    }

    private final void incomingBusOpration(int type) {
        int n = type;
        if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getSTART_MEDIA()) {
            this.startMedia();
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getUNREGISTER_BROADCAST()) {
            HippoAudioManager.getInstance((Context)this).stop(false);
            try {
                LocalBroadcastManager.getInstance((Context)((Context)this)).unregisterReceiver((BroadcastReceiver)this.mVideoConferenceHungup);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getREGISTER_BROADCAST()) {
            try {
                LocalBroadcastManager.getInstance((Context)((Context)this)).unregisterReceiver((BroadcastReceiver)this.mVideoConferenceHungup);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LocalBroadcastManager.getInstance((Context)((Context)this)).registerReceiver((BroadcastReceiver)this.mVideoConferenceHungup, new IntentFilter("video_conference_hungup_intent"));
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getSTOP()) {
            try {
                LocalBroadcastManager.getInstance((Context)((Context)this)).unregisterReceiver((BroadcastReceiver)this.mVideoConferenceHungup);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getANSWERCALL()) {
            this.onVideoConfActivityCreate(false);
        } else if (n == WebRTCCallConstants.IncommintJitsiCall.Companion.getREJECTCALL()) {
            HippoAudioManager.getInstance((Context)this).stop(false);
            Intent hungupIntent = new Intent((Context)this, HungUpBroadcast.class);
            hungupIntent.putExtra("action", "rejectCall");
            hungupIntent.putExtra(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), this.getDeviceDetails().toString());
            VideoCallModel videoCallModel = this.videoCallModel;
            hungupIntent.putExtra("invite_link", videoCallModel != null ? videoCallModel.getInviteLink() : null);
            VideoCallModel videoCallModel2 = this.videoCallModel;
            hungupIntent.putExtra("jitsi_url", videoCallModel2 != null ? videoCallModel2.getJitsiLink() : null);
            VideoCallModel videoCallModel3 = this.videoCallModel;
            hungupIntent.putExtra("channel_id", (Serializable)(videoCallModel3 != null ? Long.valueOf(videoCallModel3.getChannelId()) : null));
            hungupIntent.putExtra("muid", OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
            hungupIntent.putExtra("auth0", OngoingCallService.NotificationServiceState.INSTANCE.getAuthObj());
            this.sendBroadcast(hungupIntent);
            this.finish();
        }
    }

    private final void startMedia() {
        HippoAudioManager.getInstance((Context)this).startIncomingRinger();
    }

    private final JSONObject getDeviceDetails() {
        JSONObject devicePayload = new JSONObject();
        devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)this));
        devicePayload.put("device_type", 1);
        devicePayload.put("app_version", (Object)HippoConfig.getInstance().getVersionName());
        devicePayload.put("device_details", (Object)CommonData.deviceDetails((Context)this));
        return devicePayload;
    }

    private final void jitsiActivityOperation(FragmentFlow data) {
        int n = data.getType();
        if (n == WebRTCCallConstants.JitsiCallActivity.Companion.getPOST_DATA()) {
            VideoCallModel videoCallModel = this.videoCallModel;
            Long l = videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null;
            Intrinsics.checkNotNull((Object)l);
            long l2 = l;
            JSONObject jSONObject = data.getJson();
            Intrinsics.checkNotNull((Object)jSONObject);
            this.sendMessage(l2, jSONObject);
        } else if (n == WebRTCCallConstants.JitsiCallActivity.Companion.getOPEN_VIDEO_CONF()) {
            this.onVideoConfActivityCreate(true);
        } else if (n != WebRTCCallConstants.JitsiCallActivity.Companion.getPRE_LOAD_DATA() && n == WebRTCCallConstants.JitsiCallActivity.Companion.getOPEN_OLD_CALL()) {
            this.finish();
        }
    }

    private final void onVideoConfActivityCreate(boolean hasAnswer) {
        this.stopForegroundService();
        HippoAudioManager.getInstance((Context)this).stop(false);
        OngoingCallService.NotificationServiceState.INSTANCE.setConferenceConnected(true);
        if (!hasAnswer) {
            this.answerConference();
        }
        VideoCallModel videoCallModel = this.videoCallModel;
        URL serverURL = this.getServerUrl(videoCallModel != null ? videoCallModel.getJitsiLink() : null);
        VideoCallModel videoCallModel2 = this.videoCallModel;
        if (!TextUtils.isEmpty((CharSequence)(videoCallModel2 != null ? videoCallModel2.getJitsiLink() : null))) {
            // empty if block
        }
        this.initCall(serverURL);
        this.startOngoingCallService();
        this.finish();
    }

    private final void stopForegroundService() {
        try {
            Intent startIntent = new Intent((Context)this, VideoCallService.class);
            startIntent.setAction("com.hippochat.start");
            startIntent.putExtra("isHungUpToBeSent", false);
            this.stopService(startIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void startOngoingCallService() {
        Intent startIntent = new Intent((Context)this, OngoingCallService.class);
        startIntent.setAction("com.hippochat.notification.start");
        VideoCallModel videoCallModel = this.videoCallModel;
        startIntent.putExtra("muid", videoCallModel != null ? videoCallModel.getSignalUniqueId() : null);
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startIntent.putExtra("invite_link", videoCallModel2 != null ? videoCallModel2.getInviteLink() : null);
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startIntent.putExtra("jitsi_url", videoCallModel3 != null ? videoCallModel3.getJitsiLink() : null);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startIntent.putExtra("channel_id", (Serializable)(videoCallModel4 != null ? Long.valueOf(videoCallModel4.getChannelId()) : null));
        ContextCompat.startForegroundService((Context)((Context)this), (Intent)startIntent);
    }

    private final void answerConference() {
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        String fullName = com.hippo.database.CommonData.getUserDetails().getData().getFullName();
        JSONObject startCallJson = new JSONObject();
        startCallJson.put("is_silent", true);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.JitsiCallType.ANSWER_CONFERENCE.toString());
        Intrinsics.checkNotNullExpressionValue((Object)userId, (String)"userId");
        startCallJson.put("user_id", userId.longValue());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getVIDEO_CALL());
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
        startCallJson.put("muid", (Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel2 != null ? videoCallModel2.getInviteLink() : null));
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put("jitsi_url", (Object)(videoCallModel3 != null ? videoCallModel3.getJitsiLink() : null));
        startCallJson.put("message", (Object)"");
        startCallJson.put("is_typing", 0);
        startCallJson.put("user_type", 1);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startCallJson.put("full_name", (Object)(videoCallModel4 != null ? videoCallModel4.getFullName() : null));
        String authObj = new CallConfig().getInstance().getAuthObj(OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        if (!TextUtils.isEmpty((CharSequence)authObj)) {
            startCallJson.put("auth0", (Object)authObj);
        }
        HippoCallingFlow.INSTANCE.setAnswerFor(OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        VideoCallModel videoCallModel5 = this.videoCallModel;
        Long l = videoCallModel5 != null ? Long.valueOf(videoCallModel5.getChannelId()) : null;
        Intrinsics.checkNotNull((Object)l);
        this.sendMessage(l, startCallJson);
    }

    private final URL getIndiaServerUrl() {
        URL serverURL = null;
        if (!TextUtils.isEmpty((CharSequence)new CallConfig().getInstance().getJitsiURL())) {
            try {
                serverURL = new URL(new CallConfig().getInstance().getJitsiURL());
                return serverURL;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            serverURL = new URL("https://conference.hippochat.io");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid server URL!");
        }
        return serverURL;
    }

    private final URL getServerUrl(String link) {
        URL serverURL = null;
        if (!TextUtils.isEmpty((CharSequence)link) && !TextUtils.isEmpty((CharSequence)new CallConfig().getInstance().getJitsiURL())) {
            try {
                serverURL = new URL(new CallConfig().getInstance().getJitsiURL());
                return serverURL;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            serverURL = new URL("https://conference.hippochat.io");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Invalid server URL!");
        }
        return serverURL;
    }

    /*
     * Unable to fully structure code
     */
    private final void initCall(URL serverURL) {
        block3: {
            block2: {
                if (com.hippo.database.CommonData.getUserDetails().getData().getCallingType() != 3) break block2;
                videoIntent = new Intent((Context)this, VideoSdkMeetingActivity.class);
                videoIntent.addFlags(0x10000000);
                videoIntent.addFlags(0x800000);
                videoIntent.putExtra("videoCallModel", (Parcelable)this.videoCallModel);
                videoIntent.putExtra("token", this.token);
                v0 = this.videoCallModel;
                videoIntent.putExtra("meetingId", v0 != null ? v0.getJitsiLink() : null);
                this.startActivity(videoIntent);
                break block3;
            }
            v1 = this.videoCallModel;
            v2 = roomName = v1 != null ? v1.getRoomName() : null;
            v3 = roomName = v2 != null ? StringsKt.replace$default((String)v2, (String)"#config.startWithVideoMuted=true", (String)"", (boolean)false, (int)4, null) : null;
            if (HippoConfig.getInstance().getCallData() == null) break block3;
            v4 = this.videoCallModel;
            if (Intrinsics.areEqual((Object)(v4 != null ? v4.getCallType() : null), (Object)"AUDIO")) ** GOTO lbl-1000
            v5 = this.videoCallModel;
            v6 = v5 != null ? v5.getInviteLink() : null;
            Intrinsics.checkNotNull((Object)v6);
            if (StringsKt.contains$default((CharSequence)v6, (CharSequence)"#config.startWithVideoMuted=true", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v7 = roomName;
            v8 = v7 != null ? Boolean.valueOf(StringsKt.contains$default((CharSequence)v7, (CharSequence)"#config.startWithVideoMuted=true", (boolean)false, (int)2, null)) : null;
            Intrinsics.checkNotNull(v8);
            if (v8.booleanValue()) lbl-1000:
            // 3 sources

            {
                v9 = true;
            } else {
                v9 = false;
            }
            isAudioOnly = v9;
            v10 = this.videoCallModel;
            v11 = this.videoCallModel;
            HippoConfig.getInstance().getCallData().launchJitsi(HippoConfig.getInstance().getContext(), serverURL, v10 != null ? v10.getMyname() : null, roomName, v11 != null ? v11.getMyImagePath() : null, isAudioOnly);
        }
    }

    private final void joinGroupCall(URL serverURL) {
        if (com.hippo.database.CommonData.getUserDetails().getData().getCallingType() == 3) {
            Intent videoIntent = new Intent((Context)this, VideoSdkMeetingActivity.class);
            videoIntent.addFlags(0x10000000);
            videoIntent.addFlags(0x800000);
            videoIntent.putExtra("videoCallModel", (Parcelable)this.videoCallModel);
            videoIntent.putExtra("token", this.token);
            VideoCallModel videoCallModel = this.videoCallModel;
            videoIntent.putExtra("meetingId", videoCallModel != null ? videoCallModel.getJitsiLink() : null);
            this.startActivity(videoIntent);
        } else if (HippoConfig.getInstance().getCallData() != null) {
            String roomName;
            VideoCallModel videoCallModel = this.videoCallModel;
            String string2 = roomName = videoCallModel != null ? videoCallModel.getRoomName() : null;
            String string3 = roomName = string2 != null ? StringsKt.replace$default((String)string2, (String)"config.startWithVideoMuted=true", (String)"", (boolean)false, (int)4, null) : null;
            String string4 = roomName = string3 != null ? StringsKt.replace$default((String)string3, (String)"config.startWithAudioMuted=true", (String)"", (boolean)false, (int)4, null) : null;
            roomName = string4 != null ? StringsKt.replace$default((String)string4, (String)"#", (String)"", (boolean)false, (int)4, null) : null;
            VideoCallModel videoCallModel2 = this.videoCallModel;
            Boolean bl = videoCallModel2 != null ? Boolean.valueOf(videoCallModel2.isVideoCall()) : null;
            Intrinsics.checkNotNull((Object)bl);
            boolean isAudioOnly = bl == false;
            VideoCallModel videoCallModel3 = this.videoCallModel;
            VideoCallModel videoCallModel4 = this.videoCallModel;
            HippoConfig.getInstance().getCallData().launchJitsi(HippoConfig.getInstance().getContext(), serverURL, videoCallModel3 != null ? videoCallModel3.getMyname() : null, roomName, videoCallModel4 != null ? videoCallModel4.getMyImagePath() : null, isAudioOnly);
        }
    }

    private final void answerGroupCall() {
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        JSONObject startCallJson = new JSONObject();
        startCallJson.put("is_silent", true);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.VideoCallType.JOIN_GROUP_CALL.toString());
        Intrinsics.checkNotNullExpressionValue((Object)userId, (String)"userId");
        startCallJson.put("user_id", userId.longValue());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getGROUP_CALL());
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
        startCallJson.put("muid", (Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel2 != null ? videoCallModel2.getInviteLink() : null));
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put("jitsi_url", (Object)(videoCallModel3 != null ? videoCallModel3.getJitsiLink() : null));
        startCallJson.put("message", (Object)"");
        startCallJson.put("is_typing", 0);
        startCallJson.put("user_type", 1);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startCallJson.put("full_name", (Object)(videoCallModel4 != null ? videoCallModel4.getFullName() : null));
        String authObj = new CallConfig().getInstance().getAuthObj(OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        if (!TextUtils.isEmpty((CharSequence)authObj)) {
            startCallJson.put("auth0", (Object)authObj);
        }
        VideoCallModel videoCallModel5 = this.videoCallModel;
        Long l = videoCallModel5 != null ? Long.valueOf(videoCallModel5.getChannelId()) : null;
        Intrinsics.checkNotNull((Object)l);
        this.sendMessage(l, startCallJson);
        this.sendMessageOnUserChannel('/' + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
    }

    private final void sendMessageOnUserChannel(String channelId) {
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        JSONObject startCallJson = new JSONObject();
        startCallJson.put("is_silent", true);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.VideoCallType.JOIN_GROUP_CALL.toString());
        Intrinsics.checkNotNullExpressionValue((Object)userId, (String)"userId");
        startCallJson.put("user_id", userId.longValue());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getGROUP_CALL());
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
        startCallJson.put("muid", (Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel2 != null ? videoCallModel2.getInviteLink() : null));
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put("jitsi_url", (Object)(videoCallModel3 != null ? videoCallModel3.getJitsiLink() : null));
        startCallJson.put("message", (Object)"");
        startCallJson.put("is_typing", 0);
        startCallJson.put("user_type", 1);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startCallJson.put("full_name", (Object)(videoCallModel4 != null ? videoCallModel4.getFullName() : null));
        startCallJson.put("server_push", true);
        String authObj = new CallConfig().getInstance().getAuthObj(OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        if (!TextUtils.isEmpty((CharSequence)authObj)) {
            startCallJson.put("auth0", (Object)authObj);
        }
        ConnectionManager.INSTANCE.publish(channelId, startCallJson, false);
    }

    private final void rejectGroupCall() {
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        String fullName = com.hippo.database.CommonData.getUserDetails().getData().getFullName();
        JSONObject startCallJson = new JSONObject();
        startCallJson.put("is_silent", true);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.VideoCallType.REJECT_GROUP_CALL.toString());
        Intrinsics.checkNotNullExpressionValue((Object)userId, (String)"userId");
        startCallJson.put("user_id", userId.longValue());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getGROUP_CALL());
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
        startCallJson.put("muid", (Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel2 != null ? videoCallModel2.getInviteLink() : null));
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put("jitsi_url", (Object)(videoCallModel3 != null ? videoCallModel3.getJitsiLink() : null));
        startCallJson.put("message", (Object)"");
        startCallJson.put("is_typing", 0);
        startCallJson.put("user_type", 1);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startCallJson.put("full_name", (Object)(videoCallModel4 != null ? videoCallModel4.getFullName() : null));
        String authObj = new CallConfig().getInstance().getAuthObj(OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        if (!TextUtils.isEmpty((CharSequence)authObj)) {
            startCallJson.put("auth0", (Object)authObj);
        }
        VideoCallModel videoCallModel5 = this.videoCallModel;
        Long l = videoCallModel5 != null ? Long.valueOf(videoCallModel5.getChannelId()) : null;
        Intrinsics.checkNotNull((Object)l);
        this.sendMessage(l, startCallJson);
        this.sendRejectOnUserChannel('/' + com.hippo.database.CommonData.getUserDetails().getData().getUserChannel());
    }

    private final void sendRejectOnUserChannel(String channelId) {
        Long userId = com.hippo.database.CommonData.getUserDetails().getData().getUserId();
        JSONObject startCallJson = new JSONObject();
        startCallJson.put("is_silent", true);
        startCallJson.put(WebRTCCallConstants.Companion.getVIDEO_CALL_TYPE(), (Object)WebRTCCallConstants.VideoCallType.REJECT_GROUP_CALL.toString());
        Intrinsics.checkNotNullExpressionValue((Object)userId, (String)"userId");
        startCallJson.put("user_id", userId.longValue());
        VideoCallModel videoCallModel = this.videoCallModel;
        startCallJson.put("channel_id", (Object)(videoCallModel != null ? Long.valueOf(videoCallModel.getChannelId()) : null));
        startCallJson.put("message_type", WebRTCCallConstants.Companion.getGROUP_CALL());
        startCallJson.put(WebRTCCallConstants.Companion.getCALL_TYPE(), (Object)"VIDEO");
        startCallJson.put("muid", (Object)OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        startCallJson.put(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), (Object)this.getDeviceDetails());
        VideoCallModel videoCallModel2 = this.videoCallModel;
        startCallJson.put("invite_link", (Object)(videoCallModel2 != null ? videoCallModel2.getInviteLink() : null));
        VideoCallModel videoCallModel3 = this.videoCallModel;
        startCallJson.put("jitsi_url", (Object)(videoCallModel3 != null ? videoCallModel3.getJitsiLink() : null));
        startCallJson.put("message", (Object)"");
        startCallJson.put("is_typing", 0);
        startCallJson.put("user_type", 1);
        VideoCallModel videoCallModel4 = this.videoCallModel;
        startCallJson.put("full_name", (Object)(videoCallModel4 != null ? videoCallModel4.getFullName() : null));
        startCallJson.put("server_push", true);
        String authObj = new CallConfig().getInstance().getAuthObj(OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
        if (!TextUtils.isEmpty((CharSequence)authObj)) {
            startCallJson.put("auth0", (Object)authObj);
        }
        ConnectionManager.INSTANCE.publish(channelId, startCallJson, false);
    }

    private final void getBaseUrl(String url) {
        try {
            URL url2 = new URL(url);
            String string2 = url2.getProtocol() + "://" + url2.getHost();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private final void createConversation(FuguCreateConversationParams fuguCreateConversationParams) {
        try {
            if (com.hippo.database.CommonData.getAttributes() != null && !TextUtils.isEmpty((CharSequence)com.hippo.database.CommonData.getAttributes().getUserIdentificationSecret())) {
                fuguCreateConversationParams.setUserIdentificationSecret(com.hippo.database.CommonData.getAttributes().getUserIdentificationSecret());
            }
            RestClient.getApiInterface().createConversation(fuguCreateConversationParams).enqueue((Callback)new ResponseResolver<FuguCreateConversationResponse>(this, fuguCreateConversationParams){
                final /* synthetic */ MainCallingActivity this$0;
                final /* synthetic */ FuguCreateConversationParams $fuguCreateConversationParams;
                {
                    this.this$0 = $receiver;
                    this.$fuguCreateConversationParams = $fuguCreateConversationParams;
                    super((Activity)$receiver, false, false);
                }

                public void success(@Nullable FuguCreateConversationResponse t) {
                    try {
                        if (!this.this$0.isFinishing()) {
                            Object object = t;
                            Long l = object != null && (object = ((FuguCreateConversationResponse)object).getData()) != null ? ((FuguCreateConversationResponse.Data)object).getChannelId() : null;
                            Intrinsics.checkNotNull((Object)l);
                            long channelId = l;
                            VideoCallModel videoCallModel = MainCallingActivity.access$getVideoCallModel$p(this.this$0);
                            if (videoCallModel != null) {
                                videoCallModel.setChannelId(channelId);
                            }
                            StringBuilder stringBuilder = new StringBuilder().append('/');
                            VideoCallModel videoCallModel2 = MainCallingActivity.access$getVideoCallModel$p(this.this$0);
                            Long l2 = videoCallModel2 != null ? Long.valueOf(videoCallModel2.getChannelId()) : null;
                            Intrinsics.checkNotNull((Object)l2);
                            ConnectionManager.INSTANCE.subScribeChannel(stringBuilder.append(l2).toString());
                            CommonData.setChannelIds(this.$fuguCreateConversationParams.getTransactionId(), channelId);
                            Bus bus = BusProvider.getInstance();
                            VideoCallModel videoCallModel3 = MainCallingActivity.access$getVideoCallModel$p(this.this$0);
                            Intrinsics.checkNotNull((Object)videoCallModel3);
                            bus.post((Object)new OnCreateChannel(true, channelId, videoCallModel3));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                public void failure(@Nullable APIError error) {
                    APIError aPIError = error;
                    Toast.makeText((Context)((Context)this.this$0), (CharSequence)("" + (aPIError != null ? aPIError.getMessage() : null)), (int)0).show();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final void onCreate$lambda-2(MainCallingActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onStartCall();
    }

    private static final void onStartCall$lambda-3(MainCallingActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        BusProvider.getInstance().post((Object)new FragmentFlow(WebRTCCallConstants.BusFragmentType.MAIN_CALL.toString(), 1, new JSONObject(), ""));
        this$0.needToStartCall = false;
    }

    public static final /* synthetic */ void access$setShareclick$p(MainCallingActivity $this, boolean bl) {
        $this.isShareclick = bl;
    }

    public static final /* synthetic */ void access$share(MainCallingActivity $this, String meetUrl) {
        $this.share(meetUrl);
    }

    public static final /* synthetic */ VideoCallModel access$getVideoCallModel$p(MainCallingActivity $this) {
        return $this.videoCallModel;
    }

    public static final /* synthetic */ boolean access$isShareclick$p(MainCallingActivity $this) {
        return $this.isShareclick;
    }

    public static final /* synthetic */ void access$createUrl(MainCallingActivity $this, String url) {
        $this.createUrl(url);
    }
}

