/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.calling;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.PictureInPictureParams;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.UrlQuerySanitizer;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.util.Rational;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.calling.CommonData;
import com.hippo.calling.VideoCallModel;
import com.hippo.calling.WebRTCCallConstants;
import com.hippo.calling.confcall.HippoAudioManager;
import com.hippo.calling.confcall.HungUpBroadcast;
import com.hippo.calling.confcall.OngoingCallService;
import com.hippo.model.videoSdk.VideoSkdData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.nabinbhandari.android.permissions.PermissionHandler;
import com.nabinbhandari.android.permissions.Permissions;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class VideoSdkMeetingActivity
extends AppCompatActivity {
    private VideoCallModel videoCallModel;
    private String token = "";
    private String meetingId;
    private String participantName;
    private boolean webcamEnabled = true;
    private WebView myWebView;
    private TextView connectingTV;
    private final PermissionHandler permissionHandler = new PermissionHandler(){

        public void onGranted() {
            if (!VideoSdkMeetingActivity.this.token.isEmpty()) {
                VideoSdkMeetingActivity.this.setWebView();
            } else {
                VideoSdkMeetingActivity.this.getToken();
            }
        }
    };
    private BroadcastReceiver mVideoConferenceHungup = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            VideoSdkMeetingActivity.this.finish();
        }
    };
    private BroadcastReceiver mHungUpBroadCAst = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            LocalBroadcastManager.getInstance((Context)VideoSdkMeetingActivity.this).unregisterReceiver(VideoSdkMeetingActivity.this.mHungUpBroadCAst);
            VideoSdkMeetingActivity.this.finish();
        }
    };

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(2622464, 2622464);
        this.setContentView(R.layout.activity_video_sdk_meeting);
        this.connectingTV = (TextView)this.findViewById(R.id.connectingTV);
        this.myWebView = (WebView)this.findViewById(R.id.wvWebsite);
        if (!this.getIntent().getExtras().containsKey("from_calling_push")) {
            if (this.getIntent().hasExtra("videoCallModel")) {
                this.videoCallModel = (VideoCallModel)this.getIntent().getExtras().getParcelable("videoCallModel");
            }
            this.token = this.getIntent().getStringExtra("token");
            this.meetingId = this.getIntent().getStringExtra("meetingId");
            this.participantName = this.videoCallModel.getFullName();
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mVideoConferenceHungup, new IntentFilter("video_conference_hungup_intent"));
            LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mHungUpBroadCAst, new IntentFilter("CALL_HANGUP"));
            this.checkPermissions();
        }
    }

    private void setWebView() {
        WebSettings webSettings = this.myWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        this.myWebView.setWebViewClient((WebViewClient)new MyWebViewClient());
        this.myWebView.setWebChromeClient(new WebChromeClient(){

            public void onPermissionRequest(final PermissionRequest request) {
                VideoSdkMeetingActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    @TargetApi(value=21)
                    public void run() {
                        request.grant(request.getResources());
                    }
                });
            }
        });
        this.myWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);
        String isVideo = "false";
        String switchWebCam = "false";
        String userName = "Visitor";
        if (this.videoCallModel.getCallType().equalsIgnoreCase("AUDIO")) {
            isVideo = "false";
            switchWebCam = "false";
        } else {
            isVideo = "true";
            switchWebCam = "true";
        }
        if (this.videoCallModel.getMyname() != null && !this.videoCallModel.getMyname().isEmpty()) {
            userName = this.videoCallModel.getMyname();
        }
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https").authority("embed.videosdk.live").appendPath("rtc-js-prebuilt/0.3.13").appendQueryParameter("name", userName).appendQueryParameter("micEnabled", "true").appendQueryParameter("participantCanToggleOtherMic", "true").appendQueryParameter("webcamEnabled", isVideo).appendQueryParameter("chatEnabled", "false").appendQueryParameter("screenShareEnabled", "false").appendQueryParameter("meetingId", this.meetingId).appendQueryParameter("pollEnabled", "false").appendQueryParameter("whiteboardEnabled", "false").appendQueryParameter("redirectOnLeave", "https://hippochat.io").appendQueryParameter("participantCanToggleSelfWebcam", switchWebCam).appendQueryParameter("participantCanToggleSelfMic", "true").appendQueryParameter("raiseHandEnabled", "true").appendQueryParameter("token", this.token).appendQueryParameter("brandingEnabled", "false").appendQueryParameter("recordingEnabled", "false").appendQueryParameter("joinScreenEnabled", "false").appendQueryParameter("recordingWebhookUrl", "");
        String url = builder.build().toString();
        HippoLog.e("callurl>>>", url);
        this.myWebView.loadUrl(url);
    }

    public void onUserLeaveHint() {
        if (this.supportsPiPMode()) {
            this.setToPip();
        }
    }

    public boolean supportsPiPMode() {
        return Build.VERSION.SDK_INT >= 26;
    }

    private void setToPip() {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                Rational rational = new Rational(300, 500);
                PictureInPictureParams mParams = new PictureInPictureParams.Builder().setAspectRatio(rational).build();
                this.enterPictureInPictureMode(mParams);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }
    }

    private void getToken() {
        CommonParams params = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("request_token", 1).build();
        RestClient.getApiInterface().getVideoSdkToken(params.getMap()).enqueue((Callback)new ResponseResolver<VideoSkdData>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(VideoSkdData jsonObject) {
                Log.e((String)"getVideoSdkToken", (String)jsonObject.getData().getToken());
                VideoSdkMeetingActivity.this.token = jsonObject.getData().getToken();
                VideoSdkMeetingActivity.this.setWebView();
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    private void getMeetId() {
        CommonParams params = new CommonParams.Builder().add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("meet_url", this.meetingId).add("validate_meet", 1).add("meet_token", this.token).build();
        RestClient.getApiInterface().getVideoSdkToken(params.getMap()).enqueue((Callback)new ResponseResolver<VideoSkdData>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(VideoSkdData jsonObject) {
                Log.e((String)"getVideoSdkToken", (String)jsonObject.getData().toString());
                VideoSdkMeetingActivity.this.meetingId = jsonObject.getData().getMeetingId();
                VideoSdkMeetingActivity.this.setWebView();
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    private void checkPermissions() {
        String[] permissions = new String[]{"android.permission.INTERNET", "android.permission.RECORD_AUDIO", "android.permission.CAMERA", "android.permission.MODIFY_AUDIO_SETTINGS"};
        String rationale = "Please provide permissions`";
        Permissions.Options options = new Permissions.Options().setRationaleDialogTitle("Info").setSettingsDialogTitle("Warning");
        Permissions.check((Context)this, (String[])permissions, (String)rationale, (Permissions.Options)options, (PermissionHandler)this.permissionHandler);
    }

    public void onBackPressed() {
        this.showAlertDialog();
    }

    private void showAlertDialog() {
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Alert").setMessage((CharSequence)"Are you sure you want to end this call").setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                VideoSdkMeetingActivity.this.finishAct();
            }
        }).setNegativeButton(17039369, null).show();
    }

    private void finishAct() {
        this.endcall();
        this.finish();
        super.onBackPressed();
    }

    protected void onDestroy() {
        this.endcall();
        super.onDestroy();
    }

    private void endcall() {
        if (this.videoCallModel != null) {
            HippoAudioManager.getInstance((Context)this).stop(false);
            Intent hungupIntent = new Intent((Context)this, HungUpBroadcast.class);
            hungupIntent.putExtra("action", "hungupCall");
            hungupIntent.putExtra(WebRTCCallConstants.Companion.getDEVICE_PAYLOAD(), this.getDeviceDetails().toString());
            hungupIntent.putExtra("invite_link", this.videoCallModel.getInviteLink());
            hungupIntent.putExtra("jitsi_url", this.videoCallModel.getJitsiLink());
            hungupIntent.putExtra("channel_id", this.videoCallModel.getChannelId());
            hungupIntent.putExtra("muid", OngoingCallService.NotificationServiceState.INSTANCE.getMuid());
            hungupIntent.putExtra("auth0", OngoingCallService.NotificationServiceState.INSTANCE.getAuthObj());
            this.sendBroadcast(hungupIntent);
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mVideoConferenceHungup);
        }
    }

    private boolean onOverrideUrlLoading(WebView view, String url) {
        Log.e((String)"URL", (String)(url + ""));
        UrlQuerySanitizer sanitizer = new UrlQuerySanitizer(url);
        Log.e((String)"url>>>", (String)url);
        view.loadUrl(url);
        if (url.contains("https://hippochat.io")) {
            Intent mIntent = new Intent("CALL TERMINATED");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(mIntent);
            this.endcall();
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoSdkMeetingActivity.this.finish();
                }
            }, 2000L);
        }
        return true;
    }

    private JSONObject getDeviceDetails() {
        JSONObject devicePayload = new JSONObject();
        try {
            devicePayload.put("device_id", (Object)UniqueIMEIID.getUniqueIMEIId((Context)this));
            devicePayload.put("device_type", 1);
            devicePayload.put("app_version", (Object)HippoConfig.getInstance().getVersionName());
            devicePayload.put("device_details", (Object)CommonData.deviceDetails((Context)this));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return devicePayload;
    }

    private class MyWebViewClient
    extends WebViewClient {
        private MyWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            return VideoSdkMeetingActivity.this.onOverrideUrlLoading(view, request.getUrl().toString());
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return VideoSdkMeetingActivity.this.onOverrideUrlLoading(view, url);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            VideoSdkMeetingActivity.this.myWebView.setVisibility(0);
            VideoSdkMeetingActivity.this.connectingTV.setVisibility(8);
            super.onPageStarted(view, url, favicon);
        }
    }
}

