/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.database;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.hippo.CaptureUserData;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.HippoConfigAttributes;
import com.hippo.HippoCreateTicketAttribute;
import com.hippo.MobileCampaignBuilder;
import com.hippo.R;
import com.hippo.database.PaperDbConstant;
import com.hippo.langs.Restring;
import com.hippo.langs.Translation;
import com.hippo.model.AdvanceSpecInfoModel;
import com.hippo.model.AgentInfoResponse;
import com.hippo.model.AppUpdateModel;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguGetMessageResponse;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.Message;
import com.hippo.model.PaymentData;
import com.hippo.model.UnreadCountModel;
import com.hippo.model.groupCall.GroupCallData;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.model.promotional.PromotionResponse;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import io.paperdb.Paper;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.json.JSONObject;

public final class CommonData
implements PaperDbConstant {
    public static List<FuguConversation> CONVERSATION_LIST = Collections.emptyList();
    public static FuguPutUserDetailsResponse USER_DETAILS = null;
    public static String SERVER_URL = "";
    public static String APP_SECRET_KEY = "";
    public static String APP_TYPE = "1";
    public static TreeMap<Long, FuguGetMessageResponse> GET_MESSAGE_RESPONSE_MAP = new TreeMap();
    public static TreeMap<Long, FuguGetMessageResponse> GET_LABEL_ID_RESPONSE_MAP = new TreeMap();
    public static TreeMap<Long, TreeMap<String, Message>> UNSENT_MESSAGE_MAP = new TreeMap();
    public static HippoColorConfig COLOR_CONFIG = new HippoColorConfig();
    public static String isNewChatKey = "IS_NEW_CHAT";
    public static String providerKey = "PROVIDER_KEY";
    public static String pushKey = "PUSH_KEY";
    public static String NOTIFICATION_FIRST_CLICK = "hippo_notification_first_click";
    public static String pushChannelKey = "PUSH_CHANNEL_KEY";
    public static String isAppOpenKey = "isAppOpen";
    public static TreeMap<Long, ArrayList<Message>> FUGU_MESSAGE_LIST = new TreeMap();
    public static final String clearFuguDataKey = "clearHippoData";
    public static final String HIPPO_UNREAD_COUNT = "hippo_unread_count";
    public static final String HIPPO_TOTAL_UNREAD_COUNT = "hippo_total_unread_count";
    public static final String HIPPO_HAS_UNREAD_COUNT = "hippo_has_unread_count";
    private static String keyQuickReply = "saveQuickReplay";
    public static String HIPPO_PAPER_NAME = HippoConfig.getInstance().getDBName();
    public static HashMap<Long, LinkedHashMap<String, JSONObject>> UNSENT_MESSAGE_JSON = new HashMap();
    public static HashMap<Long, LinkedHashMap<String, Message>> SENT_MESSAGES = new HashMap();
    public static HashMap<Long, LinkedHashMap<String, Message>> UNSENT_MESSAGES = new HashMap();
    public static HashMap<Long, Long> LABEL_CHANNEL_ID = new HashMap();
    public static TreeMap<String, AgentInfoResponse> GET_AGENT_RESPONSE_MAP = new TreeMap();
    public static Type listType = new TypeToken<List<UnreadCountModel>>(){}.getType();
    private static HashMap<String, GroupCallData> GROUP_CALL_DATA = new HashMap();

    private CommonData() {
    }

    public static void setMessageResponse(Long channelId, FuguGetMessageResponse getMessageResponse) {
        GET_MESSAGE_RESPONSE_MAP.put(channelId, getMessageResponse);
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_get_message_response_map", GET_MESSAGE_RESPONSE_MAP);
    }

    public static FuguGetMessageResponse getMessageResponse(Long channelId) {
        if (GET_MESSAGE_RESPONSE_MAP.isEmpty()) {
            try {
                GET_MESSAGE_RESPONSE_MAP = (TreeMap)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_get_message_response_map", new TreeMap());
            }
            catch (Exception e) {
                GET_MESSAGE_RESPONSE_MAP = new TreeMap();
            }
        }
        return GET_MESSAGE_RESPONSE_MAP.get(channelId);
    }

    public static FuguGetMessageResponse getLabelIdResponse(Long labelId) {
        if (GET_LABEL_ID_RESPONSE_MAP.isEmpty()) {
            try {
                GET_LABEL_ID_RESPONSE_MAP = (TreeMap)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_get_label_id_response_map", new TreeMap());
            }
            catch (Exception e) {
                GET_LABEL_ID_RESPONSE_MAP = new TreeMap();
            }
        }
        return GET_LABEL_ID_RESPONSE_MAP.get(labelId);
    }

    public static void setServerUrl(String serverUrl) {
        SERVER_URL = serverUrl;
        try {
            Paper.book((String)HIPPO_PAPER_NAME).write("fugu_server_url", (Object)SERVER_URL);
        }
        catch (Exception e) {
            Paper.book((String)"hippo.paperdb").write("fugu_server_url", (Object)SERVER_URL);
        }
    }

    public static String getServerUrl() {
        if (TextUtils.isEmpty((CharSequence)SERVER_URL.trim())) {
            try {
                SERVER_URL = (String)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_server_url", (Object)"https://api.hippochat.io");
            }
            catch (Exception e) {
                SERVER_URL = "https://api.hippochat.io";
            }
        }
        return SERVER_URL;
    }

    public static String getAuthKey() {
        String serverUrl = CommonData.getServerUrl();
        String authKey = serverUrl.equalsIgnoreCase("https://api.hippochat.io") ? "q4t7w!z%C*F-J@NcRfUjXn2r5u8x/A?D" : (serverUrl.equalsIgnoreCase("https://hippog-server.fuguchat.com:3003") ? "aTbetaT%qC>i2to<AANI" : "aTT%qC>i2to<AANI$mdq");
        return authKey;
    }

    public static void openWhatsApp(Activity activity) {
        String smsNumber = CommonData.getUserDetails().getData().getWhatsappWidgetConfig().getWhatsappContactNumber();
        Uri uri_ = Uri.parse((String)("https://api.whatsapp.com/send?phone=" + PhoneNumberUtils.stripSeparators((String)smsNumber) + "&text=" + CommonData.getUserDetails().getData().getWhatsappWidgetConfig().getDefaultMessage()));
        Intent i = new Intent("android.intent.action.VIEW", uri_);
        if (!CommonData.whatsappInstalledOrNot("com.whatsapp", activity)) {
            Toast.makeText((Context)activity, (CharSequence)"Whatsapp not installed", (int)1).show();
            Uri uri = Uri.parse((String)"market://details?id=com.whatsapp");
            Intent goToMarket = new Intent("android.intent.action.VIEW", uri);
            Toast.makeText((Context)activity, (CharSequence)"WhatsApp not Installed", (int)0).show();
            activity.startActivity(goToMarket);
        }
        try {
            activity.startActivity(i);
        }
        catch (ActivityNotFoundException ex) {
            ex.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)"Whatsapp not installed", (int)1).show();
            Uri uri = Uri.parse((String)"market://details?id=com.whatsapp");
            Intent goToMarket = new Intent("android.intent.action.VIEW", uri);
            Toast.makeText((Context)activity, (CharSequence)"WhatsApp not Installed", (int)0).show();
            activity.startActivity(goToMarket);
        }
    }

    public static boolean whatsappInstalledOrNot(String uri, Activity activity) {
        boolean app_installed = false;
        try {
            PackageManager pm = activity.getPackageManager();
            pm.getPackageInfo(uri, 1);
            app_installed = true;
        }
        catch (Exception e) {
            app_installed = false;
        }
        return app_installed;
    }

    public static void setSocketServerUrl(String serverUrl) {
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_socket_server_url", (Object)serverUrl);
    }

    public static String getSocketServerUrl() {
        try {
            return (String)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_socket_server_url", (Object)"https://event.hippochat.io/");
        }
        catch (Exception e) {
            return "https://event.hippochat.io/";
        }
    }

    public static void setAppSecretKey(String appSecretKey) {
        APP_SECRET_KEY = appSecretKey;
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_app_secret_key", (Object)APP_SECRET_KEY);
    }

    public static String getAppSecretKey() {
        if (APP_SECRET_KEY.isEmpty()) {
            APP_SECRET_KEY = (String)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_app_secret_key", (Object)"");
        }
        return APP_SECRET_KEY;
    }

    public static void setAppType(String appType) {
        APP_TYPE = appType;
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_app_type_string", (Object)APP_TYPE);
    }

    public static String getAppType() {
        APP_TYPE = (String)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_app_type_string", (Object)"1");
        return APP_TYPE;
    }

    public static int getPushFlags() {
        try {
            return (Integer)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_push_flags", (Object)-1);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void setPushFlags(int flags) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_push_flags", (Object)flags);
    }

    public static void setCachedMessages(boolean isOpenChat, Long mapKey, ArrayList<Message> cachedMessages) {
        if (isOpenChat && GET_LABEL_ID_RESPONSE_MAP.get(mapKey) != null && GET_LABEL_ID_RESPONSE_MAP.get(mapKey).getData() != null) {
            GET_LABEL_ID_RESPONSE_MAP.get(mapKey).getData().getMessages().clear();
            GET_LABEL_ID_RESPONSE_MAP.get(mapKey).getData().getMessages().addAll(cachedMessages);
        } else if (GET_MESSAGE_RESPONSE_MAP.get(mapKey) != null && GET_MESSAGE_RESPONSE_MAP.get(mapKey).getData() != null) {
            GET_MESSAGE_RESPONSE_MAP.get(mapKey).getData().getMessages().clear();
            GET_MESSAGE_RESPONSE_MAP.get(mapKey).getData().getMessages().addAll(cachedMessages);
        }
    }

    public static void setConversationList(List<FuguConversation> conversationList) {
        CONVERSATION_LIST = conversationList;
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_conversation_list", conversationList);
    }

    public static List<FuguConversation> getConversationList() {
        if (CONVERSATION_LIST.isEmpty()) {
            try {
                CONVERSATION_LIST = (List)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_conversation_list", Collections.emptyList());
            }
            catch (Exception e) {
                CONVERSATION_LIST = Collections.emptyList();
            }
        }
        return CONVERSATION_LIST;
    }

    public static FuguPutUserDetailsResponse getUserDetails() {
        if (USER_DETAILS == null) {
            USER_DETAILS = (FuguPutUserDetailsResponse)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_user_details", null);
        }
        return USER_DETAILS;
    }

    public static void setColorConfig(HippoColorConfig hippoColorConfig) {
        COLOR_CONFIG = hippoColorConfig;
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_color_config", (Object)hippoColorConfig);
    }

    public static HippoColorConfig getColorConfig() {
        if (COLOR_CONFIG == null) {
            COLOR_CONFIG = (HippoColorConfig)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_color_config", null);
        }
        return COLOR_CONFIG;
    }

    public static void setUserDetails(FuguPutUserDetailsResponse userDetails) {
        USER_DETAILS = userDetails;
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_user_details", (Object)userDetails);
    }

    public static FuguPutUserDetailsResponse getUpdatedDetails() {
        USER_DETAILS = (FuguPutUserDetailsResponse)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_user_details", null);
        return USER_DETAILS;
    }

    public static void clearData() throws Exception {
        USER_DETAILS = null;
        CONVERSATION_LIST = Collections.emptyList();
        GET_MESSAGE_RESPONSE_MAP = new TreeMap();
        GET_LABEL_ID_RESPONSE_MAP = new TreeMap();
        UNSENT_MESSAGE_MAP = new TreeMap();
        SERVER_URL = "";
        APP_SECRET_KEY = "";
        COLOR_CONFIG = new HippoColorConfig();
        APP_TYPE = "";
        Paper.book((String)HIPPO_PAPER_NAME).destroy();
    }

    public static JsonObject deviceDetails(Context context) {
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree((Object)new FuguDeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails()).getAsJsonObject();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;
    }

    public static String deviceDetailString(Context context) {
        Gson gson = new GsonBuilder().create();
        String deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJson((Object)new FuguDeviceDetails(CommonData.getAppVersion(context)).getDeviceDetails());
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return deviceDetailsJson;
    }

    public static int getAppVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (Exception ex) {
            HippoLog.e("IP Address", ex.toString());
        }
        return null;
    }

    public static void setIsNewchat(boolean isNewchat) {
        Paper.book((String)HIPPO_PAPER_NAME).write(isNewChatKey, (Object)isNewchat);
    }

    public static boolean getIsNewChat() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read(isNewChatKey);
    }

    public static void setProvider(String provider) {
        Paper.book((String)HIPPO_PAPER_NAME).write(providerKey, (Object)provider);
    }

    public static String getProvider() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read(providerKey);
    }

    public static void setPushBoolean(boolean push) {
        Paper.book((String)HIPPO_PAPER_NAME).write(pushKey, (Object)push);
    }

    public static boolean getPushBoolean() {
        if (Paper.book((String)HIPPO_PAPER_NAME).read(pushKey) == null) {
            return false;
        }
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read(pushKey);
    }

    public static void setNotificationFirstClick(boolean flag) {
        Paper.book((String)HIPPO_PAPER_NAME).write(NOTIFICATION_FIRST_CLICK, (Object)flag);
    }

    public static boolean isFirstTimeWithNotification() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read(NOTIFICATION_FIRST_CLICK, (Object)false);
    }

    public static void setPushChannel(Long pushChannel) {
        Paper.book((String)HIPPO_PAPER_NAME).write(pushChannelKey, (Object)pushChannel);
    }

    public static Long getPushChannel() {
        if (Paper.book((String)HIPPO_PAPER_NAME).read(pushChannelKey) == null) {
            return -1L;
        }
        return (Long)Paper.book((String)HIPPO_PAPER_NAME).read(pushChannelKey);
    }

    public static void clearPushChannel() {
        Paper.book((String)HIPPO_PAPER_NAME).delete(pushChannelKey);
    }

    public static void setTransactionIdsMap(HashMap<String, Long> transactionIdsMap) {
        Paper.book((String)HIPPO_PAPER_NAME).write("TransactionIdsMap", transactionIdsMap);
    }

    public static HashMap<String, Long> getTransactionIdsMap() {
        try {
            return (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("TransactionIdsMap");
        }
        catch (Exception e) {
            return new HashMap<String, Long>();
        }
    }

    public static boolean getIsAppOpen() {
        if (Paper.book((String)HIPPO_PAPER_NAME).read(isAppOpenKey) == null) {
            return true;
        }
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read(isAppOpenKey);
    }

    public static void setIsAppOpen(boolean isAppOpen) {
        Paper.book((String)HIPPO_PAPER_NAME).write(isAppOpenKey, (Object)isAppOpen);
    }

    public static void setClearHippoDataKey(boolean clearFuguData) {
        Paper.book((String)HIPPO_PAPER_NAME).write(clearFuguDataKey, (Object)clearFuguData);
    }

    public static boolean getClearHippoDataKey() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read(clearFuguDataKey, (Object)false);
    }

    public static void saveDeviceToken(String deviceToken) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_device_token", (Object)deviceToken);
    }

    public static String getDeviceToken() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_device_token", (Object)"");
    }

    public static void setTotalUnreadCount(int count) {
        Paper.book((String)HIPPO_PAPER_NAME).write(HIPPO_TOTAL_UNREAD_COUNT, (Object)count);
    }

    public static int getTotalUnreadCount() {
        try {
            return (Integer)Paper.book((String)HIPPO_PAPER_NAME).read(HIPPO_TOTAL_UNREAD_COUNT, (Object)0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void hasUnreadCount(boolean flag) {
        Paper.book((String)HIPPO_PAPER_NAME).write(HIPPO_HAS_UNREAD_COUNT, (Object)flag);
    }

    public static boolean getHasUnreadCount() {
        try {
            return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read(HIPPO_HAS_UNREAD_COUNT, (Object)false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setUnreadCount(ArrayList<UnreadCountModel> unreadCount) {
        Paper.book((String)HIPPO_PAPER_NAME).write(HIPPO_UNREAD_COUNT, unreadCount);
    }

    public static ArrayList<UnreadCountModel> getUnreadCountModel() {
        ArrayList countModel = null;
        try {
            countModel = (ArrayList)Paper.book((String)HIPPO_PAPER_NAME).read(HIPPO_UNREAD_COUNT, new ArrayList());
        }
        catch (Exception e) {
            countModel = new ArrayList();
        }
        return countModel;
    }

    public static void setIsDataCleared(boolean isDataCleared) {
        Paper.book((String)HIPPO_PAPER_NAME).write("isDataCleared", (Object)isDataCleared);
    }

    public static boolean getIsDataCleared() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("isDataCleared", (Object)false);
    }

    public static void setChatTitle(String chatTitle) {
        Paper.book((String)HIPPO_PAPER_NAME).write("chat_title", (Object)chatTitle);
    }

    public static String getChatTitle(Activity activity) {
        String title = (String)Paper.book((String)HIPPO_PAPER_NAME).read("chat_title", (Object)"");
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = Restring.getString((Context)activity, R.string.fugu_support);
        }
        return title;
    }

    public static String getChatTitleContext() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("chat_title", (Object)"");
    }

    public static void saveResellerData(String resellerToken, int referenceId) {
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_resellerToken", (Object)resellerToken);
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_referenceId", (Object)referenceId);
    }

    public static void saveFuguConfigAttribute(HippoConfigAttributes attributes) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_config_attribute", (Object)attributes);
    }

    public static HippoConfigAttributes getAttributes() {
        return (HippoConfigAttributes)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_config_attribute");
    }

    public static void saveTicketAttribute(HippoCreateTicketAttribute attributes) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_create_ticket_attribute", (Object)attributes);
    }

    public static HippoCreateTicketAttribute getTicketAttributes() {
        return (HippoCreateTicketAttribute)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_create_ticket_attribute");
    }

    public static void saveUserData(CaptureUserData userData) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_userData", (Object)userData);
        CommonData.setUserId(String.valueOf(userData.getUserId()));
    }

    public static void saveAdvanceSpecData(AdvanceSpecInfoModel advanceSpecInfoModel) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_advance_spec_data", (Object)advanceSpecInfoModel);
    }

    public static AdvanceSpecInfoModel getAdvanceSpecData() {
        try {
            return (AdvanceSpecInfoModel)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_advance_spec_data", (Object)new AdvanceSpecInfoModel());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CaptureUserData getUserData() {
        try {
            return (CaptureUserData)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_userData", (Object)new CaptureUserData());
        }
        catch (Exception e) {
            return new CaptureUserData();
        }
    }

    public static int getReferenceId() {
        return (Integer)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_referenceId", (Object)1);
    }

    public static String getResellerToken() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_resellerToken", null);
    }

    public static void setCurrentVersion(int versionCode) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_db_version", (Object)versionCode);
    }

    public static int getLocalVersion() {
        return (Integer)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_db_version", (Object)-1);
    }

    public static String getDefaultCategory() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_user_default_category", null);
    }

    public static void setDefaultCategory(String defaultCategory) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_user_default_category", (Object)defaultCategory);
    }

    public static void setSupportPath(ArrayList<String> pathList) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_support_path", pathList);
        HippoLog.d("TAG", "Path = " + new Gson().toJson(pathList));
    }

    public static ArrayList<String> getPathList() {
        return (ArrayList)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_support_path", new ArrayList());
    }

    public static void removeLastPath() {
        ArrayList<String> pathList = CommonData.getPathList();
        pathList.remove(pathList.size() - 1);
        CommonData.setSupportPath(pathList);
    }

    public static void clearPathList() {
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_support_path");
    }

    public static void saveUserUniqueKey(String userUniqueKey) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_user_unique_key", (Object)userUniqueKey);
    }

    public static String getUserUniqueKey() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_user_unique_key");
    }

    public static Message getQuickReplyData() {
        return (Message)Paper.book((String)HIPPO_PAPER_NAME).read(keyQuickReply);
    }

    public static void setQuickReplyData(Message quickReplyData) {
        Paper.book((String)HIPPO_PAPER_NAME).write(keyQuickReply, (Object)quickReplyData);
    }

    public static void clearQuickReplyData() {
        Paper.book((String)HIPPO_PAPER_NAME).delete(keyQuickReply);
    }

    public static void setUnsentMessageMapByChannel(Long uniqueId, LinkedHashMap<String, JSONObject> unsentMessageMap) {
        UNSENT_MESSAGE_JSON = CommonData.getUnsentMessageMap();
        if (unsentMessageMap != null && unsentMessageMap.values().size() > 0) {
            UNSENT_MESSAGE_JSON.put(uniqueId, unsentMessageMap);
            Paper.book((String)HIPPO_PAPER_NAME).write("hippo_unsent_message_map", UNSENT_MESSAGE_JSON);
        }
    }

    public static void removeUnsentMessageMapChannel(Long channelId) {
        UNSENT_MESSAGE_JSON = CommonData.getUnsentMessageMap();
        UNSENT_MESSAGE_JSON.remove(channelId);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_unsent_message_map", UNSENT_MESSAGE_JSON);
    }

    public static LinkedHashMap<String, JSONObject> getUnsentMessageMapByChannel(Long channelId) {
        UNSENT_MESSAGE_JSON = CommonData.getUnsentMessageMap();
        return UNSENT_MESSAGE_JSON.get(channelId);
    }

    public static HashMap<Long, LinkedHashMap<String, JSONObject>> getUnsentMessageMap() {
        try {
            UNSENT_MESSAGE_JSON = (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_unsent_message_map", new HashMap());
        }
        catch (Exception e) {
            UNSENT_MESSAGE_JSON = new HashMap();
        }
        return UNSENT_MESSAGE_JSON;
    }

    public static void clearAllUnsentMessages() {
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_unsent_message_map");
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_unsent_messages");
    }

    public static void setAllUnsentMessageByChannel(LinkedHashMap<String, Message> unsentMessage) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_unsent_messages", unsentMessage);
    }

    public static void setUnsentMessageByChannel(Long channelId, LinkedHashMap<String, Message> unsentMessage) {
        UNSENT_MESSAGES = CommonData.getUnsentMessages();
        if (unsentMessage != null && unsentMessage.values().size() > 0) {
            UNSENT_MESSAGES.put(channelId, unsentMessage);
            Paper.book((String)HIPPO_PAPER_NAME).write("hippo_unsent_messages", UNSENT_MESSAGES);
        }
    }

    public static void removeUnsentMessageChannel(Long channelId) {
        UNSENT_MESSAGES = CommonData.getUnsentMessages();
        UNSENT_MESSAGES.remove(channelId);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_unsent_messages", UNSENT_MESSAGES);
    }

    public static LinkedHashMap<String, Message> getUnsentMessageByChannel(Long channelId) {
        UNSENT_MESSAGES = CommonData.getUnsentMessages();
        return UNSENT_MESSAGES.get(channelId);
    }

    public static HashMap<Long, LinkedHashMap<String, Message>> getUnsentMessages() {
        try {
            UNSENT_MESSAGES = (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_unsent_messages", new HashMap());
        }
        catch (Exception e) {
            UNSENT_MESSAGES = new HashMap();
        }
        return UNSENT_MESSAGES;
    }

    public static void addExistingMessages(Long channelId, LinkedHashMap<String, Message> sentMessage) {
        LinkedHashMap<String, Message> allSentMessages = CommonData.getSentMessageByChannel(channelId);
        allSentMessages.putAll(sentMessage);
        CommonData.setSentMessageByChannel(channelId, allSentMessages);
    }

    public static void setSentMessageByChannel(Long channelId, LinkedHashMap<String, Message> sentMessage) {
        SENT_MESSAGES = CommonData.getSentMessages();
        SENT_MESSAGES.put(channelId, sentMessage);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_sent_messages", SENT_MESSAGES);
    }

    public static void removeSentMessageChannel(Long channelId) {
        SENT_MESSAGES = CommonData.getSentMessages();
        SENT_MESSAGES.remove(channelId);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_sent_messages", SENT_MESSAGES);
    }

    public static LinkedHashMap<String, Message> getSentMessageByChannel(Long channelId) {
        SENT_MESSAGES = CommonData.getSentMessages();
        return SENT_MESSAGES.get(channelId);
    }

    public static HashMap<Long, LinkedHashMap<String, Message>> getSentMessages() {
        try {
            SENT_MESSAGES = (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_sent_messages", new HashMap());
        }
        catch (Exception e) {
            SENT_MESSAGES = new HashMap();
        }
        return SENT_MESSAGES;
    }

    public static String getCallStatus() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_call_status");
    }

    public static void setCallStatus(String callStatus) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_call_status", (Object)callStatus);
    }

    public static String getCallType() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_call_type");
    }

    public static void setUserId(String userId) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_user_id", (Object)userId);
    }

    public static void setCallType(String callType) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_call_type", (Object)callType);
    }

    public static boolean isEncodeToHtml() {
        try {
            return CommonData.getUserDetails().getData().isEncodeToHtml();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getDirectCallBtnDisabled() {
        try {
            return CommonData.getUserDetails().getData().isNavCallBtnDisabled();
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean getVideoCallStatus() {
        try {
            return CommonData.getUserDetails().getData().isVideoCallEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean getAudioCallStatus() {
        try {
            return CommonData.getUserDetails().getData().isAudioCallEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static HashMap<Long, FuguGetMessageResponse> getAgentData() {
        try {
            return (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("agent_name_data", new HashMap());
        }
        catch (Exception e) {
            return new HashMap<Long, FuguGetMessageResponse>();
        }
    }

    public static FuguGetMessageResponse getSingleAgentData(Long channelId) {
        HashMap<Long, FuguGetMessageResponse> agentNameData = CommonData.getAgentData();
        return agentNameData.get(channelId);
    }

    public static void saveVideoCallAgent(Long channelId, FuguGetMessageResponse agentName) {
        HashMap<Long, FuguGetMessageResponse> agentNameData = CommonData.getAgentData();
        agentNameData.put(channelId, agentName);
        Paper.book((String)HIPPO_PAPER_NAME).write("agent_name_data", agentNameData);
    }

    public static void setCallAnswered(boolean b) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_call_answer", (Object)b);
    }

    public static boolean isCallAnswered() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_call_answer", (Object)false);
    }

    public static void setTime(String timeStamp) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_time_stamp", (Object)timeStamp);
    }

    public static String getTime() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_time_stamp");
    }

    public static void setImageMuid(String imageMuid) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_image_muid", (Object)imageMuid);
    }

    public static String getImageMuid() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_image_muid");
    }

    public static void setFirstTimeCreated(boolean flag) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_create_first_time", (Object)flag);
    }

    public static boolean isFirstTimeCreated() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_create_first_time", (Object)true);
    }

    public static void saveUploadingFile(ArrayList<FileuploadModel> fileuploadModels) {
        Paper.book((String)HIPPO_PAPER_NAME).write("service_files_data", fileuploadModels);
    }

    public static ArrayList<FileuploadModel> getSavedFile() {
        return (ArrayList)Paper.book((String)HIPPO_PAPER_NAME).read("service_files_data", new ArrayList());
    }

    public static String getUserCountryCode() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_country_code", (Object)"");
    }

    public static String getUserContCode() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_cont_code", (Object)"");
    }

    public static void setUserCountryCode(String userCountryCode) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_country_code", (Object)userCountryCode);
    }

    public static void setUserContCode(String userContCode) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_cont_code", (Object)userContCode);
    }

    public static void savePutUserParams(HashMap<String, Object> commonParamsMap) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_user_putdata", commonParamsMap);
    }

    public static HashMap<String, Object> getPutUserParams() {
        return (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_user_putdata", new HashMap());
    }

    public static void setPaymentData(PaymentData paymentData) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_payment_data", (Object)paymentData);
    }

    public static PaymentData getPaymentData() {
        return (PaymentData)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_payment_data", (Object)new PaymentData());
    }

    public static void clearPaymentData() {
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_payment_data");
    }

    public static void setLeftTimeInSec(long leftTimeInSec) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_left_time", (Object)leftTimeInSec);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_left_time_added", (Object)System.currentTimeMillis());
    }

    public static long getLeftTime() {
        return (Long)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_left_time");
    }

    public static long getAddedLeftTime() {
        return (Long)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_left_time_added");
    }

    public static void clearLeftTimeInSec() {
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_left_time");
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_left_time_added");
    }

    public static void setUserImagePath(String imagePath) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_user_image_path", (Object)imagePath);
    }

    public static String getImagePath() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_user_image_path", (Object)"");
    }

    public static void setBotId(Integer botId) {
        if (botId != null) {
            Paper.book((String)HIPPO_PAPER_NAME).write("hippo_bot_id", (Object)botId);
        } else {
            Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_bot_id");
        }
    }

    public static int getBotId() {
        return (Integer)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_bot_id", (Object)-1);
    }

    public static void skipBot(boolean skipBot) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_skip_bot", (Object)skipBot);
    }

    public static boolean getSkipBot() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_skip_bot", (Object)false);
    }

    public static MobileCampaignBuilder getCampaignBuilder() {
        MobileCampaignBuilder campaignBuilder = new MobileCampaignBuilder.Builder().setTitle(CommonData.getMobilePushTitle()).build();
        return campaignBuilder;
    }

    public static void setMobileCampaignBuilder(MobileCampaignBuilder campaignBuilder) {
        Paper.book((String)HIPPO_PAPER_NAME).write("campaignBuilder", (Object)campaignBuilder);
    }

    public static String getMobilePushTitle() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("campaignBuilderTitle", (Object)"Inbox");
    }

    public static void setMobilePushTitle(String title) {
        Paper.book((String)HIPPO_PAPER_NAME).write("campaignBuilderTitle", (Object)title);
    }

    public static String getActionId() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_actionId", (Object)"");
    }

    public static void setActionId(String actionId) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_actionId", (Object)actionId);
    }

    public static String getUrl() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_action_url", (Object)"");
    }

    public static void setUrl(String url) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_action_url", (Object)url);
    }

    public static void setChannelId(Long labelId, Long channelId) {
        HashMap<Long, Long> allChannels = CommonData.getChhannelLabelds();
        allChannels.put(labelId, channelId);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_channel_labels", allChannels);
    }

    private static HashMap<Long, Long> getChhannelLabelds() {
        try {
            return (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_channel_labels", new HashMap());
        }
        catch (Exception e) {
            return new HashMap<Long, Long>();
        }
    }

    public static Long getChannelId(Long labelId) {
        try {
            HashMap<Long, Long> allChannels = CommonData.getChhannelLabelds();
            Long channelId = -1L;
            channelId = allChannels.get(labelId);
            if (channelId == null) {
                channelId = -1L;
            }
            return channelId;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static void setNewBackBtn(boolean flag) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_nav_btn_required", (Object)flag);
    }

    public static boolean isBackBtn() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_nav_btn_required", (Object)true);
    }

    public static void saveVersionInfo(AppUpdateModel update) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_version_check", (Object)update);
    }

    public static AppUpdateModel getVersionInfo() {
        try {
            return (AppUpdateModel)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_version_check", null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void saveAgentData(String agentId, AgentInfoResponse infoResponse) {
        GET_AGENT_RESPONSE_MAP.put(agentId, infoResponse);
        Paper.book((String)HIPPO_PAPER_NAME).write("fugu_get_agent_response_map", GET_AGENT_RESPONSE_MAP);
    }

    public static AgentInfoResponse getSavedAgentData(String agentId) {
        if (GET_AGENT_RESPONSE_MAP.isEmpty()) {
            try {
                GET_AGENT_RESPONSE_MAP = (TreeMap)Paper.book((String)HIPPO_PAPER_NAME).read("fugu_get_agent_response_map", new TreeMap());
                if (GET_AGENT_RESPONSE_MAP.size() > 40) {
                    Paper.book((String)HIPPO_PAPER_NAME).write("fugu_get_agent_response_map", new TreeMap());
                }
            }
            catch (Exception e) {
                GET_AGENT_RESPONSE_MAP = new TreeMap();
            }
        }
        return GET_AGENT_RESPONSE_MAP.get(agentId);
    }

    public static String getAppName() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_app_name");
    }

    public static void setAppName(String appName) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_app_name", (Object)appName);
    }

    public static void savePaymentList(List<AddedPaymentGateway> addedPaymentGateways) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_payment_list", addedPaymentGateways);
    }

    public static List<AddedPaymentGateway> getPaymentList() {
        try {
            return (List)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_payment_list", new ArrayList());
        }
        catch (Exception e) {
            return new ArrayList<AddedPaymentGateway>();
        }
    }

    public static void setConstantLabelId(Long constantLabelId) {
        Paper.book((String)HIPPO_PAPER_NAME).write("constant_label_id", (Object)constantLabelId);
    }

    public static Long getConstantLabelId() {
        return (Long)Paper.book((String)HIPPO_PAPER_NAME).read("constant_label_id", (Object)-1L);
    }

    public static void directScreens(boolean flag) {
        Paper.book((String)HIPPO_PAPER_NAME).write("directScreens", (Object)flag);
    }

    public static boolean hasDirectScreen() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("directScreens", (Object)false);
    }

    public static PromotionResponse getPromotionResponse() {
        return (PromotionResponse)Paper.book((String)HIPPO_PAPER_NAME).read("promotionResponse", null);
    }

    public static void savePromotionResponse(PromotionResponse response) {
        Paper.book((String)HIPPO_PAPER_NAME).write("promotionResponse", (Object)response);
    }

    public static HashSet<String> getAnnouncementCount() {
        return (HashSet)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_annoucement_list", new HashSet());
    }

    public static void setAnnouncementCount(HashSet<String> count) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_annoucement_list", count);
    }

    public static void deleteAnnouncementCount() {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_annoucement_list", new HashSet());
    }

    public static void saveLangKeys(Translation translation) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_lang_keys", (Object)translation);
    }

    public static Translation getLangKeys() {
        return (Translation)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_lang_keys", (Object)new Translation());
    }

    public static String getCurrentLanguage() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_current_lang", (Object)"");
    }

    public static void saveCurrentLang(String lang) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_current_lang", (Object)lang);
    }

    public static void saveRequiredLang(String lang) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_required_lang", (Object)lang);
    }

    public static String getRequiredLanguage() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_required_lang", (Object)"");
    }

    public void clearLangKeys() {
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_lang_keys");
    }

    public static void saveGroupCall(String transactionId, GroupCallData callResponse) {
        GROUP_CALL_DATA = CommonData.getAllGroupCallData();
        GROUP_CALL_DATA.put(transactionId, callResponse);
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_group_call_data", GROUP_CALL_DATA);
    }

    public static GroupCallData getGroupData(String transactionId) {
        GROUP_CALL_DATA = CommonData.getAllGroupCallData();
        return GROUP_CALL_DATA.get(transactionId);
    }

    public static GroupCallData deleteGroupData(String transactionId) {
        GROUP_CALL_DATA = CommonData.getAllGroupCallData();
        GROUP_CALL_DATA.remove(transactionId);
        return GROUP_CALL_DATA.get(transactionId);
    }

    private static HashMap<String, GroupCallData> getAllGroupCallData() {
        return (HashMap)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_group_call_data", new HashMap());
    }

    public static void saveData(String key, String value) {
        Paper.book((String)HIPPO_PAPER_NAME).write(key, (Object)value);
    }

    public static String getDate(String key) {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read(key, (Object)"");
    }

    public static void saveData(String key, int value) {
        Paper.book((String)HIPPO_PAPER_NAME).write(key, (Object)value);
    }

    public static int getInt(String key, int defaultValue) {
        return (Integer)Paper.book((String)HIPPO_PAPER_NAME).read(key, (Object)defaultValue);
    }

    public static void saveExtraData(Object object) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_extra_ticket_data", object);
    }

    public static Object getExtraTicketData() {
        return Paper.book((String)HIPPO_PAPER_NAME).read("hippo_extra_ticket_data");
    }

    public static void clearExtraTicketData() {
        Paper.book((String)HIPPO_PAPER_NAME).delete("hippo_extra_ticket_data");
    }

    public static Long getDiff() {
        return (Long)Paper.book((String)HIPPO_PAPER_NAME).read("hippo_time_diff", (Object)0L);
    }

    public static void saveTimeDiff(Long timeDiff) {
        Paper.book((String)HIPPO_PAPER_NAME).write("hippo_time_diff", (Object)timeDiff);
    }

    public static void savePermissionAsked(boolean isPushEnabled) {
        Paper.book((String)HIPPO_PAPER_NAME).write("is_push_enabled", (Object)isPushEnabled);
    }

    public static Boolean checkPermissionAsked() {
        return (Boolean)Paper.book((String)HIPPO_PAPER_NAME).read("is_push_enabled", (Object)false);
    }

    public static void saveSessionId(String sessionId) {
        Paper.book((String)HIPPO_PAPER_NAME).write("session_id", (Object)sessionId);
    }

    public static String getSessionId() {
        return (String)Paper.book((String)HIPPO_PAPER_NAME).read("session_id", (Object)"");
    }
}

