/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.encription;

import android.content.Context;
import com.hippo.encription.AssetsFileReader;
import com.hippo.encription.AssetsFileReaderInterface;
import com.hippo.encription.JsCallback;
import com.hippo.encription.JsEncryptorInterface;
import com.hippo.encription.ShowFatalError;
import com.hippo.encription.jsevaluator.JsEvaluator;
import com.hippo.encription.jsevaluator.interfaces.JsEvaluatorInterface;
import java.io.IOException;
import java.util.ArrayList;

public class JsEncryptor
implements JsEncryptorInterface {
    private final AssetsFileReaderInterface mAssetsFileReader;
    private final JsEvaluatorInterface mJsEvaluator;
    private final String cryptoJsFileNames = "crypto_js";
    private final String aesCryptoFileName = "aes_crypto";
    private final String jsRootDir = "javascript";
    private static final String prefix = "AESCryptoV10";
    private ArrayList<String> mScriptsText;

    public static JsEncryptor evaluateAllScripts(Context context) {
        AssetsFileReader assetsFileReader = new AssetsFileReader(context);
        JsEvaluator jsEvaluator = new JsEvaluator(context);
        JsEncryptor jsEncryptor = new JsEncryptor(assetsFileReader, jsEvaluator);
        try {
            jsEncryptor.readScripts();
        }
        catch (IOException e) {
            ShowFatalError.showAlertAndExit(context, "Can not read JavaScript file.", e);
        }
        return jsEncryptor;
    }

    public JsEncryptor(AssetsFileReaderInterface assetsFileReader, JsEvaluatorInterface jsEvaluator) {
        this.mAssetsFileReader = assetsFileReader;
        this.mJsEvaluator = jsEvaluator;
    }

    public String concatenateScripts() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> scripts = this.getScripts();
        for (String scriptText : scripts) {
            stringBuilder.append(scriptText);
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    @Override
    public void decrypt(String text, String password, JsCallback callback) {
        String libraryJsCode = this.concatenateScripts();
        this.mJsEvaluator.callFunctionAndRespondOnBackgroundThread(libraryJsCode, callback, "aesCrypto.decrypt", text, password);
    }

    @Override
    public void encrypt(String text, String password, JsCallback callback) {
        String libraryJsCode = this.concatenateScripts();
        this.mJsEvaluator.callFunctionAndRespondOnBackgroundThread(libraryJsCode, callback, "aesCrypto.encrypt", text, password);
    }

    public ArrayList<String> getScripts() {
        if (this.mScriptsText == null) {
            this.mScriptsText = new ArrayList();
        }
        return this.mScriptsText;
    }

    public void readScripts() throws IOException {
        ArrayList<String> scriptsToLoad = new ArrayList<String>();
        scriptsToLoad.add("javascript/crypto_js.js");
        scriptsToLoad.add("javascript/aes_crypto.js");
        ArrayList<String> scriptsText = this.getScripts();
        for (String scriptName : scriptsToLoad) {
            scriptsText.add(this.mAssetsFileReader.ReadFile(scriptName));
        }
    }
}

