/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.encription.jsevaluator;

import android.content.Context;
import com.hippo.HippoConfig;
import com.hippo.encription.JsCallback;
import com.hippo.encription.jsevaluator.JsCallbackData;
import com.hippo.encription.jsevaluator.JsFunctionCallFormatter;
import com.hippo.encription.jsevaluator.JsResultContainer;
import com.hippo.encription.jsevaluator.UiThreadHandlerWrapper;
import com.hippo.encription.jsevaluator.WebViewWrapper;
import com.hippo.encription.jsevaluator.interfaces.CallJavaResultInterface;
import com.hippo.encription.jsevaluator.interfaces.HandlerWrapperInterface;
import com.hippo.encription.jsevaluator.interfaces.JsEvaluatorInterface;
import com.hippo.encription.jsevaluator.interfaces.WebViewWrapperInterface;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class JsEvaluator
implements CallJavaResultInterface,
JsEvaluatorInterface {
    public static final String JS_NAMESPACE = "evgeniiJsEvaluator";
    protected WebViewWrapperInterface mWebViewWrapper;
    private final Context mContext;
    private final ArrayList<JsCallbackData> mResultCallbacks = new ArrayList();
    private HandlerWrapperInterface mUiThreadHandler;

    public static String escapeCarriageReturn(String str) {
        return str.replace("\r", "\\r");
    }

    public static String escapeClosingScript(String str) {
        return str.replace("</", "<\\/");
    }

    public static String escapeNewLines(String str) {
        return str.replace("\n", "\\n");
    }

    public static String escapeSingleQuotes(String str) {
        return str.replace("'", "\\'");
    }

    public static String escapeSlash(String str) {
        return str.replace("\\", "\\\\");
    }

    public static String getJsForEval(String jsCode, int callbackIndex) {
        jsCode = JsEvaluator.escapeSlash(jsCode);
        jsCode = JsEvaluator.escapeSingleQuotes(jsCode);
        jsCode = JsEvaluator.escapeClosingScript(jsCode);
        jsCode = JsEvaluator.escapeNewLines(jsCode);
        jsCode = JsEvaluator.escapeCarriageReturn(jsCode);
        return String.format("%s.returnResultToJava(eval('%s'), %s);", JS_NAMESPACE, jsCode, callbackIndex);
    }

    public JsEvaluator(Context context) {
        this.mContext = context;
        this.mUiThreadHandler = new UiThreadHandlerWrapper();
    }

    @Override
    public void evaluateAndRespondOnUiThread(String jsCode, JsCallback resultCallback) {
        this.evaluate(jsCode, resultCallback, true);
    }

    @Override
    public void evaluateAndRespondOnBackgroundThread(String jsCode, JsCallback resultCallback) {
        this.evaluate(jsCode, resultCallback, false);
    }

    @Override
    public String blockUIThreadAndEvaluate(long waitTimeoutMilliseconds, String jsCode) {
        return this.blockUiThreadAndEvaluateShared(waitTimeoutMilliseconds, jsCode);
    }

    private String blockUiThreadAndEvaluateShared(long waitTimeoutMilliseconds, String jsCode) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final JsResultContainer jsResultContainer = new JsResultContainer();
        this.evaluateAndRespondOnBackgroundThread(jsCode, new JsCallback(){

            @Override
            public void onResult(String result) {
                jsResultContainer.result = result;
                countDownLatch.countDown();
            }

            @Override
            public void onError(String errorMessage) {
            }
        });
        try {
            countDownLatch.await(waitTimeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return jsResultContainer.result;
    }

    private void evaluate(String jsCode, JsCallback resultCallback, Boolean executeCallbackInUiThread) {
        int callbackIndex = this.mResultCallbacks.size();
        if (resultCallback == null) {
            callbackIndex = -1;
        }
        String js = JsEvaluator.getJsForEval(jsCode, callbackIndex);
        JsCallbackData callbackData = new JsCallbackData(resultCallback, executeCallbackInUiThread);
        if (resultCallback != null) {
            this.mResultCallbacks.add(callbackData);
        }
        this.getWebViewWrapper().loadJavaScript(js);
    }

    @Override
    public void callFunctionAndRespondOnUiThread(String jsCode, JsCallback resultCallback, String functionName, Object ... args) {
        this.callFunction(true, jsCode, resultCallback, functionName, args);
    }

    @Override
    public void callFunctionAndRespondOnBackgroundThread(String jsCode, JsCallback resultCallback, String functionName, Object ... args) {
        this.callFunction(false, jsCode, resultCallback, functionName, args);
    }

    @Override
    public String blockUIThreadAndCallFunction(long waitTimeoutMilliseconds, String jsCode, String functionName, Object ... args) {
        jsCode = jsCode + "; " + JsFunctionCallFormatter.toString(functionName, args);
        return this.blockUiThreadAndEvaluateShared(waitTimeoutMilliseconds, jsCode);
    }

    private void callFunction(Boolean executeCallbackInUiThread, String jsCode, JsCallback resultCallback, String functionName, Object ... args) {
        jsCode = jsCode + "; " + JsFunctionCallFormatter.toString(functionName, args);
        this.evaluate(jsCode, resultCallback, executeCallbackInUiThread);
    }

    public ArrayList<JsCallbackData> getResultCallbacks() {
        return this.mResultCallbacks;
    }

    public WebViewWrapperInterface getWebViewWrapper() {
        if (this.mWebViewWrapper == null) {
            this.mWebViewWrapper = new WebViewWrapper(this.mContext, this);
        }
        return this.mWebViewWrapper;
    }

    @Override
    public void jsCallFinished(final String value, Integer callIndex) {
        if (callIndex == -1) {
            return;
        }
        final JsCallbackData callbackData = this.mResultCallbacks.get(callIndex);
        try {
            if (callbackData.callOnUiThread.booleanValue()) {
                this.mUiThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callbackData.callback.onResult(value);
                    }
                });
            } else {
                callbackData.callback.onResult(value);
            }
        }
        catch (Exception e) {
            if (HippoConfig.DEBUG) {
                e.printStackTrace();
            }
            callbackData.callback.onResult(value);
        }
    }

    public void setUiThreadHandler(HandlerWrapperInterface handlerWrapperInterface) {
        this.mUiThreadHandler = handlerWrapperInterface;
    }

    public void setWebViewWrapper(WebViewWrapperInterface webViewWrapper) {
        this.mWebViewWrapper = webViewWrapper;
    }
}

