/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.Message;
import com.hippo.utils.DateUtils;
import com.hippo.utils.filepicker.Util;
import java.util.Date;

public class BottomSheetMsgFragment
extends BottomSheetDialogFragment
implements FuguAppConstant,
View.OnClickListener {
    private LinearLayout copy;
    private LinearLayout delete;
    private LinearLayout edit;
    private LinearLayout download;
    private FuguChatActivity fuguChatActivity;
    private int position;
    private String Muid;
    private int messsagetype;
    private boolean IsSelf;
    private int MessageStatus;
    private String SentAtUtc;
    private TextView tvDelete;
    private TextView ivEditTxt;
    private TextView copyTxt;
    private TextView downloadText;
    private Boolean isReplied;
    private Boolean isAlreadyDelete;
    private Activity activity;
    Message message;

    public static BottomSheetMsgFragment newInstance(Activity activity, int pos, Message message, boolean isSelf, boolean isReplied, boolean isAlreadyDelete) {
        BottomSheetMsgFragment frag = new BottomSheetMsgFragment();
        Bundle args = new Bundle();
        frag.setArguments(args);
        frag.setPostion(pos);
        frag.setMuid(message.getMuid());
        frag.setIsSelf(isSelf);
        frag.setMessageType(message.getOriginalMessageType());
        frag.setMessageStatus(message.getMessageStatus());
        frag.setSentAtUtc(message.getSentAtUtc());
        frag.setReplied(isReplied);
        frag.setAlreadyDelete(isAlreadyDelete);
        frag.setContext(activity);
        frag.setMessage(message);
        return frag;
    }

    private void setContext(Activity activity) {
        this.activity = activity;
    }

    private void setMessage(Message message) {
        this.message = message;
    }

    private void setAlreadyDelete(boolean isAlreadyDelete) {
        this.isAlreadyDelete = isAlreadyDelete;
    }

    private void setReplied(boolean isReplied) {
        this.isReplied = isReplied;
    }

    private void setSentAtUtc(String sentAtUtc) {
        this.SentAtUtc = sentAtUtc;
    }

    private void setMessageStatus(int messsageStatus) {
        this.MessageStatus = messsageStatus;
    }

    private void setIsSelf(boolean isSelf) {
        this.IsSelf = isSelf;
    }

    private void setMessageType(int messageType) {
        this.messsagetype = messageType;
    }

    private void setMuid(String muid) {
        this.Muid = muid;
    }

    private void setPostion(int pos) {
        this.position = pos;
    }

    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.hippo_message_bottom_sheet, container, false);
        this.fuguChatActivity = (FuguChatActivity)this.getActivity();
        this.copy = (LinearLayout)view.findViewById(R.id.copy);
        this.delete = (LinearLayout)view.findViewById(R.id.delete);
        this.download = (LinearLayout)view.findViewById(R.id.download);
        this.edit = (LinearLayout)view.findViewById(R.id.edit);
        this.copyTxt = (TextView)view.findViewById(R.id.copyTxt);
        this.tvDelete = (TextView)view.findViewById(R.id.tvDelete);
        this.ivEditTxt = (TextView)view.findViewById(R.id.ivEditTxt);
        this.downloadText = (TextView)view.findViewById(R.id.downloadText);
        this.copyTxt.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_copy_text));
        this.tvDelete.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_delete_text));
        this.ivEditTxt.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_edit_text));
        this.downloadText.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.download_file));
        this.tvDelete = (TextView)view.findViewById(R.id.tvDelete);
        String localDate = DateUtils.getFormattedDate(new Date());
        int newTime = DateUtils.getTimeInMinutes(DateUtils.getInstance().convertToUTC(localDate));
        int oldTime = DateUtils.getTimeInMinutes(this.SentAtUtc);
        int editableDuration = CommonData.getUserDetails().getData().getEditDeleteDuration();
        if (!this.isAlreadyDelete.booleanValue() && this.IsSelf && editableDuration > -1 && (editableDuration == 0 || Math.abs(newTime - oldTime) <= editableDuration)) {
            if (this.messsagetype == 1) {
                this.edit.setVisibility(0);
                this.delete.setVisibility(0);
                this.copy.setVisibility(0);
                this.download.setVisibility(8);
            } else {
                this.edit.setVisibility(8);
                this.delete.setVisibility(0);
                this.copy.setVisibility(8);
                this.download.setVisibility(0);
            }
            if (this.message.getDocumentType() != null && (this.message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString()) || this.message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.IMAGE.toString()))) {
                this.download.setVisibility(8);
            } else if (this.message.getMessageType() == 22) {
                this.download.setVisibility(8);
            }
            if (this.message.getMessage() != null && !this.message.getMessage().isEmpty() && !this.message.getMessage().equalsIgnoreCase("n/a")) {
                this.edit.setVisibility(0);
            }
        } else {
            this.edit.setVisibility(8);
            this.delete.setVisibility(8);
            this.download.setVisibility(8);
            if (this.messsagetype != 1) {
                this.copy.setVisibility(8);
                this.edit.setVisibility(8);
                this.download.setVisibility(0);
                if (this.message.getDocumentType() != null && (this.message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString()) || this.message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.IMAGE.toString()))) {
                    this.download.setVisibility(8);
                    this.dismiss();
                } else if (this.message.getMessageType() == 22) {
                    this.download.setVisibility(8);
                    this.dismiss();
                }
            }
        }
        this.copy.setOnClickListener((View.OnClickListener)this);
        this.delete.setOnClickListener((View.OnClickListener)this);
        this.edit.setOnClickListener((View.OnClickListener)this);
        this.download.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        this.dismiss();
        int id2 = v.getId();
        if (id2 == R.id.edit) {
            this.fuguChatActivity.editText(this.position);
        } else if (id2 == R.id.copy) {
            this.fuguChatActivity.copyText(this.position, this.isReplied);
            Toast.makeText((Context)this.getActivity(), (CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_copy_to_clipboard), (int)0).show();
        } else if (id2 == R.id.download) {
            this.downloadDialog();
        } else if (id2 == R.id.delete) {
            if (this.fuguChatActivity.isNetworkAvailable() || this.MessageStatus != 1 && this.MessageStatus != 2 && this.MessageStatus != 3) {
                new AlertDialog.Builder((Context)this.fuguChatActivity).setMessage((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.hippo_delete_this_message)).setPositiveButton((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.hippo_delete_for_everyone), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        BottomSheetMsgFragment.this.fuguChatActivity.deleteMessage(BottomSheetMsgFragment.this.position, BottomSheetMsgFragment.this.Muid, BottomSheetMsgFragment.this.MessageStatus);
                    }
                }).setNegativeButton((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.hippo_no), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
            } else {
                new AlertDialog.Builder((Context)this.fuguChatActivity).setMessage((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.fugu_not_connected_to_internet)).setPositiveButton((CharSequence)Restring.getString((Context)this.fuguChatActivity, R.string.fugu_ok), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                }).show();
            }
        }
    }

    private void downloadDialog() {
        try {
            if (this.message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                return;
            }
            String string2 = Util.getFileName(this.message.getFileName(), this.message.getMuid());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new AlertDialog.Builder((Context)this.activity).setMessage((CharSequence)"Download this file?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String docType = "image";
                BottomSheetMsgFragment.this.dismiss();
                if (BottomSheetMsgFragment.this.message.getOriginalMessageType() == 11 && FuguAppConstant.FOLDER_TYPE.get(docType = BottomSheetMsgFragment.this.message.getDocumentType()) == null) {
                    docType = "file";
                }
                String fullPath = Util.getOrCreateDirectoryPath((Context)BottomSheetMsgFragment.this.activity, FuguAppConstant.FOLDER_TYPE.get(docType));
                String fileName = BottomSheetMsgFragment.this.message.getFileName();
                String fName = Util.extractFileNameWithoutSuffix(BottomSheetMsgFragment.this.message.getFileName());
                String ext = Util.getExtension(fName);
                DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)BottomSheetMsgFragment.this.message.getFileUrl()));
                request.setDescription((CharSequence)CommonData.getUserDetails().getData().getBusinessName());
                request.setTitle((CharSequence)fName);
                request.allowScanningByMediaScanner();
                request.setNotificationVisibility(1);
                request.setDestinationInExternalFilesDir(HippoConfig.getInstance().getContext(), Environment.DIRECTORY_DOWNLOADS, fileName);
                DownloadManager manager = (DownloadManager)BottomSheetMsgFragment.this.activity.getSystemService("download");
                if (manager != null) {
                    manager.enqueue(request);
                }
            }
        }).show();
    }

    public void onCancel(DialogInterface dialog) {
        if (this.fuguChatActivity != null) {
            this.fuguChatActivity.setOnLongClickValue();
        }
        super.onCancel(dialog);
    }
}

