/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.google.gson.Gson;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.PaymentGatewayAdapter;
import com.hippo.apis.GetPaymentGateway;
import com.hippo.callback.OnPaymentItemClickListener;
import com.hippo.callback.OnPaymentListListener;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.HippoPayment;
import com.hippo.model.payment.AddedPaymentGateway;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.util.ArrayList;

public class BottomSheetPopup
extends BottomSheetDialogFragment
implements OnPaymentItemClickListener {
    private RecyclerView recyclerView;
    private PaymentGatewayAdapter paymentAdapter;
    private String url;
    private String payment;
    private String currency;
    private LinearLayout paymentLayout;
    private TextView paymentMethod;
    private ProgressWheel progress;

    public static BottomSheetPopup newInstance(Bundle args) {
        BottomSheetPopup frag = new BottomSheetPopup();
        frag.setArguments(args);
        return frag;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.url = this.getArguments().getString("url");
            this.payment = this.getArguments().getString("payment");
            this.currency = this.getArguments().getString("currency");
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        new BottomSheetDialog(this.requireContext(), this.getTheme());
        return inflater.inflate(R.layout.hippo_payment_bottom_sheet, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.recyclerView = (RecyclerView)view.findViewById(R.id.recyclerView);
        this.paymentLayout = (LinearLayout)view.findViewById(R.id.paymentLayout);
        this.paymentMethod = (TextView)view.findViewById(R.id.payment_method);
        this.progress = (ProgressWheel)view.findViewById(R.id.progress);
        this.showPayemtMethods(true);
    }

    public int getTheme() {
        return R.style.AppBottomSheetDialogTheme;
    }

    @Override
    public void onItemClickListener(AddedPaymentGateway paymentGateway) {
        try {
            FuguChatActivity activity = (FuguChatActivity)this.getActivity();
            activity.openPaymentDialog(this.url, (HippoPayment)new Gson().fromJson(this.payment, HippoPayment.class), paymentGateway);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dismiss();
    }

    private void showPayemtMethods(boolean hasRetry) {
        ArrayList<AddedPaymentGateway> arrayList = new ArrayList<AddedPaymentGateway>();
        for (AddedPaymentGateway gateway : CommonData.getPaymentList()) {
            if (!gateway.getCurrencyallowed().contains(this.currency.toUpperCase())) continue;
            arrayList.add(gateway);
        }
        if (arrayList.size() == 0) {
            this.recyclerView.setVisibility(8);
            this.paymentLayout.setVisibility(0);
            if (hasRetry) {
                this.progress.setVisibility(0);
                this.paymentMethod.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_fetching_payment_methods));
                this.fetchUpdateGateways();
            } else {
                this.progress.setVisibility(8);
                this.paymentMethod.setText((CharSequence)Restring.getString((Context)this.getActivity(), R.string.hippo_no_payment_methods));
            }
        } else {
            this.paymentAdapter = new PaymentGatewayAdapter(arrayList, this);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.paymentAdapter);
            this.recyclerView.setVisibility(0);
            this.paymentLayout.setVisibility(8);
        }
    }

    private void fetchUpdateGateways() {
        GetPaymentGateway.INSTANCE.getPaymentGatewaysList((Activity)this.getActivity(), new OnPaymentListListener(){

            @Override
            public void onSuccessListener() {
                BottomSheetPopup.this.showPayemtMethods(false);
            }

            @Override
            public void onErrorListener() {
                BottomSheetPopup.this.showPayemtMethods(false);
            }
        });
    }
}

