/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.langs;

import android.text.TextUtils;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.LangRequest;
import com.hippo.model.MultilangualResponse;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Callback;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/hippo/langs/FetchLanguageData;", "", "()V", "fetchLanguage", "", "lang", "", "updateUserLanguage", "hippo_release"})
public final class FetchLanguageData {
    @NotNull
    public static final FetchLanguageData INSTANCE = new FetchLanguageData();

    private FetchLanguageData() {
    }

    public final void fetchLanguage(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        LangRequest params = new LangRequest(CommonData.getUserDetails().getData().getAppSecretKey(), 0, lang);
        if (CommonData.getAttributes() != null && !TextUtils.isEmpty((CharSequence)CommonData.getAttributes().getUserIdentificationSecret())) {
            params.setUserIdentificationSecret(CommonData.getAttributes().getUserIdentificationSecret());
            params.setEn_user_id(CommonData.getUserDetails().getData().getEn_user_id());
        }
        RestClient.getApiInterface().getLanguageData(params).enqueue((Callback)new ResponseResolver<MultilangualResponse>(lang){
            final /* synthetic */ String $lang;
            {
                this.$lang = $lang;
            }

            public void success(@Nullable MultilangualResponse response) {
                MultilangualResponse multilangualResponse = response;
                Restring.saveStrings(multilangualResponse != null ? multilangualResponse.getData() : null);
                CommonData.saveCurrentLang(this.$lang);
                FetchLanguageData.INSTANCE.updateUserLanguage(this.$lang);
            }

            public void failure(@Nullable APIError error) {
            }
        });
    }

    public final void updateUserLanguage(@NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        CommonParams params = new CommonParams.Builder().add("app_secret_key", CommonData.getUserDetails().getData().getAppSecretKey()).add("en_user_id", CommonData.getUserDetails().getData().getEn_user_id()).add("update_lang", lang).build();
        RestClient.getApiInterface().updateUserLanguage((Map<String, Object>)params.getMap()).enqueue((Callback)new ResponseResolver<MultilangualResponse>(){

            public void success(@Nullable MultilangualResponse response) {
            }

            public void failure(@Nullable APIError error) {
            }
        });
    }
}

