/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.optless;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.FragmentActivity;
import com.hippo.optless.ApiManager;
import com.hippo.optless.NotpImpl;
import com.hippo.optless.NotpUserDetailCallback;
import com.hippo.optless.SchemeHostMetaInfo;
import com.hippo.optless.Utility;

public class HippoWAManager {
    private static HippoWAManager sInstance = null;
    private static final String URL_PATTERN = "https://%s.hippochat.io/en/#/getQr";
    public String redirectUrl = "";
    private final NotpImpl mOtpImpl = new NotpImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HippoWAManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<HippoWAManager> clazz = HippoWAManager.class;
        synchronized (HippoWAManager.class) {
            if (sInstance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sInstance;
            }
            sInstance = new HippoWAManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private HippoWAManager() {
    }

    public void init(FragmentActivity activity) {
        this.mOtpImpl.add(activity);
    }

    private void setUrlRedirectURI(FragmentActivity activity) {
        String apiURl;
        if (Utility.isValid(this.redirectUrl, ApiManager.getInstance().baseUrl)) {
            return;
        }
        String packageName = activity.getApplicationContext().getPackageName();
        String domainHost = packageName.replace(".", "-");
        ApiManager.getInstance().baseUrl = apiURl = String.format(URL_PATTERN, domainHost);
        SchemeHostMetaInfo info = Utility.getSchemeHost((Context)activity);
        if (info != null) {
            this.redirectUrl = apiURl + "?redirectUri=" + info.getScheme() + "://" + info.getHost();
        }
        Log.e((String)"redirectUrl", (String)("redirectUrl 1 = " + this.redirectUrl));
    }

    public void launch(Context context, String notpLink, NotpUserDetailCallback callback) {
        this.mOtpImpl.launch(context, notpLink, callback);
    }

    public void setConfiguration(@NonNull Context context, String backgroundColor, String loaderColor, String messageText, String messageColor, String cancelButtonText, String cancelButtonColor) {
        SharedPreferences pref = context.getSharedPreferences("notp_configuration", 0);
        SharedPreferences.Editor editor = pref.edit();
        if (Utility.isNotEmpty(backgroundColor)) {
            editor.putString("screen_bg_color", backgroundColor);
        }
        if (Utility.isNotEmpty(loaderColor)) {
            editor.putString("loader_color", loaderColor);
        }
        if (Utility.isNotEmpty(messageText)) {
            editor.putString("message_text", messageText);
        }
        if (Utility.isNotEmpty(messageColor)) {
            editor.putString("message_color", messageColor);
        }
        if (Utility.isNotEmpty(cancelButtonText)) {
            editor.putString("cancel_btn_text", cancelButtonText);
        }
        if (Utility.isNotEmpty(cancelButtonColor)) {
            editor.putString("cancel_btn_color", cancelButtonColor);
        }
        editor.apply();
    }

    public String[] getConfiguration(Context context) {
        String[] result = new String[6];
        SharedPreferences pref = context.getSharedPreferences("notp_configuration", 0);
        result[0] = pref.getString("screen_bg_color", null);
        result[1] = pref.getString("loader_color", null);
        result[2] = pref.getString("message_text", null);
        result[3] = pref.getString("message_color", null);
        result[4] = pref.getString("cancel_btn_text", null);
        result[5] = pref.getString("cancel_btn_color", null);
        return result;
    }
}

