/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.optless;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.util.Log;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.model.OtpStatusResponse;
import com.hippo.optless.NotpResponse;
import com.hippo.optless.NotpResultContract;
import com.hippo.optless.NotpUserDetailCallback;
import com.hippo.optless.Utility;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import java.util.HashMap;
import retrofit2.Callback;

public class NotpImpl {
    private final HashMap<Activity, ActivityResultLauncher<Uri>> mLauncherMap = new HashMap();
    private NotpUserDetailCallback mAfterLaunchCallback = null;
    private Activity activity;

    NotpImpl() {
    }

    void add(FragmentActivity activity) {
        try {
            this.activity = activity;
            if (!this.mLauncherMap.containsKey(activity)) {
                ActivityResultLauncher launcher = activity.registerForActivityResult((ActivityResultContract)new NotpResultContract(), this::onNotpResult);
                this.mLauncherMap.put((Activity)activity, (ActivityResultLauncher<Uri>)launcher);
                activity.getLifecycle().addObserver((LifecycleObserver)new NotpObserver((Activity)activity));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void contains(FragmentActivity activity) {
    }

    private void onNotpResult(@Nullable NotpResponse userDetail) {
        if (this.mAfterLaunchCallback != null) {
            assert (userDetail != null);
            if (userDetail.getWaId().equals(CommonData.getSessionId())) {
                this.callOTPStatusApi();
            } else {
                this.mAfterLaunchCallback.onNotpFailure(this.activity.getString(R.string.hippo_mismatched_session_id));
                Log.e((String)"WhatsappMismatch", (String)"SessionId Mismatch");
                this.mAfterLaunchCallback = null;
            }
        }
    }

    private void callOTPStatusApi() {
        CommonParams param = new CommonParams.Builder().add("get_status", 1).add("session_id", CommonData.getSessionId()).build();
        RestClient.getApiInterface().updateOtpStatus(param.getMap()).enqueue((Callback)new ResponseResolver<OtpStatusResponse>(){

            @Override
            public void success(OtpStatusResponse otpBaseResponse) {
                if (NotpImpl.this.mAfterLaunchCallback != null && otpBaseResponse.getData() != null) {
                    NotpImpl.this.mAfterLaunchCallback.onNotpUserDetail(otpBaseResponse.getData().getUserData());
                }
                NotpImpl.this.mAfterLaunchCallback = null;
            }

            @Override
            public void failure(APIError error) {
                if (NotpImpl.this.mAfterLaunchCallback != null) {
                    NotpImpl.this.mAfterLaunchCallback.onNotpFailure(error.getMessage());
                }
                Log.e((String)"StatusUpdate", (String)"OTPStatus Update failure");
                NotpImpl.this.mAfterLaunchCallback = null;
            }
        });
    }

    void launch(Context context, String link, NotpUserDetailCallback callback) {
        ActivityResultLauncher<Uri> launcher = this.mLauncherMap.get(context);
        if (launcher != null) {
            String appended = Utility.getUrlWithDeviceParams(context, link);
            Uri uri = Uri.parse((String)appended);
            this.mAfterLaunchCallback = callback;
            launcher.launch((Object)uri);
        }
    }

    class NotpObserver
    implements LifecycleObserver {
        final Activity activity;

        NotpObserver(Activity activity) {
            this.activity = activity;
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public void onDestroyed() {
            NotpImpl.this.mLauncherMap.remove(this.activity);
        }
    }
}

