/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.optless;

import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.hippo.R;
import com.hippo.optless.HippoWAManager;
import com.hippo.optless.Utility;

public class NotpLoginActivity
extends AppCompatActivity {
    private TextView mCancelTv;
    private Bundle mOnCreateBundle = null;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mOnCreateBundle = savedInstanceState;
        this.setContentView(R.layout.hippo_activity_notp_login);
        this.initView();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (intent == null) {
            return;
        }
        this.checkVerifyNotp(intent);
    }

    private void initView() {
        this.mCancelTv = (TextView)this.findViewById(R.id.cancel_tv);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().hide();
        }
        if (!Utility.isAppInstalled(this.getPackageManager(), "com.whatsapp") && !Utility.isAppInstalled(this.getPackageManager(), "com.whatsapp.w4b")) {
            this.returnWithError("whatsapp not installed");
            return;
        }
        this.mCancelTv.setOnClickListener(v -> this.returnWithError("user cancelled"));
        this.setupUiFromConfig();
        Uri actionUri = this.getActionUri();
        if (actionUri != null) {
            if (this.mOnCreateBundle == null) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", actionUri);
                this.startActivity(browserIntent);
            }
        } else {
            this.returnWithError("redirecturi is null");
        }
    }

    private void setupUiFromConfig() {
        Integer color2;
        Integer color3;
        String[] config = HippoWAManager.getInstance().getConfiguration((Context)this);
        if (Utility.isNotEmpty(config[0]) && (color3 = Utility.parseColor(config[0])) != null) {
            ConstraintLayout cl = (ConstraintLayout)this.findViewById(R.id.notp_parent_cl);
            cl.setBackgroundColor(color3.intValue());
        }
        if (Utility.isNotEmpty(config[1]) && (color3 = Utility.parseColor(config[1])) != null) {
            ProgressBar bar = (ProgressBar)this.findViewById(R.id.notp_progress_bar);
            if (Build.VERSION.SDK_INT > 20) {
                bar.setIndeterminateTintList(ColorStateList.valueOf((int)color3));
            }
        }
        TextView textView = (TextView)this.findViewById(R.id.notp_msg_tv);
        if (Utility.isNotEmpty(config[2])) {
            textView.setText((CharSequence)config[2]);
        }
        if (Utility.isNotEmpty(config[3]) && (color2 = Utility.parseColor(config[3])) != null) {
            textView.setTextColor(color2.intValue());
        }
        if (Utility.isNotEmpty(config[4])) {
            this.mCancelTv.setText((CharSequence)config[4]);
        }
        if (Utility.isNotEmpty(config[5]) && (color2 = Utility.parseColor(config[5])) != null) {
            this.mCancelTv.setTextColor(color2.intValue());
        }
    }

    @Nullable
    private Uri getActionUri() {
        Intent intent = this.getIntent();
        Parcelable parcelable = intent.getParcelableExtra("notp_request");
        if (parcelable != null && parcelable instanceof Uri) {
            return (Uri)parcelable;
        }
        return null;
    }

    private void returnWithError(String message) {
        Intent intent = new Intent();
        intent.putExtra("error_message", message);
        this.setResult(0, intent);
        this.finish();
    }

    private void checkVerifyNotp(Intent intent) {
        if (intent == null) {
            this.returnWithError("Intent is null");
            return;
        }
        Uri uri = intent.getData();
        Log.e((String)"uri", (String)("uri = " + uri));
        if (uri == null) {
            this.returnWithError("Uri is null");
            return;
        }
        String waId = uri.getQueryParameter("waId");
        String number = uri.getQueryParameter("phone_number");
        String name = uri.getQueryParameter("name");
        if (waId == null || waId.length() == 0) {
            this.returnWithError("Waid is null");
            return;
        }
        Intent resultIntent = new Intent();
        resultIntent.putExtra("waId", waId);
        resultIntent.putExtra("userNumber", number);
        resultIntent.putExtra("userName", name);
        this.setResult(-1, resultIntent);
        this.finish();
    }
}

