/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.optless;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.Nullable;
import com.hippo.optless.SchemeHostMetaInfo;
import org.json.JSONObject;

public class Utility {
    public static boolean isAppInstalled(PackageManager packageManager, String packageName) {
        try {
            return packageManager.getApplicationInfo((String)packageName, (int)0).enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static String parseUserNumber(JSONObject jsonObject) {
        JSONObject user = jsonObject.optJSONObject("data");
        if (user != null) {
            return user.optString("userMobile");
        }
        return null;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static String getUrlWithDeviceParams(Context context, String url) {
        if (url == null) {
            return url;
        }
        try {
            StringBuffer urlBuffer = new StringBuffer(url);
            String deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            urlBuffer.append("&deviceId=" + deviceId);
            String packageName = context.getPackageName();
            urlBuffer.append("&package=" + packageName);
            String platform = "android";
            urlBuffer.append("&platform=" + platform);
            String osVersion = String.valueOf(Build.VERSION.SDK_INT);
            urlBuffer.append("&osVersion=" + osVersion);
            String manufacturer = Build.MANUFACTURER;
            urlBuffer.append("&manufacturer=" + manufacturer);
            String versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            urlBuffer.append("&appVersionName=" + versionName);
            String versionCode = String.valueOf(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode);
            urlBuffer.append("&appVersionCode=" + versionCode);
            urlBuffer.append("&sdkVersion=" + versionCode);
            return urlBuffer.toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return url;
        }
    }

    @Nullable
    public static Integer parseColor(String color2) {
        try {
            return Color.parseColor((String)color2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isValid(String ... args) {
        for (String str : args) {
            if (str != null && str.length() != 0) continue;
            return false;
        }
        return true;
    }

    public static SchemeHostMetaInfo getSchemeHost(Context context) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            String host = info.metaData.getString("hipponotp.deeplink.host");
            String scheme = info.metaData.getString("hipponotp.deeplink.scheme");
            return new SchemeHostMetaInfo(scheme, host);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

