/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.optless;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.model.OTPBaseResponse;
import com.hippo.optless.ApiManager;
import com.hippo.optless.HippoWAManager;
import com.hippo.optless.NotpResponse;
import com.hippo.optless.NotpUserDetailCallback;
import com.hippo.optless.SchemeHostMetaInfo;
import com.hippo.optless.Utility;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.filepicker.ToastUtil;
import retrofit2.Callback;

public class WhatsappLoginButton
extends ConstraintLayout
implements View.OnClickListener,
LifecycleObserver {
    private static final String WHATSAPP_PACKAGE = "com.whatsapp";
    private static final String WHATSAPP_BUSINESS_PACKAGE = "com.whatsapp.w4b";
    private String notpLink = null;
    private TextView mTextView;
    private int mTextSize = 16;
    private int mCornerRadiusInDp = 12;
    private boolean isApiInProgress = false;
    private NotpUserDetailCallback mUserCallback;
    private NotpResponse userDetail;
    private String appSecretKey;
    private String server;
    private String redirectUri = "";

    public WhatsappLoginButton(Context context) {
        super(context);
        this.init(null);
    }

    public WhatsappLoginButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public WhatsappLoginButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.HippoWhatsappLoginButton);
            String size = a.getString(R.styleable.HippoWhatsappLoginButton_notpTextSize);
            try {
                this.mTextSize = this.getIntFromAttr(size);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String radiusStr = a.getString(R.styleable.HippoWhatsappLoginButton_notpCornerRadius);
            try {
                this.mCornerRadiusInDp = this.getIntFromAttr(radiusStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            a.recycle();
        }
        this.addInternalViews(attrs);
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.hippo_notp_primary));
        DisplayMetrics matrics = this.getContext().getResources().getDisplayMetrics();
        float radius = TypedValue.applyDimension((int)1, (float)this.mCornerRadiusInDp, (DisplayMetrics)matrics);
        drawable2.setCornerRadius(radius);
        this.setBackground((Drawable)drawable2);
        int horPad = this.getResources().getDimensionPixelSize(R.dimen.hippo_button_padding_horizontal);
        int verPad = this.getResources().getDimensionPixelSize(R.dimen.hippo_button_padding_vertical);
        this.setPadding(horPad, verPad, horPad, verPad);
        this.setOnClickListener(this);
    }

    private int getIntFromAttr(String str) throws IllegalArgumentException {
        if (str == null) {
            throw new IllegalArgumentException("no value supplied");
        }
        String trimmed = str.replace("sp", "").replace("dp", "");
        float f = Float.parseFloat(trimmed);
        return (int)f;
    }

    private void addInternalViews(AttributeSet attr2) {
        int horPad;
        this.mTextView = new TextView(this.getContext(), attr2);
        this.mTextView.setId(View.generateViewId());
        String text = this.getResources().getString(R.string.hippo_wa_login);
        this.mTextView.setText((CharSequence)text);
        this.mTextView.setTextColor(-1);
        Typeface typeface = this.mTextView.getTypeface();
        this.mTextView.setTypeface(typeface, 1);
        this.mTextView.setTextSize(2, (float)this.mTextSize);
        this.mTextView.setAllCaps(false);
        ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(-2, -2);
        params.topMargin = horPad = this.getResources().getDimensionPixelSize(R.dimen.hippo_notp_btn_top_margin);
        params.bottomMargin = horPad;
        params.bottomToBottom = this.getId();
        params.topToTop = this.getId();
        params.leftToLeft = this.getId();
        params.rightToRight = this.getId();
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mTextView.setGravity(17);
        this.addView((View)this.mTextView);
        int imageSize = this.getResources().getDimensionPixelSize(R.dimen.hippo_notp_whatsapp_dim);
        ConstraintLayout.LayoutParams imgParam = new ConstraintLayout.LayoutParams(imageSize, imageSize);
        ImageView whatsappIv = new ImageView(this.getContext(), attr2);
        whatsappIv.setId(View.generateViewId());
        imgParam.topToTop = this.mTextView.getId();
        imgParam.bottomToBottom = this.mTextView.getId();
        imgParam.rightToLeft = this.mTextView.getId();
        imgParam.rightMargin = horPad;
        whatsappIv.setLayoutParams((ViewGroup.LayoutParams)imgParam);
        Drawable whatsappBg = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.hippo_notp_whatsapp_icons);
        whatsappIv.setBackground(whatsappBg);
        this.addView((View)whatsappIv);
    }

    public void setText(String text) {
        this.mTextView.setText((CharSequence)text);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        PackageManager pm = this.getContext().getPackageManager();
        String baseUrl = ApiManager.getInstance().baseUrl;
        if (baseUrl == null || baseUrl.length() == 0 && this.notpLink != null) {
            Uri uri = Uri.parse((String)this.notpLink);
            ApiManager.getInstance().baseUrl = baseUrl = uri.getScheme() + "://" + uri.getHost();
            HippoWAManager.getInstance().redirectUrl = this.notpLink;
        }
    }

    private void onNotpResult(@Nullable NotpResponse userDetail) {
        if (this.mUserCallback != null) {
            this.mUserCallback.onNotpUserDetail(userDetail);
        }
        this.userDetail = userDetail;
        if (userDetail != null && userDetail.getUserNumber() != null) {
            this.setText(this.convertMiddleFiveCharsToAsterisks(userDetail.getUserNumber()));
        }
    }

    public void onClick(View v) {
        Context context = this.getContext();
        if (!(context instanceof Activity) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)this.getContext()).getBaseContext();
        }
        if (this.userDetail != null && this.userDetail.getUserNumber() != null && this.mUserCallback != null) {
            this.mUserCallback.onNotpUserDetail(this.userDetail);
            return;
        }
        PackageManager pm = this.getContext().getPackageManager();
        if (!Utility.isAppInstalled(pm, WHATSAPP_PACKAGE) && !Utility.isAppInstalled(pm, WHATSAPP_BUSINESS_PACKAGE)) {
            this.mUserCallback.onNotpFailure(this.getContext().getString(R.string.hippo_whatsapp_not_installed));
            return;
        }
        if (!this.isApiInProgress) {
            this.setText(this.getResources().getString(R.string.hippo_wa_inprogress));
            this.isApiInProgress = true;
            this.openMessage(context, this.mUserCallback);
        }
    }

    public final void setResultCallback(String appSecretKey, String server, NotpUserDetailCallback callback) {
        this.appSecretKey = appSecretKey;
        this.mUserCallback = callback;
        this.server = server;
        this.setServer();
    }

    private void setServer() {
        switch (this.server) {
            case "test": {
                CommonData.setServerUrl("https://api-graviton-multiple.fuguchat.com:3003");
                break;
            }
            case "dev": {
                CommonData.setServerUrl("https://api-graviton-multiple.fuguchat.com:3002");
                break;
            }
            case "dev3004": {
                CommonData.setServerUrl("https://api-graviton-multiple.fuguchat.com:3004");
                break;
            }
            case "dev3003": {
                CommonData.setServerUrl("https://api-graviton-multiple.fuguchat.com:3003");
                break;
            }
            case "beta-live": {
                CommonData.setServerUrl("https://hippog-server.fuguchat.com:3003");
                break;
            }
            default: {
                CommonData.setServerUrl("https://api.hippochat.io");
            }
        }
    }

    private void openMessage(final Context context, final NotpUserDetailCallback callback) {
        if (TextUtils.isEmpty((CharSequence)this.appSecretKey)) {
            ToastUtil.getInstance(context).showToast(R.string.hippo_wa_empty_key);
            return;
        }
        SchemeHostMetaInfo schemeHostMetaInfo = Utility.getSchemeHost(this.getContext());
        if (schemeHostMetaInfo != null) {
            this.redirectUri = schemeHostMetaInfo.getScheme() + "://" + schemeHostMetaInfo.getHost();
        }
        CommonParams commonParams = new CommonParams.Builder().add("app_secret_key", this.appSecretKey).add("get_session", true).add("redirect_uri", this.redirectUri).add("device_type", 1).build();
        RestClient.getApiInterface().getSessionId(commonParams.getMap()).enqueue((Callback)new ResponseResolver<OTPBaseResponse>(){

            @Override
            public void success(OTPBaseResponse otpBaseResponse) {
                if (otpBaseResponse.getData() != null) {
                    WhatsappLoginButton.this.notpLink = otpBaseResponse.getData().getUrl();
                }
                try {
                    if (WhatsappLoginButton.this.notpLink != null) {
                        CommonData.saveSessionId(otpBaseResponse.getData().getSessionId());
                        HippoWAManager.getInstance().launch(context, WhatsappLoginButton.this.notpLink, callback);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    new Handler().postDelayed(() -> {
                        WhatsappLoginButton.this.isApiInProgress = false;
                        WhatsappLoginButton.this.setText(WhatsappLoginButton.this.getResources().getString(R.string.hippo_wa_login));
                    }, 500L);
                }
                catch (Exception e) {
                    WhatsappLoginButton.this.setText(WhatsappLoginButton.this.getResources().getString(R.string.hippo_wa_login));
                    WhatsappLoginButton.this.isApiInProgress = false;
                }
            }

            @Override
            public void failure(APIError error) {
                WhatsappLoginButton.this.setText(WhatsappLoginButton.this.getResources().getString(R.string.hippo_wa_login));
                WhatsappLoginButton.this.isApiInProgress = false;
                WhatsappLoginButton.this.mUserCallback.onNotpFailure(error.getMessage());
            }
        });
    }

    private String appendRedirectUri(Context context, String url) {
        if (url == null) {
            return url;
        }
        try {
            StringBuffer urlBuffer = new StringBuffer(url);
            String deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            urlBuffer.append("&deviceId=" + deviceId);
            String packageName = context.getPackageName();
            urlBuffer.append("&package=" + packageName);
            String platform = "android";
            urlBuffer.append("&platform=" + platform);
            String osVersion = String.valueOf(Build.VERSION.SDK_INT);
            urlBuffer.append("&osVersion=" + osVersion);
            String manufacturer = Build.MANUFACTURER;
            urlBuffer.append("&manufacturer=" + manufacturer);
            String versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
            urlBuffer.append("&appVersionName=" + versionName);
            String versionCode = String.valueOf(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode);
            urlBuffer.append("&appVersionCode=" + versionCode);
            urlBuffer.append("&sdkVersion=" + versionCode);
            return urlBuffer.toString();
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return url;
        }
    }

    private String convertMiddleFiveCharsToAsterisks(String originalString) {
        int length = originalString.length();
        if (length <= 5) {
            return originalString;
        }
        int startIndex = 3;
        int endIndex = length - 2;
        StringBuilder asterisks = new StringBuilder("*");
        for (int i = 0; i < length - 5; ++i) {
            asterisks.append("*");
        }
        StringBuilder convertedString = new StringBuilder(originalString);
        convertedString.replace(startIndex, endIndex, asterisks.toString());
        return convertedString.toString();
    }
}

