/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.placesSearch;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.placesSearch.AutoComplete;
import com.hippo.placesSearch.CommonParamsMpas;
import com.hippo.placesSearch.Location;
import com.hippo.placesSearch.PlaceSearchAdapter;
import com.hippo.placesSearch.Predictions;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.Utils;
import java.util.ArrayList;
import retrofit2.Callback;

public class AddressSearchActivity
extends FuguBaseActivity
implements PlaceSearchAdapter.OnItemListener,
TextWatcher {
    EditText etSearch;
    RelativeLayout rlActionBar;
    private HippoColorConfig hippoColorConfig;
    private Handler searchHandler;
    private Runnable searchRunnable;
    private String lastSearch = "";
    int SEARCH_INTERVAL = 800;
    private PlaceSearchAdapter placeSearchAdapter;
    private ArrayList<Predictions> predictionList;
    RecyclerView rvSearchList;
    LinearLayout llSearch;
    LinearLayout llAddressListParent;
    LinearLayout llBack;
    AppCompatImageButton ivDelete;
    private TextView loadingTV;
    private TextView tvNoSearchResults;
    private RelativeLayout rlNoSearchResult;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_addres_search);
        this.initUI();
    }

    private void initUI() {
        this.hippoColorConfig = CommonData.getColorConfig();
        this.predictionList = new ArrayList();
        this.etSearch = (EditText)this.findViewById(R.id.etSearch);
        this.rvSearchList = (RecyclerView)this.findViewById(R.id.rvSearchList);
        this.rlActionBar = (RelativeLayout)this.findViewById(R.id.rlActionBar);
        this.llSearch = (LinearLayout)this.findViewById(R.id.llSearch);
        this.llBack = (LinearLayout)this.findViewById(R.id.llBack);
        this.ivDelete = (AppCompatImageButton)this.findViewById(R.id.ivDelete);
        this.loadingTV = (TextView)this.findViewById(R.id.loadingTV);
        this.tvNoSearchResults = (TextView)this.findViewById(R.id.tvNoSearchResults);
        this.tvNoSearchResults.setText((CharSequence)Restring.getString((Context)this, R.string.fugu_no_data_found));
        this.rlNoSearchResult = (RelativeLayout)this.findViewById(R.id.rlNoSearchResults);
        this.llAddressListParent = (LinearLayout)this.findViewById(R.id.llAddressListParent);
        this.etSearch.setTextColor(this.hippoColorConfig.getHippoActionBarText());
        this.etSearch.setHintTextColor(this.hippoColorConfig.getHippoActionBarText());
        String hint = Restring.getString((Context)this, R.string.hippo_search);
        hint = hint.replace("&#8230", "...");
        this.etSearch.setHint((CharSequence)hint);
        this.loadingTV.setText((CharSequence)Restring.getString((Context)this, R.string.fugu_loading));
        this.llBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AddressSearchActivity.this.onBackPressed();
            }
        });
        this.ivDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AddressSearchActivity.this.onDeleteSearch();
            }
        });
        this.rlActionBar.setBackgroundColor(this.hippoColorConfig.getHippoActionBarBg());
        this.etSearch.addTextChangedListener((TextWatcher)this);
        this.etSearch.requestFocus();
        this.placeSearchAdapter = new PlaceSearchAdapter(this, this.predictionList);
        this.rvSearchList.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.rvSearchList.setAdapter((RecyclerView.Adapter)this.placeSearchAdapter);
        this.searchRunnable = new Runnable(){

            @Override
            public void run() {
                AddressSearchActivity.this.lastSearch = AddressSearchActivity.this.etSearch.getText().toString().trim();
                AddressSearchActivity.this.onSearchUpdateFlightMAp(AddressSearchActivity.this.lastSearch);
            }
        };
        this.searchHandler = new Handler();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                AddressSearchActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Utils.showSoftKeyboard((Activity)AddressSearchActivity.this);
                    }
                });
            }
        }, 250L);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable s) {
        this.searchHandler.removeCallbacks(this.searchRunnable);
        if (s.toString().length() > 2) {
            if (!this.lastSearch.equalsIgnoreCase(this.etSearch.getText().toString().trim()) && this.searchHandler != null && this.searchRunnable != null) {
                this.searchHandler.postDelayed(this.searchRunnable, (long)this.SEARCH_INTERVAL);
            }
        } else if (s.toString().isEmpty()) {
            this.onListRefreshed(null);
            this.rvSearchList.setVisibility(8);
            this.llAddressListParent.setVisibility(8);
            this.rlNoSearchResult.setVisibility(0);
            this.tvNoSearchResults.setVisibility(8);
        }
    }

    private void onSearchUpdateFlightMAp(String searchKeyword) {
        CommonParamsMpas.Builder commonParams = new CommonParamsMpas.Builder().add("text", searchKeyword).add("currentlatitude", 0).add("currentlongitude", 0).add("offering", 2).add("skip_cache", 0).add("fm_token", "e07a4b30-524a-11ea-ad3a-9bfad3330c22");
        this.llSearch.setVisibility(0);
        this.rvSearchList.setVisibility(0);
        this.llAddressListParent.setVisibility(0);
        this.rlNoSearchResult.setVisibility(8);
        RestClient.getJungleMapsApi().getAddressFromFlightMapSearchApi(commonParams.build().getMap()).enqueue((Callback)new ResponseResolver<AutoComplete>((Activity)this, Boolean.valueOf(false), Boolean.valueOf(true)){

            @Override
            public void success(AutoComplete autoComplete) {
                AddressSearchActivity.this.llSearch.setVisibility(8);
                try {
                    ArrayList<Predictions> predictions = autoComplete.getPredictions();
                    if (Utils.hasData(predictions)) {
                        AddressSearchActivity.this.onListRefreshed(predictions);
                    } else {
                        AddressSearchActivity.this.rvSearchList.setVisibility(8);
                        AddressSearchActivity.this.llAddressListParent.setVisibility(8);
                        AddressSearchActivity.this.rlNoSearchResult.setVisibility(0);
                        AddressSearchActivity.this.tvNoSearchResults.setVisibility(0);
                        AddressSearchActivity.this.onListRefreshed(null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void failure(APIError error) {
                AddressSearchActivity.this.llSearch.setVisibility(8);
                AddressSearchActivity.this.rvSearchList.setVisibility(8);
                AddressSearchActivity.this.onListRefreshed(null);
            }
        });
    }

    private void onListRefreshed(ArrayList<Predictions> predictionList) {
        this.predictionList = predictionList;
        this.ivDelete.setVisibility(predictionList == null || predictionList.isEmpty() ? 4 : 0);
        if (this.placeSearchAdapter == null) {
            this.placeSearchAdapter = new PlaceSearchAdapter(this, predictionList);
            this.rvSearchList.setAdapter((RecyclerView.Adapter)this.placeSearchAdapter);
        } else {
            this.placeSearchAdapter.refreshAdapterDataSet(predictionList);
        }
    }

    private void onDeleteSearch() {
        this.etSearch.setText((CharSequence)"");
        this.rvSearchList.setVisibility(8);
        this.llAddressListParent.setVisibility(8);
        this.rlNoSearchResult.setVisibility(0);
        this.tvNoSearchResults.setVisibility(8);
        this.onListRefreshed(null);
    }

    @Override
    public void onAddressSelected(Predictions predictions) {
        this.llSearch.setVisibility(8);
        this.hideKeyboard((Activity)this);
        String address = predictions.getAddress();
        Bundle bundle = new Bundle();
        bundle.putParcelable(Location.class.getName(), (Parcelable)predictions.getLocation());
        bundle.putString("address", address);
        Intent intent = new Intent();
        intent.putExtras(bundle);
        this.setResult(-1, intent);
        this.finish();
    }
}

