/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.placesSearch;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.placesSearch.Predictions;
import java.util.ArrayList;

public class PlaceSearchAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private ArrayList<Predictions> predictionList;
    private OnItemListener onItemListener;
    private Context mContext;

    public PlaceSearchAdapter(OnItemListener onItemListener, ArrayList<Predictions> predictionList) {
        this.predictionList = predictionList == null ? new ArrayList() : predictionList;
        this.onItemListener = onItemListener;
    }

    public void refreshAdapterDataSet(ArrayList<Predictions> predictionList) {
        if (predictionList == null) {
            this.predictionList = new ArrayList();
        } else {
            this.predictionList.clear();
            this.predictionList.addAll(predictionList);
        }
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        this.mContext = parent.getContext();
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_place_search, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        position = holder.getAdapterPosition();
        final Predictions prediction = this.predictionList.get(position);
        holder.tvAddress.setText((CharSequence)prediction.getName());
        holder.tvAddressDescription.setText((CharSequence)prediction.getAddress());
        holder.llPlaceParent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlaceSearchAdapter.this.refreshAdapterDataSet(null);
                PlaceSearchAdapter.this.onItemListener.onAddressSelected(prediction);
            }
        });
    }

    public int getItemCount() {
        return this.predictionList.size();
    }

    public static interface OnItemListener {
        public void onAddressSelected(Predictions var1);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private AppCompatTextView tvAddress;
        private AppCompatTextView tvAddressDescription;
        private LinearLayout llPlaceParent;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvAddress = (AppCompatTextView)itemView.findViewById(R.id.tvAddress);
            this.tvAddressDescription = (AppCompatTextView)itemView.findViewById(R.id.tvAddressDescription);
            this.llPlaceParent = (LinearLayout)itemView.findViewById(R.id.llPlaceParent);
        }
    }
}

