/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.placesSearch;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.maps.model.LatLng;
import com.hippo.placesSearch.Location;

public class Predictions
implements Parcelable {
    private String place_id;
    private String name = "";
    private String address;
    private double lat;
    private double lng;
    public static final Parcelable.Creator<Predictions> CREATOR = new Parcelable.Creator<Predictions>(){

        public Predictions createFromParcel(Parcel in) {
            return new Predictions(in);
        }

        public Predictions[] newArray(int size) {
            return new Predictions[size];
        }
    };

    protected Predictions(Parcel in) {
        this.place_id = in.readString();
        this.name = in.readString();
        this.address = in.readString();
        this.lat = in.readDouble();
        this.lng = in.readDouble();
    }

    public String getPlaceID() {
        return this.place_id;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public double getLat() {
        return this.lat;
    }

    public Location getLocation() {
        return new Location(String.valueOf(this.lat), String.valueOf(this.lng));
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void setLatLng(LatLng latLng) {
        this.lat = latLng.latitude;
        this.lng = latLng.longitude;
    }

    public void setLng(double lng) {
        this.lng = lng;
    }

    public double getLng() {
        return this.lng;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.place_id);
        parcel.writeString(this.name);
        parcel.writeString(this.address);
        parcel.writeDouble(this.lat);
        parcel.writeDouble(this.lng);
    }
}

