/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.record;

import android.app.Activity;
import android.content.Context;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.hippo.R;
import com.hippo.langs.Restring;
import com.hippo.record.RecordingListener;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u0016H\u0002J\u001e\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+H\u0016J\u001e\u0010,\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+H\u0016J-\u0010-\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u000e\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0/2\u0006\u00100\u001a\u000201H\u0016\u00a2\u0006\u0002\u00102J\u0006\u00103\u001a\u00020%J\u0006\u00104\u001a\u00020%R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lcom/hippo/record/RecordingUtil;", "Lcom/hippo/utils/easypermissions/EasyPermissions$PermissionCallbacks;", "activity", "Landroid/app/Activity;", "recordingListener", "Lcom/hippo/record/RecordingListener;", "(Landroid/app/Activity;Lcom/hippo/record/RecordingListener;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getActivity", "()Landroid/app/Activity;", "setActivity", "(Landroid/app/Activity;)V", "audiofile", "Ljava/io/File;", "getAudiofile", "()Ljava/io/File;", "setAudiofile", "(Ljava/io/File;)V", "isRecordStarted", "", "()Z", "setRecordStarted", "(Z)V", "recorder", "Landroid/media/MediaRecorder;", "getRecorder", "()Landroid/media/MediaRecorder;", "setRecorder", "(Landroid/media/MediaRecorder;)V", "getRecordingListener", "()Lcom/hippo/record/RecordingListener;", "setRecordingListener", "(Lcom/hippo/record/RecordingListener;)V", "cancelRecording", "", "hasPermission", "onPermissionsDenied", "requestCode", "", "perms", "", "onPermissionsGranted", "onRequestPermissionsResult", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "startRecording", "stopRecording", "hippo_release"})
public final class RecordingUtil
implements EasyPermissions.PermissionCallbacks {
    public MediaRecorder recorder;
    public File audiofile;
    @NotNull
    private Activity activity;
    @NotNull
    private final String TAG;
    @NotNull
    private RecordingListener recordingListener;
    private boolean isRecordStarted;

    public RecordingUtil(@NotNull Activity activity, @NotNull RecordingListener recordingListener) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)recordingListener, (String)"recordingListener");
        this.activity = activity;
        this.TAG = "MediaRecording";
        this.recordingListener = recordingListener;
    }

    @NotNull
    public final MediaRecorder getRecorder() {
        MediaRecorder mediaRecorder = this.recorder;
        if (mediaRecorder != null) {
            return mediaRecorder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"recorder");
        return null;
    }

    public final void setRecorder(@NotNull MediaRecorder mediaRecorder) {
        Intrinsics.checkNotNullParameter((Object)mediaRecorder, (String)"<set-?>");
        this.recorder = mediaRecorder;
    }

    @NotNull
    public final File getAudiofile() {
        File file = this.audiofile;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"audiofile");
        return null;
    }

    public final void setAudiofile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.audiofile = file;
    }

    @NotNull
    public final Activity getActivity() {
        return this.activity;
    }

    public final void setActivity(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"<set-?>");
        this.activity = activity;
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final RecordingListener getRecordingListener() {
        return this.recordingListener;
    }

    public final void setRecordingListener(@NotNull RecordingListener recordingListener) {
        Intrinsics.checkNotNullParameter((Object)recordingListener, (String)"<set-?>");
        this.recordingListener = recordingListener;
    }

    public final boolean isRecordStarted() {
        return this.isRecordStarted;
    }

    public final void setRecordStarted(boolean bl) {
        this.isRecordStarted = bl;
    }

    public final void startRecording() throws IOException {
        if (this.hasPermission()) {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
            try {
                this.setAudiofile(new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MUSIC).getAbsolutePath() + "/AUD_" + timeStamp + ".aac"));
            }
            catch (IOException e) {
                Log.e((String)this.TAG, (String)"external storage access error");
                return;
            }
            this.isRecordStarted = true;
            this.setRecorder(new MediaRecorder());
            this.getRecorder().setAudioSource(1);
            this.getRecorder().setOutputFormat(6);
            this.getRecorder().setAudioEncoder(3);
            this.getRecorder().setOutputFile(this.getAudiofile().getAbsolutePath());
            this.getRecorder().prepare();
            this.getRecorder().start();
        }
    }

    public final void stopRecording() {
        if (this.isRecordStarted) {
            this.getRecorder().stop();
            this.getRecorder().release();
            if (this.getAudiofile() != null) {
                String string = this.getAudiofile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"audiofile.absolutePath");
                this.recordingListener.onRecordedFile(string, this.getAudiofile().length());
            } else {
                this.recordingListener.onRecordFileError();
            }
            this.isRecordStarted = false;
        }
    }

    public final void cancelRecording() {
        if (this.isRecordStarted) {
            try {
                this.getRecorder().stop();
                this.getRecorder().release();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
        Object[] objectArray = new Object[]{this};
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, objectArray);
    }

    @Override
    public void onPermissionsGranted(int requestCode, @NotNull List<String> perms) {
        Intrinsics.checkNotNullParameter(perms, (String)"perms");
        this.startRecording();
    }

    @Override
    public void onPermissionsDenied(int requestCode, @NotNull List<String> perms) {
        Intrinsics.checkNotNullParameter(perms, (String)"perms");
        if (EasyPermissions.somePermissionPermanentlyDenied(this.activity, perms)) {
            new AppSettingsDialog.Builder(this.activity).setIsManageStoragePermission(0).build().show();
        }
    }

    private final boolean hasPermission() {
        boolean isGranted;
        boolean bl;
        String[] stringArray;
        if (Build.VERSION.SDK_INT >= 33) {
            stringArray = new String[]{"android.permission.RECORD_AUDIO"};
            bl = EasyPermissions.hasPermissions((Context)this.activity, stringArray);
        } else {
            stringArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"};
            bl = isGranted = EasyPermissions.hasPermissions((Context)this.activity, stringArray);
        }
        if (isGranted) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 33) {
            stringArray = new String[]{"android.permission.RECORD_AUDIO"};
            EasyPermissions.requestPermissions(this.activity, Restring.getString((Context)this.activity, R.string.vw_rationale_storage), 123, stringArray);
        } else {
            stringArray = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO"};
            EasyPermissions.requestPermissions(this.activity, Restring.getString((Context)this.activity, R.string.vw_rationale_storage), 123, stringArray);
        }
        return false;
    }
}

