/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.retrofit;

import android.text.TextUtils;
import com.hippo.HippoConfig;
import com.hippo.database.CommonData;
import com.hippo.retrofit.ApiInterface;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RestClient {
    public static Retrofit retrofit = null;
    public static Retrofit flightMapApi = null;

    public static ApiInterface getApiInterface() {
        if (retrofit == null) {
            String baseUrl = CommonData.getServerUrl();
            if (TextUtils.isEmpty((CharSequence)baseUrl.trim())) {
                baseUrl = "https://api.hippochat.io";
            }
            retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(RestClient.httpClient().build()).build();
        }
        return (ApiInterface)retrofit.create(ApiInterface.class);
    }

    public static ApiInterface getJungleMapsApi() {
        block3: {
            if (flightMapApi == null) {
                try {
                    flightMapApi = new Retrofit.Builder().baseUrl("https://nominatim-api-live.jungleworks.com").addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(RestClient.httpClient().build()).build();
                }
                catch (Exception e) {
                    if (!HippoConfig.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
        return (ApiInterface)flightMapApi.create(ApiInterface.class);
    }

    public static Retrofit getRetrofitBuilder() {
        if (retrofit == null) {
            String baseUrl = CommonData.getServerUrl();
            if (TextUtils.isEmpty((CharSequence)baseUrl.trim())) {
                baseUrl = "https://api.hippochat.io";
            }
            retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(RestClient.httpClient().build()).build();
        }
        return retrofit;
    }

    private static OkHttpClient.Builder httpClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        if (HippoConfig.DEBUG) {
            logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        }
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder().readTimeout(120L, TimeUnit.SECONDS).connectTimeout(120L, TimeUnit.SECONDS);
        httpClient.addInterceptor((Interceptor)logging);
        return httpClient;
    }

    public void clearInstance() {
        retrofit = null;
    }
}

