/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.service;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import androidx.core.app.NotificationCompat;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.model.AdvanceSpecInfoModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class AdvanceSpecService
extends Service {
    public static final String CHANNEL_ONE_ID = "com.hippo.ONE";
    private boolean isCtrSessionTime;
    private boolean isDelivered;
    private boolean isSeenStatus;
    private boolean isPromotionDialog;
    private String messageString = "";

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void onCreate() {
        super.onCreate();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        try {
            this.startForeground(1001, this.generateNotification((Context)this, 10001, false));
            if (intent.getStringExtra("messageJson") != null) {
                this.messageString = intent.getStringExtra("messageJson");
            }
            this.isCtrSessionTime = intent.getBooleanExtra("isCtrSessionTime", false);
            this.isDelivered = intent.getBooleanExtra("isDelivered", false);
            this.isSeenStatus = intent.getBooleanExtra("isSeenStatus", false);
            this.isPromotionDialog = intent.getBooleanExtra("isPromotionDialog", false);
            if (this.messageString != null && !this.messageString.isEmpty()) {
                try {
                    JSONObject jsonObject = new JSONObject(this.messageString);
                    this.advanceSpecApi(jsonObject);
                }
                catch (JSONException e) {
                    this.stopSelf();
                }
            } else {
                this.stopSelf();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    private void advanceSpecApi(JSONObject jsonObject) {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("channel_id", jsonObject.get("channel_id"));
            params.put("en_user_id", CommonData.getUserDetails().getData().getEn_user_id());
            params.put("app_secret_key", HippoConfig.getInstance().getAppKey());
            if (this.isCtrSessionTime) {
                Long time = CommonData.getAdvanceSpecData().getStart_time_milis();
                time = System.currentTimeMillis() - time;
                params.put("ctr_session_time", TimeUnit.MILLISECONDS.toSeconds(time));
                CommonData.saveAdvanceSpecData(new AdvanceSpecInfoModel(0L, ""));
            }
            if (this.isDelivered) {
                params.put("is_delivered", 1);
            }
            if (this.isSeenStatus) {
                params.put("app_opened_through_push", 1);
            }
            if (this.isPromotionDialog) {
                params.put("is_clicked", 1);
                params.put("open_links", jsonObject.getJSONArray("open_links"));
            }
            RestClient.getApiInterface().advanceSpecApi(params).enqueue((Callback)new ResponseResolver<CommonResponse>(){

                @Override
                public void success(CommonResponse commonResponse) {
                    AdvanceSpecService.this.stopSelf();
                }

                @Override
                public void failure(APIError error) {
                    AdvanceSpecService.this.stopSelf();
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.stopSelf();
        }
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
    }

    public void onDestroy() {
        this.stopSelf();
    }

    public Notification generateNotification(Context context, int notificationId, boolean notify) {
        try {
            long when = System.currentTimeMillis();
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID);
            builder.setAutoCancel(false);
            builder.setContentTitle((CharSequence)context.getResources().getString(R.string.app_name));
            builder.setChannelId(CHANNEL_ONE_ID);
            builder.setWhen(when);
            Notification notification = builder.build();
            if (notify) {
                notificationManager.notify(notificationId, notification);
            }
            return notification;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

