/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.service;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import com.hippo.database.CommonData;
import com.hippo.service.AdvanceSpecService;

public class AppLifecycleListener
implements LifecycleEventObserver {
    private static final String TAG = "LIFECYCLE";
    Context context;
    public static boolean isAppKilled = true;

    public AppLifecycleListener(Context applicationContext) {
        this.context = applicationContext;
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        switch (event) {
            case ON_CREATE: {
                break;
            }
            case ON_START: {
                break;
            }
            case ON_RESUME: {
                isAppKilled = false;
                Log.i((String)TAG, (String)"OnResume");
                Log.i((String)"Killed app", (String)String.valueOf(isAppKilled));
                break;
            }
            case ON_PAUSE: {
                Log.i((String)TAG, (String)"OnPause");
                break;
            }
            case ON_STOP: {
                isAppKilled = true;
                Log.i((String)TAG, (String)"OnStop");
                Log.i((String)"Killed app", (String)String.valueOf(isAppKilled));
                try {
                    if (CommonData.getAdvanceSpecData() == null || CommonData.getAdvanceSpecData().getStart_time_milis() <= 0L) break;
                    Intent intent = new Intent(this.context, AdvanceSpecService.class);
                    intent.putExtra("messageJson", CommonData.getAdvanceSpecData().getMessage());
                    intent.putExtra("isCtrSessionTime", true);
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.context.startForegroundService(intent);
                        break;
                    }
                    this.context.startService(intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case ON_DESTROY: {
                Log.i((String)TAG, (String)"OnDestroy");
                break;
            }
            case ON_ANY: {
                Log.i((String)TAG, (String)"OnDestroy");
            }
        }
    }
}

