/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.service;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.hippo.HippoConfig;
import com.hippo.HippoNotificationConfig;
import com.hippo.R;
import com.hippo.activity.CampaignActivity;
import com.hippo.activity.ChannelActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.FuguConversation;

public class FuguPushIntentService
extends IntentService {
    private static final String TAG = "FuguPushIntentService";

    public FuguPushIntentService() {
        super(TAG);
    }

    protected void onHandleIntent(Intent intent) {
        boolean isPromotional = intent.getBooleanExtra("is_announcement_push", false);
        if (isPromotional) {
            Intent broadcastIntent = new Intent((Context)this, CampaignActivity.class);
            broadcastIntent.putExtra("is_promotional_push", true);
            broadcastIntent.putExtra("is_announcement_push", true);
            broadcastIntent.putExtra("isFromPush", true);
            broadcastIntent.putExtra("dataMessage", (String)intent.getBundleExtra("data").get("message"));
            broadcastIntent.putExtra("message", (String)intent.getBundleExtra("data").get("message"));
            broadcastIntent.setFlags(0x14000000);
            this.startActivity(broadcastIntent);
        } else {
            long channelId = intent.getLongExtra("channelId", -1L);
            long labelId = intent.getLongExtra("labelId", -1L);
            FuguConversation conversation = new FuguConversation();
            conversation.setChannelId(channelId);
            conversation.setEnUserId(intent.getStringExtra("en_user_id"));
            conversation.setUserId(intent.getLongExtra("userId", -1L));
            conversation.setLabel(intent.getStringExtra("label"));
            if (intent.hasExtra("channel_type")) {
                conversation.setChannelType(intent.getIntExtra("channel_type", 0));
            }
            if (intent.hasExtra("channel_Id_push")) {
                conversation.setChannelIdPush(intent.getLongExtra("channel_Id_push", 0L));
            }
            conversation.setLabelId(labelId);
            conversation.setDisableReply(intent.getIntExtra("disable_reply", 0));
            if (channelId < 0L && labelId > 0L) {
                conversation.setOpenChat(true);
            }
            if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isDataCleared()) {
                Intent notificationIntent = new Intent((Context)this, FuguChatActivity.class);
                if (conversation.getChannelType() == 7 || conversation.getChannelType() == 6) {
                    notificationIntent.putExtra("isfromPush", true);
                }
                notificationIntent.putExtra("channel_Id_push", conversation.getChannelIdPush());
                notificationIntent.putExtra("message", new Gson().toJson((Object)conversation, FuguConversation.class).toString());
                if (channelId < 0L && labelId < 0L) {
                    notificationIntent = new Intent((Context)this, ChannelActivity.class);
                    String title = CommonData.getChatTitleContext();
                    if (TextUtils.isEmpty((CharSequence)title)) {
                        title = Restring.getString((Context)this, R.string.fugu_support);
                    }
                    notificationIntent.putExtra("title", title);
                    notificationIntent.setFlags(0x14000000);
                    this.startActivity(notificationIntent);
                } else if (HippoNotificationConfig.pushChannelId.compareTo(-1L) == 0) {
                    notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                    notificationIntent.setFlags(0x14000000);
                    this.startActivity(notificationIntent);
                } else {
                    Intent mIntent = new Intent("notification_tapped");
                    mIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                    LocalBroadcastManager.getInstance((Context)this).sendBroadcast(mIntent);
                }
            } else {
                PackageManager pm = this.getPackageManager();
                Intent notificationIntent = pm.getLaunchIntentForPackage(this.getPackageName());
                conversation.setStartChannelsActivity(true);
                notificationIntent.putExtra("startChatActivity", true);
                notificationIntent.putExtra("conversation", new Gson().toJson((Object)conversation, FuguConversation.class));
                this.startActivity(notificationIntent);
            }
        }
    }
}

