/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.service;

import android.content.Context;
import android.util.Log;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.hippo.HippoConfig;
import com.hippo.database.CommonData;
import com.hippo.model.AdvanceSpecInfoModel;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.service.AppLifecycleListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/hippo/service/NotificationWorkManager;", "Landroidx/work/Worker;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "isCtrSessionTime", "", "isDelivered", "isPromotionDialog", "isSeenStatus", "messageString", "", "advanceSpecApi", "", "jsonObject", "Lorg/json/JSONObject;", "doWork", "Landroidx/work/ListenableWorker$Result;", "hippo_release"})
public final class NotificationWorkManager
extends Worker {
    private boolean isCtrSessionTime;
    private boolean isDelivered;
    private boolean isSeenStatus;
    private boolean isPromotionDialog;
    @NotNull
    private String messageString;

    public NotificationWorkManager(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
        this.messageString = "";
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        Log.i((String)"NWM", (String)String.valueOf(this.getInputData().getBoolean("isDelivered", AppLifecycleListener.isAppKilled)));
        try {
            if (this.getInputData().getString("messageJson") != null) {
                String string2 = this.getInputData().getString("messageJson");
                Intrinsics.checkNotNull((Object)string2);
                this.messageString = string2;
            }
            this.isCtrSessionTime = this.getInputData().getBoolean("isCtrSessionTime", false);
            this.isDelivered = this.getInputData().getBoolean("isDelivered", false);
            this.isSeenStatus = this.getInputData().getBoolean("isSeenStatus", false);
            this.isPromotionDialog = this.getInputData().getBoolean("isPromotionDialog", false);
            if (!(((CharSequence)this.messageString).length() == 0)) {
                try {
                    JSONObject jsonObject = new JSONObject(this.messageString);
                    this.advanceSpecApi(jsonObject);
                }
                catch (JSONException jSONException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    private final void advanceSpecApi(JSONObject jsonObject) {
        try {
            HashMap params = new HashMap();
            Map map = params;
            String string2 = "channel_id";
            Object object = jsonObject.get("channel_id");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonObject[\"channel_id\"]");
            Object object2 = object;
            map.put(string2, object2);
            map = params;
            string2 = "en_user_id";
            String string3 = CommonData.getUserDetails().getData().getEn_user_id();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserDetails().data.en_user_id");
            object2 = string3;
            map.put(string2, object2);
            map = params;
            string2 = "app_secret_key";
            String string4 = HippoConfig.getInstance().getAppKey();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getInstance().getAppKey()");
            object2 = string4;
            map.put(string2, object2);
            if (this.isCtrSessionTime) {
                long time = CommonData.getAdvanceSpecData().getStart_time_milis();
                time = System.currentTimeMillis() - time;
                ((Map)params).put("ctr_session_time", TimeUnit.MILLISECONDS.toSeconds(time));
                CommonData.saveAdvanceSpecData(new AdvanceSpecInfoModel(0L, ""));
            }
            if (this.isDelivered) {
                ((Map)params).put("is_delivered", 1);
            }
            if (this.isSeenStatus) {
                ((Map)params).put("app_opened_through_push", 1);
            }
            if (this.isPromotionDialog) {
                ((Map)params).put("is_clicked", 1);
                Map map2 = params;
                string2 = "open_links";
                JSONArray jSONArray = jsonObject.getJSONArray("open_links");
                Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"jsonObject.getJSONArray(\"open_links\")");
                object2 = jSONArray;
                map2.put(string2, object2);
            }
            RestClient.getApiInterface().advanceSpecApi(params).enqueue((Callback)new ResponseResolver<CommonResponse>(){

                public void failure(@NotNull APIError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                }

                public void success(@Nullable CommonResponse t) {
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

