/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.logicImplView;

import android.app.Activity;
import com.hippo.HippoConfig;
import com.hippo.support.Utils.CommonSupportParam;
import com.hippo.support.callback.HippoSupportInteractor;
import com.hippo.support.callback.HippoSupportView;
import com.hippo.support.callback.SupportPresenter;
import com.hippo.support.model.SupportDataList;
import com.hippo.support.model.callbackModel.OpenChatParams;
import com.hippo.support.model.callbackModel.SendQueryChat;

public class HippoSupportViewImpl
implements SupportPresenter,
HippoSupportInteractor.OnFinishedListener {
    private static final String TAG = HippoSupportViewImpl.class.getSimpleName();
    private HippoSupportView supportView;
    private Activity activity;
    private HippoSupportInteractor interactor;

    public HippoSupportViewImpl(Activity activity, HippoSupportView supportView, HippoSupportInteractor interactor) {
        this.activity = activity;
        this.supportView = supportView;
        this.interactor = interactor;
    }

    @Override
    public void onSuccess(SupportDataList supportResponse) {
        if (this.supportView != null) {
            this.supportView.hideProgress();
        }
        this.supportView.setData(supportResponse);
    }

    @Override
    public void onSuccess() {
    }

    @Override
    public void onFailure() {
        if (this.supportView != null) {
            this.supportView.hideProgress();
            this.supportView.showError();
        }
    }

    @Override
    public void fetchData(String defaultCategory, int serverDBVersion) {
        if (this.supportView != null) {
            this.supportView.showProgress();
        }
        this.interactor.getSupportData(this.activity, serverDBVersion, defaultCategory, this);
    }

    @Override
    public void openChat(SendQueryChat queryChat) {
        block4: {
            try {
                OpenChatParams chatParams = new CommonSupportParam().getOpenChatParam(queryChat.getCategory().getCategoryName(), queryChat.getTransactionId(), queryChat.getUserUniqueId(), queryChat.getSupportId(), queryChat.getPathList(), queryChat.getSubHeader());
                if (this.supportView != null) {
                    this.supportView.openChatSupport(chatParams);
                }
            }
            catch (Exception e) {
                if (HippoConfig.DEBUG) {
                    e.printStackTrace();
                }
                if (this.supportView == null) break block4;
                this.supportView.showError();
            }
        }
    }

    @Override
    public void onDestroy() {
        this.supportView = null;
    }
}

