/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.tickets;

import android.app.Activity;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.adapter.QRCallback;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.Message;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.tickets.AttachmentSelectedTicketListener;
import com.hippo.tickets.AttachmentsAdapter;
import com.hippo.tickets.CreateCustomerResponce.CreateCustomerResponse;
import com.hippo.tickets.Result;
import com.hippo.tickets.TicketPriorityOptionsData;
import com.hippo.utils.InstantAutoComplete;
import com.hippo.utils.Utils;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CountryPicker;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import com.hippo.utils.fileUpload.FileuploadModel;
import java.util.ArrayList;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class DataFormTicketAdapter
extends RecyclerView.Adapter<QRViewHolder>
implements AttachmentSelectedTicketListener {
    private static final String TAG = DataFormTicketAdapter.class.getSimpleName();
    private final Activity activity;
    private Context context;
    private ArrayList<String> arrayList;
    private QRCallback qrCallback;
    private ArrayList<Question> question;
    private Message currentFormMsg;
    private FragmentManager fragmentManager;
    ArrayList<String> searchItem;
    private ArrayAdapter<String> searchAdapter;

    public DataFormTicketAdapter(Message currentFormMsg, QRCallback qrCallback, FragmentManager fragmentManager, Activity activity) {
        block9: {
            this.question = new ArrayList();
            this.searchItem = new ArrayList();
            this.currentFormMsg = currentFormMsg;
            this.qrCallback = qrCallback;
            this.fragmentManager = fragmentManager;
            this.activity = activity;
            this.question.clear();
            try {
                if (currentFormMsg.getContentValue() == null || currentFormMsg.getContentValue().size() <= 0 || currentFormMsg.getContentValue().get(0).getQuestions() == null) break block9;
                for (int i = 0; i < currentFormMsg.getContentValue().get(0).getQuestions().size(); ++i) {
                    if (currentFormMsg.getValues() == null || currentFormMsg.getValues().size() <= i || !this.isValidEmail(currentFormMsg.getValues().get(i), currentFormMsg.getContentValue().get(0).getParams().get(i))) {
                        this.question.add(new Question(currentFormMsg.getContentValue().get(0).getQuestions().get(i), null, currentFormMsg.getContentValue().get(0).getData_type().get(i), currentFormMsg.getContentValue().get(0).getParams().get(i), currentFormMsg.getContentValue().get(0).getTextValue(), currentFormMsg.getContentValue().get(0).getCountryCode()));
                        break;
                    }
                    this.question.add(new Question(currentFormMsg.getContentValue().get(0).getQuestions().get(i), currentFormMsg.getValues().get(i), currentFormMsg.getContentValue().get(0).getData_type().get(i), currentFormMsg.getContentValue().get(0).getParams().get(i), null, null));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String name = "";
        String email = "";
        for (int i = 0; i < this.question.size(); ++i) {
            if (this.question.get((int)i).params.equalsIgnoreCase("name")) {
                if (this.question.get(i).getAnswer() == null) continue;
                name = this.question.get(i).getAnswer();
                continue;
            }
            if (!this.question.get((int)i).params.equalsIgnoreCase("email") || this.question.get(i).getAnswer() == null) continue;
            email = this.question.get(i).getAnswer();
        }
        if (!name.isEmpty() && !email.isEmpty()) {
            int checkitem = 3;
            if (currentFormMsg.getContentValue().get(0).getQuestions().size() < 5) {
                --checkitem;
            }
            if (currentFormMsg.getValues().size() > checkitem) {
                this.checkAndCreateCustomer(name, email);
            }
        }
    }

    private boolean isValidEmail(String value, String param) {
        if (this.currentFormMsg.getContentValue().get(0).getQuestions().size() != this.currentFormMsg.getValues().size()) {
            if (param.equalsIgnoreCase("email")) {
                if (!Utils.isEmailValid(value)) {
                    return Utils.isEmailValid(value);
                }
            } else if (param.equalsIgnoreCase("name")) {
                return !value.equalsIgnoreCase("Visitor");
            }
        }
        return true;
    }

    private void checkAndCreateCustomer(String name, String email) {
        CommonParams.Builder params = new CommonParams.Builder();
        params.add("lang", "en").add("app_secret_key", HippoConfig.getInstance().getAppKey()).add("customer_name", name).add("customer_email", email).add("en_user_id", CommonData.getUserDetails().getData().getEn_user_id()).build();
        CommonParams commonParams = params.build();
        RestClient.getApiInterface().checkAndCreateCustomer(commonParams.getMap()).enqueue((Callback)new ResponseResolver<CreateCustomerResponse>(this.activity, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(CreateCustomerResponse createCustomerResponse) {
                DataFormTicketAdapter.this.currentFormMsg.setCheckAndCreateCustomer(true);
                if (DataFormTicketAdapter.this.currentFormMsg.isEdited()) {
                    DataFormTicketAdapter.this.currentFormMsg.setEdited(false);
                }
            }

            @Override
            public void failure(APIError error) {
            }
        });
    }

    public QRViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_data_ticket_form, parent, false);
        return new QRViewHolder(view, new MyFormEditTextListener());
    }

    @RequiresApi(api=19)
    public void onBindViewHolder(final QRViewHolder holder, final int position) {
        if (Objects.equals(this.question.get((int)position).type, "phone")) {
            String text = Restring.getString(this.context, R.string.hippo_with_country_code);
            String enterNum = Restring.getString(this.context, R.string.hippo_enter_phone_number);
            holder.title.setText((CharSequence)(this.question.get(position).getQuestion() + " " + text));
            holder.title.setText((CharSequence)enterNum);
        } else {
            holder.title.setText((CharSequence)this.question.get(position).getQuestion());
        }
        try {
            if (position == 0) {
                holder.countView.setVisibility(0);
                holder.countView.setText((CharSequence)(this.question.size() + "/" + this.currentFormMsg.getContentValue().get(0).getQuestions().size()));
            } else {
                holder.countView.setVisibility(8);
            }
        }
        catch (Exception text) {
            // empty catch block
        }
        holder.tvSkip.setText((CharSequence)Restring.getString(this.context, R.string.skip));
        holder.doneBT.setText((CharSequence)Restring.getString(this.context, R.string.vw_confirm));
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.activity);
        layoutManager.setOrientation(1);
        holder.attachmentsRV.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        holder.attachmentsRV.setNestedScrollingEnabled(false);
        holder.etSearch.setTag(position);
        holder.etSearch.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                int pos = (Integer)view.getTag();
                DataFormTicketAdapter.this.searchAdapter = new ArrayAdapter((Context)DataFormTicketAdapter.this.activity, 17367061, DataFormTicketAdapter.this.searchItem);
                holder.etSearch.setAdapter((ListAdapter)DataFormTicketAdapter.this.searchAdapter);
                DataFormTicketAdapter.this.searchItem.clear();
                DataFormTicketAdapter.this.getDropdownData(((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)pos)).params.equalsIgnoreCase("issueType"), "", holder);
            }
        });
        holder.etInputData.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (holder.updateIV.getVisibility() == 0) {
                    holder.updateIV.setVisibility(8);
                    holder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)DataFormTicketAdapter.this.context, (int)R.drawable.hippo_ic_arrow));
                    holder.arrowBgView.setVisibility(0);
                    holder.actionView.setVisibility(0);
                }
            }
        });
        holder.etSearch.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (editable.toString().trim().length() > 2) {
                    if (!holder.searchedText.equals(editable.toString())) {
                        holder.showDropdown = true;
                        holder.searchedText = editable.toString();
                        DataFormTicketAdapter.this.getDropdownData(((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)position)).params.equalsIgnoreCase("issueType"), editable.toString(), holder);
                    } else {
                        holder.showDropdown = false;
                    }
                } else if (editable.toString().trim().length() == 0) {
                    DataFormTicketAdapter.this.searchItem.clear();
                    holder.showDropdown = true;
                    holder.searchedText = "";
                    DataFormTicketAdapter.this.getDropdownData(((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)position)).params.equalsIgnoreCase("issueType"), "", holder);
                }
            }
        });
        holder.etSearch.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                String text = adapterView.getItemAtPosition(i).toString();
                if (!text.trim().equalsIgnoreCase(Restring.getString(DataFormTicketAdapter.this.context, R.string.fugu_no_data_found)) && !text.trim().equalsIgnoreCase(Restring.getString(DataFormTicketAdapter.this.context, R.string.fugu_no_option_available))) {
                    holder.etInputData.setText((CharSequence)text);
                    holder.etSearch.setEnoughFilter(false);
                    holder.etSearch.setText(text);
                } else {
                    holder.etSearch.setText("");
                    holder.etInputData.setText((CharSequence)"");
                }
            }
        });
        holder.etInputData.setTag((Object)position);
        holder.etInputData.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
                int pos = (Integer)view.getTag();
                holder.myCustomEditTextListener.updatePosition(DataFormTicketAdapter.this.currentFormMsg, pos);
            }
        });
        if (this.currentFormMsg.getValues().size() != this.currentFormMsg.getContentValue().get(0).getQuestions().size() && this.activity instanceof FuguChatActivity) {
            ((FuguChatActivity)this.activity).setCalenderOption();
        }
        if (this.question.get(position).isAnswered()) {
            holder.etInputData.setText((CharSequence)this.question.get(position).getAnswer());
            holder.etInputData.setEnabled(false);
            holder.etInputData.setVisibility(0);
            holder.etSearch.setVisibility(8);
            holder.updateIV.setVisibility(8);
            holder.etInputData.setFocusable(false);
            holder.etInputData.setFocusableInTouchMode(false);
            holder.etInputData.setClickable(false);
            holder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_tick));
            holder.arrowBgView.setVisibility(8);
            holder.doneBT.setVisibility(8);
            holder.countryView.setVisibility(8);
            switch (this.question.get((int)position).params) {
                case "email": 
                case "name": {
                    int sizecheck = 4;
                    sizecheck = this.currentFormMsg.getContentValue().get(0).getQuestions().size() < 5 ? 3 : 4;
                    if (this.currentFormMsg.getValues().size() < sizecheck) {
                        holder.etInputData.setEnabled(true);
                        holder.etInputData.setVisibility(0);
                        holder.etSearch.setVisibility(8);
                        holder.etInputData.setFocusable(true);
                        holder.actionView.setVisibility(8);
                        holder.updateIV.setVisibility(0);
                        holder.etInputData.setFocusableInTouchMode(true);
                        holder.etInputData.setClickable(true);
                        holder.arrowBgView.setVisibility(0);
                        break;
                    }
                    holder.etInputData.setEnabled(false);
                    holder.etInputData.setVisibility(0);
                    holder.etSearch.setVisibility(8);
                    holder.etInputData.setFocusable(false);
                    holder.updateIV.setVisibility(8);
                    holder.etInputData.setFocusableInTouchMode(false);
                    holder.etInputData.setClickable(false);
                    holder.arrowBgView.setVisibility(8);
                    holder.actionView.setVisibility(0);
                    holder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_tick));
                    break;
                }
                case "attachments": {
                    try {
                        String text = "N/A";
                        JSONArray jsonArr = null;
                        if (!this.question.get(position).getAnswer().equalsIgnoreCase("N/A")) {
                            jsonArr = new JSONArray(this.question.get(position).getAnswer());
                            for (int i = 0; i < jsonArr.length(); ++i) {
                                JSONObject jsonObj = jsonArr.getJSONObject(i);
                                text = text.equalsIgnoreCase("N/A") ? jsonObj.getString("fileName") : text + ", " + jsonObj.getString("fileName");
                            }
                        }
                        if (!text.isEmpty()) {
                            holder.tvError.setVisibility(8);
                        }
                        holder.etInputData.setText((CharSequence)text);
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            holder.etInputData.setHint((CharSequence)this.question.get(position).getQuestion());
            holder.myCustomEditTextListener.updatePosition(this.currentFormMsg, position);
            holder.etInputData.setEnabled(true);
            holder.etInputData.setSingleLine(true);
            holder.doneBT.setVisibility(8);
            holder.etInputData.setFocusable(true);
            holder.etInputData.setFocusableInTouchMode(true);
            holder.etInputData.setClickable(true);
            holder.updateIV.setVisibility(8);
            holder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_arrow));
            holder.arrowBgView.setVisibility(0);
            if (this.currentFormMsg.getIsSkipEvent() == 0 && this.currentFormMsg.isSkipButton() && position == this.question.size() - 1) {
                holder.btnSkip.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)this.question.get((int)position).text)) {
                holder.etInputData.setText((CharSequence)this.question.get((int)position).text);
            }
            switch (this.question.get((int)position).params) {
                case "Number": {
                    holder.attachmentsRV.setVisibility(8);
                    holder.etInputData.setVisibility(0);
                    holder.actionView.setVisibility(0);
                    holder.etSearch.setVisibility(8);
                    holder.doneBT.setVisibility(8);
                    holder.arrowBgView.setVisibility(0);
                    holder.etInputData.setInputType(8194);
                    holder.etInputData.setSingleLine(true);
                    holder.etInputData.setFocusable(true);
                    holder.etInputData.setFocusableInTouchMode(true);
                    holder.etInputData.setClickable(true);
                    holder.tvSkip.setVisibility(8);
                    break;
                }
                case "name": {
                    holder.attachmentsRV.setVisibility(8);
                    holder.etInputData.setVisibility(0);
                    holder.actionView.setVisibility(0);
                    holder.etSearch.setVisibility(8);
                    holder.doneBT.setVisibility(8);
                    holder.arrowBgView.setVisibility(0);
                    holder.etInputData.setInputType(97);
                    holder.etInputData.setSingleLine(true);
                    holder.etInputData.setFocusable(true);
                    holder.etInputData.setFocusableInTouchMode(true);
                    holder.etInputData.setClickable(true);
                    holder.tvSkip.setVisibility(8);
                    if (CommonData.getUserDetails().getData().getFullName() == null || CommonData.getUserDetails().getData().getFullName().isEmpty() || CommonData.getUserDetails().getData().getFullName().equalsIgnoreCase("Visitor")) break;
                    holder.etInputData.setText((CharSequence)CommonData.getUserDetails().getData().getFullName());
                    holder.actionView.callOnClick();
                    break;
                }
                case "email": {
                    holder.tvSkip.setVisibility(8);
                    holder.attachmentsRV.setVisibility(8);
                    holder.etInputData.setVisibility(0);
                    holder.actionView.setVisibility(0);
                    holder.etSearch.setVisibility(8);
                    holder.arrowBgView.setVisibility(0);
                    holder.doneBT.setVisibility(8);
                    holder.etInputData.setFocusable(true);
                    holder.etInputData.setFocusableInTouchMode(true);
                    holder.etInputData.setClickable(true);
                    holder.etInputData.setInputType(33);
                    if (CommonData.getUserDetails().getData().getEmail() == null || CommonData.getUserDetails().getData().getEmail().isEmpty()) break;
                    holder.etInputData.setText((CharSequence)CommonData.getUserDetails().getData().getEmail());
                    holder.actionView.callOnClick();
                    break;
                }
                case "phone": {
                    holder.tvSkip.setVisibility(8);
                    holder.attachmentsRV.setVisibility(8);
                    holder.etInputData.setVisibility(0);
                    holder.etSearch.setVisibility(8);
                    holder.actionView.setVisibility(0);
                    holder.arrowBgView.setVisibility(0);
                    holder.doneBT.setVisibility(8);
                    holder.etInputData.setFocusable(true);
                    holder.etInputData.setFocusableInTouchMode(true);
                    holder.etInputData.setClickable(true);
                    holder.etInputData.setInputType(3);
                    holder.countryView.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)this.question.get((int)position).countryCode)) {
                        holder.countryView.setText((CharSequence)this.question.get((int)position).countryCode);
                        break;
                    }
                    String code = this.getDefaultCode();
                    if (!TextUtils.isEmpty((CharSequence)code)) {
                        holder.countryView.setText((CharSequence)this.getDefaultCode());
                        break;
                    }
                    holder.countryView.setText((CharSequence)"+91");
                    break;
                }
                case "issueType": {
                    holder.tvSkip.setVisibility(8);
                    holder.attachmentsRV.setVisibility(8);
                    holder.etInputData.setVisibility(8);
                    holder.arrowBgView.setVisibility(0);
                    holder.doneBT.setVisibility(8);
                    holder.etSearch.setVisibility(0);
                    holder.etInputData.setFocusable(true);
                    holder.actionView.setVisibility(0);
                    holder.etInputData.setFocusableInTouchMode(true);
                    holder.etInputData.setClickable(true);
                    holder.etInputData.setInputType(33);
                    break;
                }
                case "priority": {
                    holder.tvSkip.setVisibility(0);
                    holder.attachmentsRV.setVisibility(8);
                    holder.etInputData.setVisibility(8);
                    holder.arrowBgView.setVisibility(0);
                    holder.doneBT.setVisibility(8);
                    holder.actionView.setVisibility(0);
                    holder.etSearch.setVisibility(0);
                    holder.etInputData.setFocusable(true);
                    holder.etInputData.setFocusableInTouchMode(true);
                    holder.etInputData.setClickable(true);
                    holder.etInputData.setInputType(33);
                    break;
                }
                case "attachments": {
                    holder.tvSkip.setVisibility(0);
                    holder.attachmentsRV.setVisibility(0);
                    holder.etInputData.setFocusable(false);
                    holder.etInputData.setVisibility(0);
                    holder.etSearch.setVisibility(8);
                    holder.actionView.setVisibility(8);
                    holder.arrowBgView.setVisibility(8);
                    if (this.question.get(position).isAttachmentUploading()) {
                        holder.uploadProgress.setVisibility(0);
                        holder.doneBT.setVisibility(8);
                    } else {
                        holder.uploadProgress.setVisibility(8);
                        holder.doneBT.setVisibility(0);
                    }
                    holder.etInputData.setFocusableInTouchMode(false);
                    holder.etInputData.setClickable(true);
                    holder.etInputData.setTag((Object)position);
                    AttachmentsAdapter attachmentsAdapter = new AttachmentsAdapter((Context)this.activity, this.question.get(position).getAttachments());
                    holder.attachmentsRV.setAdapter((RecyclerView.Adapter)attachmentsAdapter);
                    holder.etInputData.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (!Utils.preventMultipleClicks()) {
                                return;
                            }
                            int pos = (Integer)view.getTag();
                            if (((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)pos)).attachments.size() < 5 && !((Question)DataFormTicketAdapter.this.question.get(pos)).isAttachmentUploading()) {
                                DataFormTicketAdapter.this.openAttachmentChooser(pos, view);
                            }
                        }
                    });
                    if (this.question.get((int)position).attachments.size() <= 0) break;
                    holder.tvError.setVisibility(8);
                }
            }
        }
    }

    private void getDropdownData(final boolean issueTye, String text, final QRViewHolder holder) {
        CommonParams.Builder params = new CommonParams.Builder();
        params.add("lang", "en").add("reference", "Issue").add("business_id", CommonData.getUserDetails().getData().getBusinessId()).add("text", text);
        if (issueTye) {
            params.add("type", "Issue Type");
        } else {
            params.add("type", "Issue Priority");
        }
        CommonParams commonParams = params.build();
        RestClient.getApiInterface().erpNextSearch(commonParams.getMap()).enqueue((Callback)new ResponseResolver<TicketPriorityOptionsData>(this.activity, Boolean.valueOf(false), Boolean.valueOf(false)){

            @Override
            public void success(TicketPriorityOptionsData ticketPriorityOptionsData) {
                ArrayList<Result> result = ticketPriorityOptionsData.getData().getResults();
                if (holder.showDropdown) {
                    DataFormTicketAdapter.this.searchItem.clear();
                    for (int i = 0; i < ticketPriorityOptionsData.getData().getResults().size(); ++i) {
                        DataFormTicketAdapter.this.searchItem.add(ticketPriorityOptionsData.getData().getResults().get(i).getValue());
                    }
                    if (DataFormTicketAdapter.this.searchItem.size() == 0) {
                        if (issueTye) {
                            DataFormTicketAdapter.this.searchItem.add(Restring.getString(DataFormTicketAdapter.this.context, R.string.fugu_no_data_found));
                        } else {
                            DataFormTicketAdapter.this.searchItem.add(Restring.getString(DataFormTicketAdapter.this.context, R.string.fugu_no_option_available));
                        }
                    }
                    DataFormTicketAdapter.this.searchAdapter = new ArrayAdapter((Context)DataFormTicketAdapter.this.activity, 17367061, DataFormTicketAdapter.this.searchItem);
                    holder.etSearch.setAdapter((ListAdapter)DataFormTicketAdapter.this.searchAdapter);
                    holder.etSearch.setEnoughFilter(true);
                    holder.etSearch.showDropDown();
                }
            }

            @Override
            public void failure(APIError error) {
                DataFormTicketAdapter.this.searchItem.clear();
                if (issueTye) {
                    DataFormTicketAdapter.this.searchItem.add(Restring.getString(DataFormTicketAdapter.this.context, R.string.fugu_no_data_found));
                } else {
                    DataFormTicketAdapter.this.searchItem.add(Restring.getString(DataFormTicketAdapter.this.context, R.string.fugu_no_option_available));
                }
                DataFormTicketAdapter.this.searchAdapter = new ArrayAdapter((Context)DataFormTicketAdapter.this.activity, 17367061, DataFormTicketAdapter.this.searchItem);
                holder.etSearch.setAdapter((ListAdapter)DataFormTicketAdapter.this.searchAdapter);
                holder.etSearch.setEnoughFilter(true);
                holder.etSearch.showDropDown();
            }
        });
    }

    private void openAttachmentChooser(int pos, View view) {
        if (this.question.get((int)pos).params.equalsIgnoreCase("attachments") && this.activity instanceof FuguChatActivity) {
            ((FuguChatActivity)this.activity).selectImage(view, true, this, pos);
        }
    }

    public int getItemCount() {
        return this.question == null ? 0 : this.question.size();
    }

    public boolean isValid(String data, EditText edittext, String dataType, TextView tvError) {
        boolean isValid;
        if (data.isEmpty() && !dataType.equalsIgnoreCase("attachments")) {
            String text = Restring.getString(this.context, R.string.hippo_field_cant_empty);
            tvError.setText((CharSequence)text);
            tvError.setVisibility(0);
            return false;
        }
        String error = null;
        switch (dataType) {
            case "Number": {
                String numOnly = Restring.getString(this.context, R.string.hippo_enter_number_only);
                isValid = Utils.isNumeric(data);
                error = isValid ? null : numOnly;
                break;
            }
            case "email": {
                String validEmail = Restring.getString(this.context, R.string.hippo_enter_valid);
                isValid = Utils.isEmailValid(data);
                error = isValid ? null : validEmail;
                break;
            }
            case "phone": {
                String validPhn = Restring.getString(this.context, R.string.hippo_enter_valid_phn_no);
                isValid = Utils.isValidPhoneNumber(data);
                error = isValid ? null : validPhn;
                break;
            }
            default: {
                isValid = true;
            }
        }
        edittext.requestFocus();
        if (!TextUtils.isEmpty(error)) {
            tvError.setVisibility(0);
            tvError.setText((CharSequence)error);
        } else {
            tvError.setVisibility(8);
        }
        return isValid;
    }

    @Override
    public void onAttachmentListener(FileuploadModel fileuploadModel, int attachmentPosition) {
        this.question.get(attachmentPosition).setAttachmentUploading(false);
        this.question.get((int)attachmentPosition).attachments.add(fileuploadModel);
        this.notifyItemChanged(attachmentPosition);
    }

    @Override
    public void onAttachmentSelected(int attachmentPosition) {
        this.question.get(attachmentPosition).setAttachmentUploading(true);
        this.notifyItemChanged(attachmentPosition);
    }

    private String getDefaultCode() {
        try {
            CountryPicker countryPicker = new CountryPicker.Builder().with(this.context).build();
            return countryPicker.getCountryFromSIM().getDialCode();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void openPicker(final TextView textView, final EditText editText) {
        CountryPicker countryPicker = new CountryPicker.Builder().with(this.context).sortBy(1).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                textView.setText((CharSequence)country.getDialCode());
                DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(country.getDialCode());
                editText.requestFocus();
            }
        }).build();
        countryPicker.showDialog(this.fragmentManager);
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private Message currentOrderItem;
        private int position;

        public void updatePosition(Message currentOrderItem, int position) {
            this.currentOrderItem = currentOrderItem;
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            if (this.currentOrderItem != null) {
                this.currentOrderItem.setComment(charSequence.toString());
            }
        }

        public void afterTextChanged(Editable editable) {
            if (this.currentOrderItem != null) {
                DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(editable.toString());
            }
        }
    }

    public class Question {
        String question;
        String answer;
        String type;
        String params;
        String text;
        String countryCode;
        boolean isAnswered;
        boolean attachmentUploading = false;
        ArrayList<FileuploadModel> attachments = new ArrayList();

        public boolean isAttachmentUploading() {
            return this.attachmentUploading;
        }

        public void setAttachmentUploading(boolean attachmentUploading) {
            this.attachmentUploading = attachmentUploading;
        }

        public ArrayList<FileuploadModel> getAttachments() {
            return this.attachments;
        }

        public Question(String question, String answer, String type, String params, String text, String countryCode) {
            this.question = question;
            this.answer = answer;
            this.type = type;
            this.params = params;
            this.text = text;
            this.countryCode = countryCode;
            this.attachmentUploading = false;
            if (!TextUtils.isEmpty((CharSequence)answer)) {
                this.isAnswered = true;
            }
        }

        public String getQuestion() {
            return this.question;
        }

        public void setQuestion(String question) {
            this.question = question;
        }

        public void addAttachment(FileuploadModel fileuploadModel) {
            this.attachments.add(fileuploadModel);
        }

        public void removeAttachment(int position) {
            this.attachments.remove(position);
        }

        public String getAnswer() {
            return this.answer;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public boolean isAnswered() {
            return this.isAnswered;
        }

        public void setAnswered(boolean answered) {
            this.isAnswered = answered;
        }
    }

    public class QRViewHolder
    extends RecyclerView.ViewHolder {
        public MyFormEditTextListener myCustomEditTextListener;
        ImageView actionView;
        ImageView arrowBgView;
        ImageView updateIV;
        private EditText etInputData;
        private TextView tvError;
        private TextView doneBT;
        private TextView title;
        private TextView tvSkip;
        private TextView countView;
        private TextView countryView;
        private TextView btnSkip;
        private RecyclerView attachmentsRV;
        private InstantAutoComplete etSearch;
        private ProgressBar uploadProgress;
        private boolean showDropdown;
        private String searchedText;

        public QRViewHolder(View itemView, MyFormEditTextListener myCustomEditTextListener) {
            super(itemView);
            this.showDropdown = true;
            this.searchedText = "";
            this.etInputData = (EditText)itemView.findViewById(R.id.etInputData);
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.etInputData.addTextChangedListener((TextWatcher)myCustomEditTextListener);
            this.title = (TextView)itemView.findViewById(R.id.title_view);
            this.tvError = (TextView)itemView.findViewById(R.id.tvError);
            this.tvSkip = (TextView)itemView.findViewById(R.id.tvSkip);
            this.uploadProgress = (ProgressBar)itemView.findViewById(R.id.uploadProgress);
            this.updateIV = (ImageView)itemView.findViewById(R.id.updateIV);
            this.countView = (TextView)itemView.findViewById(R.id.count_view);
            this.countryView = (TextView)itemView.findViewById(R.id.country_picker);
            this.actionView = (ImageView)itemView.findViewById(R.id.action_view);
            this.arrowBgView = (ImageView)itemView.findViewById(R.id.arrow_background_view);
            this.doneBT = (TextView)itemView.findViewById(R.id.doneBT);
            this.btnSkip = (TextView)itemView.findViewById(R.id.btnSkip);
            this.attachmentsRV = (RecyclerView)itemView.findViewById(R.id.attachmentsRV);
            this.etSearch = (InstantAutoComplete)itemView.findViewById(R.id.etSearch);
            this.etSearch.setThreshold(1);
            this.tvSkip.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (QRViewHolder.this.countryView.getVisibility() == 0) {
                        String message = DataFormTicketAdapter.this.currentFormMsg.getComment();
                        DataFormTicketAdapter.this.currentFormMsg.setComment(QRViewHolder.this.countryView.getText().toString().trim() + message);
                    }
                    DataFormTicketAdapter.this.currentFormMsg.setComment("N/A");
                    DataFormTicketAdapter.this.qrCallback.onFormClickListenerTicket(QRViewHolder.this.getAdapterPosition(), DataFormTicketAdapter.this.currentFormMsg, QRViewHolder.this.getAdapterPosition());
                    DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(null);
                    DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(null);
                }
            });
            this.actionView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (DataFormTicketAdapter.this.isValid(DataFormTicketAdapter.this.currentFormMsg.getComment(), QRViewHolder.this.etInputData, ((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)QRViewHolder.this.getAdapterPosition())).params, QRViewHolder.this.tvError)) {
                        if (QRViewHolder.this.getAdapterPosition() < DataFormTicketAdapter.this.currentFormMsg.getValues().size()) {
                            DataFormTicketAdapter.this.currentFormMsg.setEdited(true);
                        }
                        if (QRViewHolder.this.countryView.getVisibility() == 0) {
                            String message = DataFormTicketAdapter.this.currentFormMsg.getComment();
                            DataFormTicketAdapter.this.currentFormMsg.setComment(QRViewHolder.this.countryView.getText().toString().trim() + message);
                        }
                        DataFormTicketAdapter.this.qrCallback.onFormClickListenerTicket(QRViewHolder.this.getAdapterPosition(), DataFormTicketAdapter.this.currentFormMsg, QRViewHolder.this.getAdapterPosition());
                        DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(null);
                        DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(null);
                        DataFormTicketAdapter.this.searchItem.clear();
                    }
                }
            });
            this.doneBT.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (DataFormTicketAdapter.this.isValid(DataFormTicketAdapter.this.currentFormMsg.getComment(), QRViewHolder.this.etInputData, ((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)QRViewHolder.this.getAdapterPosition())).params, QRViewHolder.this.tvError)) {
                        if (QRViewHolder.this.countryView.getVisibility() == 0) {
                            String message = DataFormTicketAdapter.this.currentFormMsg.getComment();
                            DataFormTicketAdapter.this.currentFormMsg.setComment(QRViewHolder.this.countryView.getText().toString().trim() + message);
                        }
                        switch (((Question)((DataFormTicketAdapter)DataFormTicketAdapter.this).question.get((int)QRViewHolder.this.getAdapterPosition())).params) {
                            case "attachments": {
                                try {
                                    JSONArray attachmentArray = new JSONArray();
                                    if (((Question)DataFormTicketAdapter.this.question.get(QRViewHolder.this.getAdapterPosition())).getAttachments() == null || ((Question)DataFormTicketAdapter.this.question.get(QRViewHolder.this.getAdapterPosition())).getAttachments().size() == 0) {
                                        QRViewHolder.this.tvError.setVisibility(0);
                                        QRViewHolder.this.tvError.setText((CharSequence)Restring.getString(DataFormTicketAdapter.this.context, R.string.hippo_field_cant_empty));
                                        return;
                                    }
                                    for (int i = 0; i < ((Question)DataFormTicketAdapter.this.question.get(QRViewHolder.this.getAdapterPosition())).getAttachments().size(); ++i) {
                                        JSONObject obj = new JSONObject();
                                        obj.put("fileName", (Object)((Question)DataFormTicketAdapter.this.question.get(QRViewHolder.this.getAdapterPosition())).getAttachments().get(i).getFileName());
                                        obj.put("url", (Object)((Question)DataFormTicketAdapter.this.question.get(QRViewHolder.this.getAdapterPosition())).getAttachments().get(i).getUploadedUrl());
                                        attachmentArray.put((Object)obj);
                                    }
                                    DataFormTicketAdapter.this.currentFormMsg.setComment(attachmentArray.toString());
                                    break;
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        DataFormTicketAdapter.this.qrCallback.onFormClickListenerTicket(QRViewHolder.this.getAdapterPosition(), DataFormTicketAdapter.this.currentFormMsg, QRViewHolder.this.getAdapterPosition());
                        DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(null);
                        DataFormTicketAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(null);
                        DataFormTicketAdapter.this.searchItem.clear();
                    }
                }
            });
            this.updateIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    QRViewHolder.this.actionView.callOnClick();
                }
            });
            this.btnSkip.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DataFormTicketAdapter.this.qrCallback.skipFormCallback(DataFormTicketAdapter.this.currentFormMsg);
                }
            });
            this.countryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DataFormTicketAdapter.this.openPicker(QRViewHolder.this.countryView, QRViewHolder.this.etInputData);
                }
            });
        }
    }
}

