/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.annotation.SuppressLint;
import android.net.Uri;
import com.hippo.HippoConfig;
import com.hippo.utils.Utilities;
import java.io.File;

public class AndroidUtilities {
    @SuppressLint(value={"PrivateApi"})
    public static String getSystemProperty(String key) {
        try {
            Class<?> props = Class.forName("android.os.SystemProperties");
            return (String)props.getMethod("get", String.class).invoke(null, key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isInternalUri(Uri uri) {
        String pathString;
        block10: {
            pathString = uri.getPath();
            if (pathString == null) {
                return false;
            }
            int tries = 0;
            do {
                String newPath;
                if (pathString != null && pathString.length() > 4096) {
                    return true;
                }
                try {
                    newPath = Utilities.readlink(pathString);
                }
                catch (Throwable e) {
                    return true;
                }
                if (newPath == null || newPath.equals(pathString)) break block10;
                pathString = newPath;
            } while (++tries < 10);
            return true;
        }
        if (pathString != null) {
            try {
                String path = new File(pathString).getCanonicalPath();
                if (path != null) {
                    pathString = path;
                }
            }
            catch (Exception e) {
                pathString.replace("/./", "/");
            }
        }
        if (pathString.endsWith(".attheme")) {
            return false;
        }
        return pathString != null && pathString.toLowerCase().contains("/data/data/" + HippoConfig.getInstance().getContext().getPackageName());
    }

    public static void runOnUIThread(Runnable runnable) {
        AndroidUtilities.runOnUIThread(runnable, 0L);
    }

    public static void runOnUIThread(Runnable runnable, long delay) {
        if (delay == 0L) {
            HippoConfig.getInstance();
            HippoConfig.applicationHandler.post(runnable);
        } else {
            HippoConfig.getInstance();
            HippoConfig.applicationHandler.postDelayed(runnable, delay);
        }
    }
}

