/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.os.AsyncTask;
import com.hippo.HippoConfig;
import com.hippo.database.CommonData;
import com.hippo.model.FuguConversation;
import com.hippo.model.UnreadCountModel;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\t\u001a\u0004\u0018\u00010\u00052\"\u0010\n\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\u000b\"\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/hippo/utils/UnreadCount;", "Landroid/os/AsyncTask;", "Ljava/util/ArrayList;", "Lcom/hippo/model/FuguConversation;", "Ljava/lang/Void;", "", "()V", "unreadCountModels", "Lcom/hippo/model/UnreadCountModel;", "doInBackground", "params", "", "([Ljava/util/ArrayList;)Ljava/lang/Integer;", "onPostExecute", "", "result", "saveData", "conversation", "hippo_release"})
public final class UnreadCount
extends AsyncTask<ArrayList<FuguConversation>, Void, Integer> {
    @NotNull
    private final ArrayList<UnreadCountModel> unreadCountModels = new ArrayList();

    @Nullable
    protected Integer doInBackground(ArrayList<FuguConversation> ... params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        ArrayList<FuguConversation> arrayList = params[0];
        Intrinsics.checkNotNull(arrayList);
        return this.saveData(arrayList);
    }

    protected void onPostExecute(int result) {
        if (HippoConfig.getInstance().getCallbackListener() != null) {
            System.out.println((Object)("total unread count = " + result));
            HippoConfig.getInstance().getCallbackListener().count(result);
        }
    }

    private final int saveData(ArrayList<FuguConversation> conversation) {
        try {
            this.unreadCountModels.clear();
            CommonData.setUnreadCount(this.unreadCountModels);
            CommonData.setTotalUnreadCount(0);
            int count = 0;
            for (FuguConversation data : conversation) {
                if (data.getUnreadCount() <= 0) continue;
                UnreadCountModel countModel = new UnreadCountModel(data.getChannelId(), data.getLabelId(), data.getUnreadCount());
                this.unreadCountModels.add(countModel);
                count += data.getUnreadCount();
            }
            CommonData.setUnreadCount(this.unreadCountModels);
            CommonData.setTotalUnreadCount(count);
            CommonData.hasUnreadCount(true);
            return count;
        }
        catch (Exception e) {
            int count = CommonData.getTotalUnreadCount();
            return count;
        }
    }
}

