/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.AudioManager;
import android.os.SystemClock;
import android.util.Patterns;
import android.view.inputmethod.InputMethodManager;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class Utils {
    private static final int MULTIPLE_CLICK_THRESHOLD = 2500;
    private static long mLastClickTime = 0L;

    public static boolean isNumeric(String value) {
        if (value == null) {
            return false;
        }
        return Pattern.matches("-?\\d+(\\.\\d+)?", value);
    }

    public static boolean isEmailValid(String email) {
        if (email == null) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    public static boolean isWebUrl(String url) {
        if (url == null) {
            return false;
        }
        return Patterns.WEB_URL.matcher(url).matches();
    }

    public static void showSoftKeyboard(Activity activity) {
        try {
            InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
            imm.toggleSoftInput(2, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean isValidPhoneNumber(CharSequence target) {
        if (target == null) {
            return false;
        }
        if (target.length() < 6 || target.length() > 17) {
            return false;
        }
        return Patterns.PHONE.matcher(target).matches();
    }

    public static boolean isValidNumber(CharSequence sequence) {
        if (sequence.length() < 9 && sequence.length() > 13) {
            return false;
        }
        return Patterns.PHONE.matcher(sequence).matches();
    }

    public static boolean containsNumber(String number) {
        return Pattern.compile("(\\+[0-9]+[\\- \\.]*)?(\\([0-9]+\\)[\\- \\.]*)?([0-9][0-9\\- \\.]+[0-9])").matcher(number).find();
    }

    public static boolean preventMultipleClicks() {
        if (SystemClock.elapsedRealtime() - mLastClickTime < 2500L) {
            return false;
        }
        mLastClickTime = SystemClock.elapsedRealtime();
        return true;
    }

    public static boolean hasData(List list) {
        return list != null && !list.isEmpty();
    }

    public static AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        try {
            Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            int color2 = -65536;
            Paint paint = new Paint();
            Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
            RectF rectF = new RectF(rect);
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(-65536);
            canvas.drawOval(rectF, paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            canvas.drawBitmap(bitmap, rect, rect, paint);
            bitmap.recycle();
            return output;
        }
        catch (Exception e) {
            return bitmap;
        }
    }

    public static String generateRandomString() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        StringBuilder salt = new StringBuilder();
        Random rnd = new Random();
        while (salt.length() < 18) {
            int index = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt.append(SALTCHARS.charAt(index));
        }
        String saltStr = salt.toString();
        return saltStr;
    }

    public static int getUniqueId(String url, String dirPath, String fileName) {
        byte[] hash;
        String string2 = url + File.separator + dirPath + File.separator + fileName;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string2.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UnsupportedEncodingException", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString().hashCode();
    }

    public static void shareCallUrl(String meetUrl, Activity activity) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", meetUrl);
        intent.setType("text/plain");
        Intent shareIntent = Intent.createChooser((Intent)intent, (CharSequence)"Share Call Link");
        activity.startActivity(shareIntent);
    }
}

