/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.fileUpload;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import androidx.core.content.FileProvider;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.filepicker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileManager {
    private static final String TAG = FileManager.class.getSimpleName();
    private static FileManager instance;

    private FileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileManager getInstance() {
        if (instance != null) return instance;
        Class<FileManager> clazz = FileManager.class;
        synchronized (FileManager.class) {
            if (instance != null) return instance;
            instance = new FileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getLocalPath(Context activity, String fileName, String folderType) {
        try {
            String localName;
            File file;
            if (folderType == null) {
                folderType = FuguAppConstant.FOLDER_TYPE.get("file");
            }
            if ((file = new File(localName = Util.getDirectoryPath(activity, folderType) + File.separator + fileName)).exists() && file.isFile()) {
                return file.getPath();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public Uri getPublicFilePath(Context context, String fileName) {
        block3: {
            try {
                File file = new File(context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS), fileName);
                if (file.exists()) {
                    Uri mDestinationUri = Uri.withAppendedPath((Uri)Uri.fromFile((File)context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS)), (String)fileName);
                    System.out.println(mDestinationUri.getPath());
                    return mDestinationUri;
                }
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(Context context, String sourceUrl, String folderType, FileuploadModel fileuploadModel, Uri fileUri, FileCopyListener fileCopyListener) throws IOException {
        String localName = fileuploadModel.getFileName();
        File sourceFile = new File(sourceUrl);
        if (folderType.equalsIgnoreCase(FuguAppConstant.FOLDER_TYPE.get(FuguAppConstant.DocumentType.FILE.toString())) && sourceFile.length() > HippoConfig.getMaxSize()) {
            fileCopyListener.largeFileSize();
            return;
        }
        if (!folderType.equalsIgnoreCase(FuguAppConstant.FOLDER_TYPE.get(FuguAppConstant.DocumentType.VIDEO.toString())) && sourceFile.length() > HippoConfig.getMaxSize()) {
            fileCopyListener.largeFileSize();
            return;
        }
        if (!folderType.equalsIgnoreCase(FuguAppConstant.FOLDER_TYPE.get(FuguAppConstant.DocumentType.AUDIO.toString())) && sourceFile.length() > HippoConfig.getMaxSize()) {
            fileCopyListener.largeFileSize();
            return;
        }
        if (!folderType.equalsIgnoreCase(FuguAppConstant.FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.toString())) && sourceFile.length() > HippoConfig.getMaxSize()) {
            fileCopyListener.largeFileSize();
            return;
        }
        File destFile = new File(Util.getDirectoryPath(context, folderType), localName);
        if (sourceUrl.equalsIgnoreCase(Util.getDirectoryPath(context, folderType) + "/" + localName)) {
            if (fileCopyListener != null) {
                fileuploadModel.setFilePath(destFile.getPath());
                fileCopyListener.onCopingFile(true, fileuploadModel);
            }
            return;
        }
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        if (fileUri != null) {
            int bytesRead;
            InputStream streem = context.getContentResolver().openInputStream(fileUri);
            FileOutputStream outStreem = new FileOutputStream(destFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = streem.read(buffer)) != -1) {
                ((OutputStream)outStreem).write(buffer, 0, bytesRead);
            }
            ((OutputStream)outStreem).close();
            streem.close();
        } else {
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
        }
        if (fileCopyListener != null) {
            fileuploadModel.setFilePath(destFile.getPath());
            fileCopyListener.onCopingFile(true, fileuploadModel);
        }
    }

    public void openFileInDevice(Context context, String localPath, FileCopyListener fileCopyListener) {
        MimeTypeMap myMime = MimeTypeMap.getSingleton();
        Intent newIntent = new Intent("android.intent.action.VIEW");
        String mimeType = myMime.getMimeTypeFromExtension(Util.getExtension(localPath));
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            mimeType = URLConnection.guessContentTypeFromName(localPath);
        }
        Uri uri = FileProvider.getUriForFile((Context)context, (String)CommonData.getProvider(), (File)new File(localPath));
        newIntent.setDataAndType(uri, mimeType);
        newIntent.setFlags(0x4000001);
        newIntent.setFlags(0x10000000);
        newIntent.addFlags(0x40000000);
        newIntent.addFlags(1);
        try {
            context.startActivity(newIntent);
        }
        catch (Exception e) {
            if (fileCopyListener != null) {
                fileCopyListener.onError();
            }
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.no_handler), (int)1).show();
        }
    }

    public static interface FileCopyListener {
        public void onCopingFile(boolean var1, FileuploadModel var2);

        public void largeFileSize();

        public void onError();
    }
}

