/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.app.ActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.aws.AwsData;
import com.hippo.aws.ImageUploadInterface;
import com.hippo.aws.UploadTask;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.langs.Restring;
import com.hippo.model.Message;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.fileUpload.ProgressRequestBody;
import faye.ConnectionManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class MyForeGroundService
extends Service
implements FuguAppConstant,
ProgressRequestBody.UploadCallbacks {
    private static final String TAG = MyForeGroundService.class.getSimpleName();
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    private Handler h;
    private Runnable r;
    int counter = 0;
    private Type fileuploadType = new TypeToken<List<FileuploadModel>>(){}.getType();
    NotificationManager manager;
    NotificationCompat.Builder builder;
    FileuploadModel fileuploadModel;
    ArrayList<FileuploadModel> fileuploadModels = new ArrayList();
    boolean apiInProgress;
    boolean isFirstTime;

    public IBinder onBind(Intent intent) {
        return null;
    }

    private Notification updateNotification() {
        ++this.counter;
        Context context = this.getApplicationContext();
        this.manager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            String CHANNEL_ID = "hippo_file_uploading";
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)this.getString(R.string.app_name), 3);
            channel.setDescription("File uploading");
            this.manager.createNotificationChannel(channel);
            this.builder = new NotificationCompat.Builder((Context)this, CHANNEL_ID);
        } else {
            this.builder = new NotificationCompat.Builder(context);
        }
        this.builder.setProgress(100, this.counter, false);
        return this.builder.setContentTitle((CharSequence)Restring.getString((Context)this, R.string.uploading)).setTicker((CharSequence)"").setOnlyAlertOnce(true).setContentText((CharSequence)Restring.getString((Context)this, R.string.uploading_in_progress)).setSmallIcon(R.drawable.hippo_default_notif_icon).setOngoing(true).build();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null && intent.getAction() != null && intent.getAction().contains("start")) {
            this.startForeground(101, this.updateNotification());
            this.uploadFileServerCall();
        } else {
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
        return 1;
    }

    public void stopFayeClient() {
    }

    public void updateProgress(int uploaded, int total) {
        if (this.builder != null && this.manager != null) {
            this.builder.setProgress(total, uploaded, false);
            this.manager.notify(101, this.builder.build());
        } else {
            this.startForeground(101, this.updateNotification());
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    private void uploadFileServerCall() {
        try {
            if (this.apiInProgress) {
                HippoLog.e(TAG, "***************ApiInProgress*************");
                return;
            }
            if (this.isNetworkAvailable()) {
                String data = Prefs.with((Context)this).getString("pref_upload_data", "");
                HippoLog.v(TAG, "uploadFileServerCall 1: " + data);
                this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
                if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                    Prefs.with((Context)this).remove("pref_upload_data");
                    this.stopFayeClient();
                    this.stopForeground(true);
                    this.stopSelf();
                    return;
                }
                this.fileuploadModel = this.fileuploadModels.get(0);
                this.isFirstTime = true;
                ProgressRequestBody fileBody = new ProgressRequestBody(new File(this.fileuploadModel.getFilePath()), this, this.getMimeType(this.fileuploadModel.getFilePath()), this.fileuploadModel.getFilePath(), this.fileuploadModel.getMessageIndex(), this.fileuploadModel.getMuid());
                MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)this.fileuploadModel.getFileName(), (RequestBody)fileBody);
                this.apiInProgress = true;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("app_secret_key", HippoConfig.getInstance().getAppKey());
                map.put("file_name", this.fileuploadModel.getFileName());
                map.put("file_type", this.getMimeType(this.fileuploadModel.getFilePath()));
                map.put("source", "3");
                map.put("device_type", 1);
                map.put("en_user_id", CommonData.getUserDetails().getData().getEn_user_id());
                map.put("allow_all_mime_type", true);
                map.put("restrict_mime_type", !CommonData.getAttributes().shareAllFileTypes());
                if (CommonData.getAttributes() != null && !TextUtils.isEmpty((CharSequence)CommonData.getAttributes().getUserIdentificationSecret())) {
                    map.put("user_identification_secret", CommonData.getAttributes().getUserIdentificationSecret());
                }
                RestClient.getApiInterface().getUploadedFile(map).enqueue((Callback)new ResponseResolver<AwsData>(){

                    @Override
                    public void success(final AwsData awsData) {
                        if (MyForeGroundService.this.getMimeType(MyForeGroundService.this.fileuploadModel.getFilePath()).contains("video")) {
                            try {
                                Bitmap bMap = ThumbnailUtils.createVideoThumbnail((String)MyForeGroundService.this.fileuploadModel.getFilePath(), (int)3);
                                File f = new File(MyForeGroundService.this.getApplication().getCacheDir(), awsData.getData().getThumbnail_file_name());
                                f.createNewFile();
                                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                bMap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)bos);
                                byte[] bitmapdata = bos.toByteArray();
                                FileOutputStream fos = new FileOutputStream(f);
                                fos.write(bitmapdata);
                                fos.flush();
                                fos.close();
                                Log.e((String)"upload thumb", (String)"thumb");
                                new UploadTask(awsData.getData().getThumbnail_url(), null, f, new ImageUploadInterface(){

                                    @Override
                                    public void sucessfullupload() {
                                        MyForeGroundService.this.uploadTask(awsData);
                                    }

                                    @Override
                                    public void failureUpload(Throwable throwable) {
                                        MyForeGroundService.this.handleException();
                                    }
                                }).execute(new String[0]);
                            }
                            catch (Exception e) {
                                MyForeGroundService.this.uploadTask(awsData);
                                e.printStackTrace();
                            }
                        } else {
                            MyForeGroundService.this.uploadTask(awsData);
                        }
                    }

                    @Override
                    public void failure(APIError error) {
                        Log.e((String)TAG, (String)"In uploading failure");
                        if (error.getStatusCode() == 400) {
                            MyForeGroundService.this.handleException(true, error.getMessage());
                        } else {
                            MyForeGroundService.this.handleException();
                        }
                    }
                });
            } else {
                HippoLog.e(TAG, "In uploading else");
                this.handleException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HippoLog.e(TAG, "In uploading else 2");
            this.handleException();
        }
    }

    private void uploadTask(final AwsData awsData) {
        new UploadTask(awsData.getData().getUrl(), this.fileuploadModel.getFilePath(), null, new ImageUploadInterface(){

            @Override
            public void sucessfullupload() {
                JSONObject jsonObject;
                String data;
                String thumbnail_url;
                String image_url;
                block10: {
                    image_url = awsData.getData().getSource_url();
                    thumbnail_url = awsData.getData().getSource_url();
                    if (MyForeGroundService.this.getMimeType(MyForeGroundService.this.fileuploadModel.getFilePath()).contains("video")) {
                        thumbnail_url = awsData.getData().getThumbnail_source_url();
                    }
                    data = Prefs.with((Context)MyForeGroundService.this).getString("pref_upload_data", "");
                    HippoLog.v(TAG, "In response: " + data);
                    MyForeGroundService.this.fileuploadModels = (ArrayList)new Gson().fromJson(data, MyForeGroundService.this.fileuploadType);
                    jsonObject = MyForeGroundService.this.fileuploadModels.get(0).getMessageObject();
                    if (MyForeGroundService.this.fileuploadModel.isTicketAttachmentFile() || MyForeGroundService.this.fileuploadModel.isIsattachmentinbotresponce()) {
                        jsonObject = new JSONObject();
                    }
                    try {
                        jsonObject.put("image_url", (Object)image_url);
                        jsonObject.put("thumbnail_url", (Object)thumbnail_url);
                        jsonObject.put("url", (Object)image_url);
                        jsonObject.remove("local_url");
                    }
                    catch (JSONException e) {
                        if (!HippoConfig.DEBUG) break block10;
                        e.printStackTrace();
                    }
                }
                MyForeGroundService.this.fileuploadModels.get(0).setFileUploaded(true);
                MyForeGroundService.this.fileuploadModels.get(0).setMessageObject(jsonObject);
                if (MyForeGroundService.this.fileuploadModel.isTicketAttachmentFile() || MyForeGroundService.this.fileuploadModel.isIsattachmentinbotresponce()) {
                    data = new Gson().toJson(MyForeGroundService.this.fileuploadModels, MyForeGroundService.this.fileuploadType);
                    HippoLog.e(TAG, "In response else case " + data);
                    Prefs.with((Context)MyForeGroundService.this).save("pref_upload_data", data);
                    MyForeGroundService.this.fileuploadModel = MyForeGroundService.this.fileuploadModels.get(0);
                    Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                    mIntent.putExtra("broadcast_status", 0);
                    mIntent.putExtra("muid", MyForeGroundService.this.fileuploadModel.getMuid());
                    mIntent.putExtra("messageIndex", MyForeGroundService.this.fileuploadModel.getMessageIndex());
                    mIntent.putExtra("image_url", image_url);
                    mIntent.putExtra("thumbnail_url", thumbnail_url);
                    mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModel));
                    LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                    MyForeGroundService.this.updatePref();
                } else if (MyForeGroundService.this.fileuploadModels.get(0).getChannelId().intValue() < 1) {
                    Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                    mIntent.putExtra("broadcast_status", 4);
                    mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModels.get(0)));
                    LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                    MyForeGroundService.this.updatePref();
                } else {
                    data = new Gson().toJson(MyForeGroundService.this.fileuploadModels, MyForeGroundService.this.fileuploadType);
                    HippoLog.e(TAG, "In response else case " + data);
                    Prefs.with((Context)MyForeGroundService.this).save("pref_upload_data", data);
                    MyForeGroundService.this.fileuploadModel = MyForeGroundService.this.fileuploadModels.get(0);
                    if (MyForeGroundService.this.isOpenedChatActivityMsg(MyForeGroundService.this.fileuploadModel.getChannelId())) {
                        Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                        mIntent.putExtra("broadcast_status", 0);
                        mIntent.putExtra("channelId", (Serializable)MyForeGroundService.this.fileuploadModel.getChannelId());
                        mIntent.putExtra("muid", MyForeGroundService.this.fileuploadModel.getMuid());
                        mIntent.putExtra("messageIndex", MyForeGroundService.this.fileuploadModel.getMessageIndex());
                        mIntent.putExtra("image_url", image_url);
                        mIntent.putExtra("thumbnail_url", thumbnail_url);
                        mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)MyForeGroundService.this.fileuploadModel));
                        LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                        MyForeGroundService.this.updatePref();
                    } else {
                        MyForeGroundService.this.updateLocalMessageObj(MyForeGroundService.this.fileuploadModel.getChannelId(), false, image_url, thumbnail_url, jsonObject, new UpdateLocalMsgListener(){

                            @Override
                            public void onUpdation(JSONObject jsonObject) {
                                MyForeGroundService.this.apiInProgress = false;
                                MyForeGroundService.this.getClient(MyForeGroundService.this.fileuploadModel.getChannelId(), jsonObject);
                            }
                        });
                    }
                }
            }

            @Override
            public void failureUpload(Throwable throwable) {
            }
        }).execute(new String[0]);
    }

    private void handleException() {
        this.handleException(false, "");
    }

    private void handleException(boolean isFileNotsupported, String errorMessage) {
        Log.e((String)TAG, (String)"In handleException failure");
        try {
            String data = Prefs.with((Context)this).getString("pref_upload_data", "");
            Log.e((String)TAG, (String)("In response else case " + data));
            this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
            if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).remove("pref_upload_data");
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
                return;
            }
            this.fileuploadModel = this.fileuploadModels.get(0);
            this.apiInProgress = false;
            if (isFileNotsupported) {
                Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                mIntent.putExtra("broadcast_status", 5);
                mIntent.putExtra("channelId", (Serializable)this.fileuploadModel.getChannelId());
                mIntent.putExtra("muid", this.fileuploadModel.getMuid());
                mIntent.putExtra("messageIndex", this.fileuploadModel.getMessageIndex());
                mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)this.fileuploadModel));
                mIntent.putExtra("errorMessage", errorMessage);
                LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                Prefs.with((Context)this).removeAll();
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
            } else if (this.isOpenedChatActivityMsg(this.fileuploadModel.getChannelId())) {
                this.setMessageExpired();
                Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
                mIntent.putExtra("channelId", (Serializable)this.fileuploadModel.getChannelId());
                mIntent.putExtra("muid", this.fileuploadModel.getMuid());
                mIntent.putExtra("messageIndex", this.fileuploadModel.getMessageIndex());
                mIntent.putExtra("fileuploadModel", new Gson().toJson((Object)this.fileuploadModel));
                mIntent.putExtra("broadcast_status", 1);
                LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
            } else {
                this.uploadingFailed(this.fileuploadModel.getChannelId());
                this.setMessageExpired();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    public String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (type != null) {
            return type;
        }
        if (extension.contains("html")) {
            return "text/html";
        }
        if (extension.contains("jsp")) {
            return "application/json";
        }
        if (extension.contains("aspx")) {
            return "application/xml";
        }
        if (extension.contains("php")) {
            return "text/php";
        }
        return extension;
    }

    private void updatePref() {
        HippoLog.e(TAG, "updatePref: " + Prefs.with((Context)this).getString("pref_upload_data", ""));
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            this.fileuploadModels.remove(0);
            String data = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            Prefs.with((Context)this).save("pref_upload_data", data);
            HippoLog.e(TAG, "int updatePref set data : " + data);
            if (this.fileuploadModels.size() == 0) {
                Prefs.with((Context)this).remove("pref_upload_data");
                this.stopFayeClient();
                this.stopForeground(true);
                this.stopSelf();
            } else {
                this.apiInProgress = false;
                this.uploadFileServerCall();
            }
        }
    }

    @Override
    public void onProgressUpdate(int percentage, int mMessageIndex, String muid) {
        if (this.isFirstTime && percentage == 10) {
            this.isFirstTime = false;
            return;
        }
        if (!this.isFirstTime && percentage == 10) {
            this.isFirstTime = true;
        }
        if (this.isFirstTime) {
            this.updateProgress(percentage, 100);
        }
    }

    @Override
    public void onError(int percentage, int mMessageIndex, String muid) {
        HippoLog.e(TAG, "In onError else 2");
    }

    @Override
    public void onFinish(int percentage, int mMessageIndex, String muid) {
        HippoLog.e(TAG, "In onFinish else 2");
    }

    private void getClient(Long channelId, JSONObject messageJson) {
        ConnectionManager.INSTANCE.initFayeConnection();
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        for (FileuploadModel fileuploadModel : fileuploadModels) {
            if (!fileuploadModel.isFileUploaded()) continue;
            ConnectionManager.INSTANCE.subScribeChannel("/" + String.valueOf(fileuploadModel.getChannelId()));
            ConnectionManager.INSTANCE.publish("/" + String.valueOf(fileuploadModel.getChannelId()), fileuploadModel.getMessageObject());
            break;
        }
        this.afterSetUpFayeConnection(channelId, messageJson);
    }

    private void afterSetUpFayeConnection(Long channelId, JSONObject messageJson) {
        if (this.isNetworkAvailable() && ConnectionManager.INSTANCE.isConnected()) {
            HippoLog.e(TAG, "************publish*********");
            ConnectionManager.INSTANCE.publish("/" + String.valueOf(channelId), messageJson);
            this.updatePref();
        } else if (!this.isNetworkAvailable()) {
            Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
            mIntent.putExtra("broadcast_status", 0);
            LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
            this.updatePref();
        }
    }

    public void onDisconnectedServer() {
    }

    public void onReceivedMessage(String msg, String channel) {
        try {
            JSONObject messageJson = new JSONObject(msg);
            if (messageJson.optInt("message_type", 0) == 10 || messageJson.optInt("message_type", 0) == 11) {
                String value = channel.replace("/", "");
                if (!this.isOpenedChatActivityMsg(Long.parseLong(value))) {
                    this.updateLocalMessageObj(Long.parseLong(value), true, "", "", null, null);
                }
                this.updatePref();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onWebSocketError() {
    }

    public void onErrorReceived() {
    }

    private boolean isOpenedChatActivityMsg(Long channelId) {
        ActivityManager mngr = (ActivityManager)this.getSystemService("activity");
        List taskList = mngr.getRunningTasks(10);
        return ((ActivityManager.RunningTaskInfo)taskList.get((int)0)).topActivity.getClassName().equals("com.hippo.activity.FuguChatActivity") && FuguChatActivity.currentChannelId.compareTo(channelId) == 0;
    }

    private void uploadingFailed(long channelId) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (data.equals("empty")) {
            this.apiInProgress = false;
            Log.v((String)TAG, (String)("data = " + data));
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        listItem.setUploadStatus(0);
        listItem.setIsMessageExpired(1);
        unsentMessages.put(fileuploadModel.getMuid(), listItem);
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
    }

    private void setAllMessageExpired() {
        this.fileuploadModels = (ArrayList)new Gson().fromJson(Prefs.with((Context)this).getString("pref_upload_data", ""), this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            for (FileuploadModel fileuploadModel : this.fileuploadModels) {
                if (this.isOpenedChatActivityMsg(fileuploadModel.getChannelId())) {
                    this.sendLocalBroadcast(fileuploadModel);
                    continue;
                }
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.clear();
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        }
    }

    private void setMessageExpired() {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "");
        HippoLog.e(TAG, "In setMessageExpired: " + data);
        this.fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        if (this.fileuploadModels == null || this.fileuploadModels.size() == 0) {
            Prefs.with((Context)this).remove("pref_upload_data");
            this.stopFayeClient();
            this.stopForeground(true);
            this.stopSelf();
        } else {
            if (this.isOpenedChatActivityMsg(this.fileuploadModels.get(0).getChannelId())) {
                this.sendLocalBroadcast(this.fileuploadModels.get(0));
            } else {
                this.updateLocalMessages(this.fileuploadModels.get(0));
            }
            this.fileuploadModels.remove(0);
            data = new Gson().toJson(this.fileuploadModels, this.fileuploadType);
            HippoLog.e(TAG, "In setMessageExpired after update: " + data);
            Prefs.with((Context)this).save("pref_upload_data", data);
            this.uploadFileServerCall();
        }
    }

    private void sendLocalBroadcast(FileuploadModel fileuploadModel) {
        Intent mIntent = new Intent("HIPPO_FILE_UPLOAD");
        mIntent.putExtra("muid", fileuploadModel.getMuid());
        mIntent.putExtra("messageIndex", fileuploadModel.getMessageIndex());
        mIntent.putExtra("broadcast_status", 3);
        LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
    }

    private void updateLocalMessageObj(Long channelId, boolean isPublished, String url, String thumbnailUrl, JSONObject jsonObject, UpdateLocalMsgListener msgListener) {
        String data = Prefs.with((Context)this).getString("pref_upload_data", "empty");
        if (data.equals("empty")) {
            this.apiInProgress = false;
            HippoLog.v(TAG, "data = " + data);
            return;
        }
        ArrayList fileuploadModels = (ArrayList)new Gson().fromJson(data, this.fileuploadType);
        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
        if (index == -1) {
            return;
        }
        FileuploadModel fileuploadModel = (FileuploadModel)fileuploadModels.get(index);
        LinkedHashMap<String, Message> sentMessages = CommonData.getSentMessageByChannel(channelId);
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        Message listItem = unsentMessages.get(fileuploadModel.getMuid());
        if (listItem == null) {
            return;
        }
        if (isPublished) {
            listItem.setMessageStatus(1);
            ArrayList<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
            Collections.reverse(reverseOrderedKeys);
            String tempSentAtUTC = "";
            for (String key : reverseOrderedKeys) {
                if (!sentMessages.get(key).isDateView()) continue;
                tempSentAtUTC = key;
                break;
            }
            String time = listItem.getSentAtUtc();
            String localDate = DateUtils.getInstance().convertToLocal(time, this.inputFormat, this.outputFormat);
            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                sentMessages.put(localDate, new Message(localDate, true));
            }
            sentMessages.put(fileuploadModel.getMuid(), listItem);
            unsentMessages.remove(fileuploadModel.getMuid());
            unsentMessageMapNew.remove(fileuploadModel.getMuid());
            CommonData.setSentMessageByChannel(channelId, sentMessages);
        } else {
            Message message = listItem;
            message.setFileUrl(url);
            message.setUrl(url);
            message.setThumbnailUrl(thumbnailUrl);
            message.setUploadStatus(3);
            unsentMessages.put(fileuploadModel.getMuid(), message);
            JSONObject object = null;
            try {
                object = unsentMessageMapNew.get(fileuploadModel.getMuid());
                object.put("image_url", (Object)url);
                object.put("thumbnail_url", (Object)thumbnailUrl);
                object.put("url", (Object)url);
                unsentMessageMapNew.put(fileuploadModel.getMuid(), object);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
        if (msgListener != null) {
            msgListener.onUpdation(jsonObject);
        }
    }

    private void updateLocalMessages(FileuploadModel fileuploadModel) {
        String muid = fileuploadModel.getMuid();
        LinkedHashMap<String, Message> unsentMessages = CommonData.getUnsentMessageByChannel(fileuploadModel.getChannelId());
        LinkedHashMap<String, JSONObject> unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(fileuploadModel.getChannelId());
        if (unsentMessages == null) {
            unsentMessages = new LinkedHashMap();
        }
        unsentMessages.get(muid).setIsMessageExpired(1);
        try {
            JSONObject messageJson = unsentMessageMapNew.get(muid);
            messageJson.put("is_message_expired", 1);
            unsentMessageMapNew.put(muid, messageJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommonData.setUnsentMessageByChannel(fileuploadModel.getChannelId(), unsentMessages);
        CommonData.setUnsentMessageMapByChannel(fileuploadModel.getChannelId(), unsentMessageMapNew);
    }

    public static interface UpdateLocalMsgListener {
        public void onUpdation(JSONObject var1);
    }
}

