/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.Directory;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import java.util.ArrayList;

public class ImageDirectoryAdapter
extends BaseAdapter<Directory, ViewHolder> {
    private static final int COLUMN_NUMBER = 2;

    public ImageDirectoryAdapter(Context ctx) {
        this(ctx, new ArrayList<Directory>());
    }

    public ImageDirectoryAdapter(Context ctx, ArrayList<Directory> directories) {
        super(ctx, directories);
    }

    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_image_pick, parent, false);
        ViewGroup.LayoutParams params = itemView.getLayoutParams();
        if (params != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            int width = wm.getDefaultDisplay().getWidth();
            params.height = width / 2;
        }
        return new ViewHolder(itemView);
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, int position) {
        holder.mIvThumbnail.setVisibility(0);
        holder.folderInfo.setVisibility(0);
        if (((Directory)this.mList.get(position)).getFiles().get(0) instanceof ImageFile) {
            ImageFile file = (ImageFile)((Directory)this.mList.get(position)).getFiles().get(0);
            RequestOptions options = new RequestOptions();
            Glide.with((Context)this.mContext).load(file.getPath()).apply(options.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(holder.mIvThumbnail);
        } else {
            VideoFile file = (VideoFile)((Directory)this.mList.get(position)).getFiles().get(0);
            RequestOptions options = new RequestOptions();
            Glide.with((Context)this.mContext).load(file.getPath()).apply(options.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(holder.mIvThumbnail);
        }
        holder.mIvThumbnail.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageDirectoryAdapter.this.mListener != null) {
                    ImageDirectoryAdapter.this.mListener.OnSelectStateChanged(true, (Directory)ImageDirectoryAdapter.this.mList.get(holder.getAdapterPosition()));
                }
            }
        });
        holder.totalCount.setText((CharSequence)("" + ((Directory)this.mList.get(position)).getFiles().size()));
        holder.directoryName.setText((CharSequence)((Directory)this.mList.get(position)).getName());
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvThumbnail;
        private RelativeLayout folderInfo;
        private TextView totalCount;
        private TextView directoryName;

        public ViewHolder(View itemView) {
            super(itemView);
            this.mIvThumbnail = (ImageView)itemView.findViewById(R.id.iv_thumbnail);
            this.folderInfo = (RelativeLayout)itemView.findViewById(R.id.folder_info);
            this.totalCount = (TextView)itemView.findViewById(R.id.total_count);
            this.directoryName = (TextView)itemView.findViewById(R.id.directory_name);
        }
    }
}

