/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.hippo.R;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import java.util.ArrayList;

public class NormalFilePickAdapter
extends BaseAdapter<NormalFile, NormalFilePickViewHolder> {
    protected Context mContext;

    public NormalFilePickAdapter(Context ctx, int max) {
        this(ctx, new ArrayList<NormalFile>(), max);
    }

    public NormalFilePickAdapter(Context ctx, ArrayList<NormalFile> list, int max) {
        super(ctx, list);
        this.mContext = ctx;
    }

    public NormalFilePickViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_normal_file_pick, parent, false);
        return new NormalFilePickViewHolder(itemView);
    }

    public void onBindViewHolder(final NormalFilePickViewHolder holder, int position) {
        holder.mCbx.setVisibility(8);
        if (position == 0) {
            holder.mTvTitle.setText(R.string.hippo_browse_other_doc);
            holder.mIvIcon.setImageResource(R.drawable.hippo_ic_storage);
            holder.mTvTitle.setLines(1);
        } else {
            NormalFile file = (NormalFile)this.mList.get(position - 1);
            holder.mTvTitle.setText((CharSequence)Util.extractFileNameWithSuffix(file.getPath()));
            holder.mTvTitle.measure(0, 0);
            if (holder.mTvTitle.getMeasuredWidth() > Util.getScreenWidth(this.mContext) - Util.dip2px(this.mContext, 120.0f)) {
                holder.mTvTitle.setLines(2);
            } else {
                holder.mTvTitle.setLines(1);
            }
            if (file.getPath().toLowerCase().endsWith("xls") || file.getPath().toLowerCase().endsWith("xlsx")) {
                holder.mIvIcon.setImageResource(R.drawable.vw_ic_excel);
            } else if (file.getPath().toLowerCase().endsWith("doc") || file.getPath().toLowerCase().endsWith("docx")) {
                holder.mIvIcon.setImageResource(R.drawable.vw_ic_word);
            } else if (file.getPath().toLowerCase().endsWith("ppt") || file.getPath().endsWith("pptx")) {
                holder.mIvIcon.setImageResource(R.drawable.vw_ic_ppt);
            } else if (file.getPath().toLowerCase().endsWith("pdf")) {
                holder.mIvIcon.setImageResource(R.drawable.vw_ic_pdf);
            } else if (file.getPath().toLowerCase().endsWith("txt")) {
                holder.mIvIcon.setImageResource(R.drawable.vw_ic_txt);
            } else {
                holder.mIvIcon.setImageResource(R.drawable.vw_ic_file);
            }
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int index = holder.getAdapterPosition();
                if (index == 0) {
                    if (NormalFilePickAdapter.this.mListener != null) {
                        NormalFilePickAdapter.this.mListener.OnSelectStateChanged(true, null);
                    }
                } else {
                    ((NormalFile)NormalFilePickAdapter.this.mList.get(holder.getAdapterPosition())).setSelected(holder.mCbx.isSelected());
                    if (NormalFilePickAdapter.this.mListener != null) {
                        NormalFilePickAdapter.this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), (NormalFile)NormalFilePickAdapter.this.mList.get(holder.getAdapterPosition() - 1));
                    }
                }
            }
        });
    }

    public int getItemCount() {
        return this.mList.size() + 1;
    }

    public Bitmap writeOnDrawable(int drawableId, String text) {
        Bitmap bm = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)drawableId).copy(Bitmap.Config.ARGB_8888, true);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-16777216);
        paint.setTextSize(20.0f);
        Canvas canvas = new Canvas(bm);
        canvas.drawText(text, 0.0f, (float)(bm.getHeight() / 2), paint);
        return bm;
    }

    class NormalFilePickViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvIcon;
        private TextView mTvTitle;
        private ImageView mCbx;

        public NormalFilePickViewHolder(View itemView) {
            super(itemView);
            this.mIvIcon = (ImageView)itemView.findViewById(R.id.ic_file);
            this.mTvTitle = (TextView)itemView.findViewById(R.id.tv_file_title);
            this.mCbx = (ImageView)itemView.findViewById(R.id.cbx);
        }
    }
}

