/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker.adapter;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hippo.R;
import com.hippo.utils.filepicker.ToastUtil;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.filepicker.adapter.BaseAdapter;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class VideoPickAdapter
extends BaseAdapter<VideoFile, VideoPickViewHolder> {
    private boolean isNeedCamera;
    public String mVideoPath;
    private static final int COLUMN_NUMBER = 3;

    public VideoPickAdapter(Context ctx, boolean needCamera) {
        this(ctx, new ArrayList<VideoFile>(), needCamera);
    }

    public VideoPickAdapter(Context ctx, ArrayList<VideoFile> list, boolean needCamera) {
        super(ctx, list);
        this.isNeedCamera = needCamera;
    }

    public VideoPickViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.vw_layout_item_video_pick, parent, false);
        ViewGroup.LayoutParams params = itemView.getLayoutParams();
        if (params != null) {
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            int width = wm.getDefaultDisplay().getWidth();
            params.height = width / 3;
        }
        return new VideoPickViewHolder(itemView);
    }

    public void onBindViewHolder(final VideoPickViewHolder holder, int position) {
        if (this.isNeedCamera && position == 0) {
            holder.mIvCamera.setVisibility(0);
            holder.mIvThumbnail.setVisibility(4);
            holder.mCbx.setVisibility(4);
            holder.mShadow.setVisibility(4);
            holder.mDurationLayout.setVisibility(4);
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                    String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
                    File file = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM).getAbsolutePath() + "/VID_" + timeStamp + ".mp4");
                    VideoPickAdapter.this.mVideoPath = file.getAbsolutePath();
                    ContentValues contentValues = new ContentValues(1);
                    contentValues.put("_data", VideoPickAdapter.this.mVideoPath);
                    Uri uri = VideoPickAdapter.this.mContext.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                    intent.putExtra("output", (Parcelable)uri);
                    intent.putExtra("android.intent.extra.videoQuality", 1);
                    if (Util.detectIntent(VideoPickAdapter.this.mContext, intent)) {
                        ((Activity)VideoPickAdapter.this.mContext).startActivityForResult(intent, 513);
                    } else {
                        ToastUtil.getInstance(VideoPickAdapter.this.mContext).showToast(VideoPickAdapter.this.mContext.getString(R.string.vw_no_video_app));
                    }
                }
            });
        } else {
            holder.mIvCamera.setVisibility(4);
            holder.mIvThumbnail.setVisibility(0);
            holder.mCbx.setVisibility(8);
            holder.mDurationLayout.setVisibility(0);
            VideoFile file = this.isNeedCamera ? (VideoFile)this.mList.get(position - 1) : (VideoFile)this.mList.get(position);
            RequestOptions options = new RequestOptions();
            Glide.with((Context)this.mContext).load(file.getPath()).apply(options.centerCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(holder.mIvThumbnail);
            if (file.isSelected()) {
                holder.mCbx.setSelected(true);
                holder.mShadow.setVisibility(0);
            } else {
                holder.mCbx.setSelected(false);
                holder.mShadow.setVisibility(4);
            }
            holder.mCbx.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    holder.mShadow.setVisibility(0);
                    holder.mCbx.setSelected(true);
                    int index = VideoPickAdapter.this.isNeedCamera ? holder.getAdapterPosition() - 1 : holder.getAdapterPosition();
                    ((VideoFile)VideoPickAdapter.this.mList.get(index)).setSelected(holder.mCbx.isSelected());
                    if (VideoPickAdapter.this.mListener != null) {
                        VideoPickAdapter.this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), (VideoFile)VideoPickAdapter.this.mList.get(index));
                    }
                }
            });
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    holder.mShadow.setVisibility(0);
                    holder.mCbx.setSelected(true);
                    int index = VideoPickAdapter.this.isNeedCamera ? holder.getAdapterPosition() - 1 : holder.getAdapterPosition();
                    ((VideoFile)VideoPickAdapter.this.mList.get(index)).setSelected(holder.mCbx.isSelected());
                    if (VideoPickAdapter.this.mListener != null) {
                        VideoPickAdapter.this.mListener.OnSelectStateChanged(holder.mCbx.isSelected(), (VideoFile)VideoPickAdapter.this.mList.get(index));
                    }
                }
            });
            holder.mDuration.setText((CharSequence)Util.getDurationString(file.getDuration()));
        }
    }

    public int getItemCount() {
        return this.isNeedCamera ? this.mList.size() + 1 : this.mList.size();
    }

    class VideoPickViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView mIvCamera;
        private ImageView mIvThumbnail;
        private View mShadow;
        private ImageView mCbx;
        private TextView mDuration;
        private RelativeLayout mDurationLayout;

        public VideoPickViewHolder(View itemView) {
            super(itemView);
            this.mIvCamera = (ImageView)itemView.findViewById(R.id.iv_camera);
            this.mIvThumbnail = (ImageView)itemView.findViewById(R.id.iv_thumbnail);
            this.mShadow = itemView.findViewById(R.id.shadow);
            this.mCbx = (ImageView)itemView.findViewById(R.id.cbx);
            this.mDuration = (TextView)itemView.findViewById(R.id.txt_duration);
            this.mDurationLayout = (RelativeLayout)itemView.findViewById(R.id.layout_duration);
        }
    }
}

