/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.zoomview;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.view.ScaleGestureDetectorCompat;
import com.hippo.R;
import com.hippo.utils.zoomview.AutoResetMode;

public class ZoomageView
extends AppCompatImageView
implements ScaleGestureDetector.OnScaleGestureListener {
    private static final float MIN_SCALE = 0.6f;
    private static final float MAX_SCALE = 8.0f;
    private final int RESET_DURATION = 200;
    private ImageView.ScaleType startScaleType;
    private Matrix matrix = new Matrix();
    private Matrix startMatrix = new Matrix();
    private float[] matrixValues = new float[9];
    private float[] startValues = null;
    private float minScale = 0.6f;
    private float maxScale = 8.0f;
    private float calculatedMinScale = 0.6f;
    private float calculatedMaxScale = 8.0f;
    private final RectF bounds = new RectF();
    private boolean translatable;
    private boolean zoomable;
    private boolean doubleTapToZoom;
    private boolean restrictBounds;
    private boolean animateOnReset;
    private boolean autoCenter;
    private float doubleTapToZoomScaleFactor;
    private int autoResetMode;
    private PointF last = new PointF(0.0f, 0.0f);
    private float startScale = 1.0f;
    private float scaleBy = 1.0f;
    private float currentScaleFactor = 1.0f;
    private int previousPointerCount = 1;
    private ScaleGestureDetector scaleDetector;
    private GestureDetector gestureDetector;
    private boolean doubleTapDetected = false;
    private boolean singleTapDetected = false;
    private final GestureDetector.OnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (e.getAction() == 1) {
                ZoomageView.this.doubleTapDetected = true;
            }
            return false;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            ZoomageView.this.singleTapDetected = true;
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            ZoomageView.this.singleTapDetected = false;
            return false;
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }
    };

    public ZoomageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public ZoomageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZoomageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.gestureDetector = new GestureDetector(context, this.gestureListener);
        ScaleGestureDetectorCompat.setQuickScaleEnabled((ScaleGestureDetector)this.scaleDetector, (boolean)false);
        this.startScaleType = this.getScaleType();
        TypedArray values = context.obtainStyledAttributes(attrs, R.styleable.HippoZoomageView);
        this.zoomable = values.getBoolean(R.styleable.HippoZoomageView_zoomage_zoomable, true);
        this.translatable = values.getBoolean(R.styleable.HippoZoomageView_zoomage_translatable, true);
        this.animateOnReset = values.getBoolean(R.styleable.HippoZoomageView_zoomage_animateOnReset, true);
        this.autoCenter = values.getBoolean(R.styleable.HippoZoomageView_zoomage_autoCenter, true);
        this.restrictBounds = values.getBoolean(R.styleable.HippoZoomageView_zoomage_restrictBounds, false);
        this.doubleTapToZoom = values.getBoolean(R.styleable.HippoZoomageView_zoomage_doubleTapToZoom, true);
        this.minScale = values.getFloat(R.styleable.HippoZoomageView_zoomage_minScale, 0.6f);
        this.maxScale = values.getFloat(R.styleable.HippoZoomageView_zoomage_maxScale, 8.0f);
        this.doubleTapToZoomScaleFactor = values.getFloat(R.styleable.HippoZoomageView_zoomage_doubleTapToZoomScaleFactor, 3.0f);
        this.autoResetMode = AutoResetMode.Parser.fromInt(values.getInt(R.styleable.HippoZoomageView_zoomage_autoResetMode, 0));
        this.verifyScaleRange();
        values.recycle();
    }

    private void verifyScaleRange() {
        if (this.minScale >= this.maxScale) {
            throw new IllegalStateException("minScale must be less than maxScale");
        }
        if (this.minScale < 0.0f) {
            throw new IllegalStateException("minScale must be greater than 0");
        }
        if (this.maxScale < 0.0f) {
            throw new IllegalStateException("maxScale must be greater than 0");
        }
        if (this.doubleTapToZoomScaleFactor > this.maxScale) {
            this.doubleTapToZoomScaleFactor = this.maxScale;
        }
        if (this.doubleTapToZoomScaleFactor < this.minScale) {
            this.doubleTapToZoomScaleFactor = this.minScale;
        }
    }

    public void setScaleRange(float minScale, float maxScale) {
        this.minScale = minScale;
        this.maxScale = maxScale;
        this.startValues = null;
        this.verifyScaleRange();
    }

    public boolean isTranslatable() {
        return this.translatable;
    }

    public void setTranslatable(boolean translatable) {
        this.translatable = translatable;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean getRestrictBounds() {
        return this.restrictBounds;
    }

    public void setRestrictBounds(boolean restrictBounds) {
        this.restrictBounds = restrictBounds;
    }

    public boolean getAnimateOnReset() {
        return this.animateOnReset;
    }

    public void setAnimateOnReset(boolean animateOnReset) {
        this.animateOnReset = animateOnReset;
    }

    public int getAutoResetMode() {
        return this.autoResetMode;
    }

    public void setAutoResetMode(int autoReset) {
        this.autoResetMode = autoReset;
    }

    public boolean getAutoCenter() {
        return this.autoCenter;
    }

    public void setAutoCenter(boolean autoCenter) {
        this.autoCenter = autoCenter;
    }

    public boolean getDoubleTapToZoom() {
        return this.doubleTapToZoom;
    }

    public void setDoubleTapToZoom(boolean doubleTapToZoom) {
        this.doubleTapToZoom = doubleTapToZoom;
    }

    public float getDoubleTapToZoomScaleFactor() {
        return this.doubleTapToZoomScaleFactor;
    }

    public void setDoubleTapToZoomScaleFactor(float doubleTapToZoomScaleFactor) {
        this.doubleTapToZoomScaleFactor = doubleTapToZoomScaleFactor;
        this.verifyScaleRange();
    }

    public float getCurrentScaleFactor() {
        return this.currentScaleFactor;
    }

    public void setScaleType(@Nullable ImageView.ScaleType scaleType) {
        if (scaleType != null) {
            super.setScaleType(scaleType);
            this.startScaleType = scaleType;
            this.startValues = null;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setScaleType(this.startScaleType);
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.setScaleType(this.startScaleType);
    }

    public void setImageDrawable(@Nullable Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.setScaleType(this.startScaleType);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.setScaleType(this.startScaleType);
    }

    public void setImageURI(@Nullable Uri uri) {
        super.setImageURI(uri);
        this.setScaleType(this.startScaleType);
    }

    private void updateBounds(float[] values) {
        if (this.getDrawable() != null) {
            this.bounds.set(values[2], values[5], (float)this.getDrawable().getIntrinsicWidth() * values[0] + values[2], (float)this.getDrawable().getIntrinsicHeight() * values[4] + values[5]);
        }
    }

    private float getCurrentDisplayedWidth() {
        if (this.getDrawable() != null) {
            return (float)this.getDrawable().getIntrinsicWidth() * this.matrixValues[0];
        }
        return 0.0f;
    }

    private float getCurrentDisplayedHeight() {
        if (this.getDrawable() != null) {
            return (float)this.getDrawable().getIntrinsicHeight() * this.matrixValues[4];
        }
        return 0.0f;
    }

    private void setStartValues() {
        this.startValues = new float[9];
        this.startMatrix = new Matrix(this.getImageMatrix());
        this.startMatrix.getValues(this.startValues);
        this.calculatedMinScale = this.minScale * this.startValues[0];
        this.calculatedMaxScale = this.maxScale * this.startValues[0];
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isClickable() && this.isEnabled() && (this.zoomable || this.translatable)) {
            if (this.getScaleType() != ImageView.ScaleType.MATRIX) {
                super.setScaleType(ImageView.ScaleType.MATRIX);
            }
            if (this.startValues == null) {
                this.setStartValues();
            }
            this.matrix.set(this.getImageMatrix());
            this.matrix.getValues(this.matrixValues);
            this.updateBounds(this.matrixValues);
            this.scaleDetector.onTouchEvent(event);
            this.gestureDetector.onTouchEvent(event);
            if (this.doubleTapToZoom && this.doubleTapDetected) {
                this.doubleTapDetected = false;
                this.singleTapDetected = false;
                if (this.matrixValues[0] != this.startValues[0]) {
                    this.reset();
                } else {
                    Matrix zoomMatrix = new Matrix(this.matrix);
                    zoomMatrix.postScale(this.doubleTapToZoomScaleFactor, this.doubleTapToZoomScaleFactor, this.scaleDetector.getFocusX(), this.scaleDetector.getFocusY());
                    this.animateScaleAndTranslationToMatrix(zoomMatrix, 200);
                }
                return true;
            }
            if (!this.singleTapDetected) {
                if (event.getActionMasked() == 0 || event.getPointerCount() != this.previousPointerCount) {
                    this.last.set(this.scaleDetector.getFocusX(), this.scaleDetector.getFocusY());
                } else if (event.getActionMasked() == 2) {
                    float focusx = this.scaleDetector.getFocusX();
                    float focusy = this.scaleDetector.getFocusY();
                    if (this.translatable) {
                        float xdistance = this.getXDistance(focusx, this.last.x);
                        float ydistance = this.getYDistance(focusy, this.last.y);
                        this.matrix.postTranslate(xdistance, ydistance);
                    }
                    if (this.zoomable) {
                        this.matrix.postScale(this.scaleBy, this.scaleBy, focusx, focusy);
                        this.currentScaleFactor = this.matrixValues[0] / this.startValues[0];
                    }
                    this.setImageMatrix(this.matrix);
                    this.last.set(focusx, focusy);
                }
                if (event.getActionMasked() == 1) {
                    this.scaleBy = 1.0f;
                    this.resetImage();
                }
            }
            this.previousPointerCount = event.getPointerCount();
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void resetImage() {
        switch (this.autoResetMode) {
            case 0: {
                if (this.matrixValues[0] <= this.startValues[0]) {
                    this.reset();
                    break;
                }
                this.center();
                break;
            }
            case 1: {
                if (this.matrixValues[0] >= this.startValues[0]) {
                    this.reset();
                    break;
                }
                this.center();
                break;
            }
            case 2: {
                this.reset();
                break;
            }
            case 3: {
                this.center();
            }
        }
    }

    private void center() {
        if (this.autoCenter) {
            this.animateTranslationX();
            this.animateTranslationY();
        }
    }

    public void reset() {
        this.reset(this.animateOnReset);
    }

    public void reset(boolean animate) {
        if (animate) {
            this.animateToStartMatrix();
        } else {
            this.setImageMatrix(this.startMatrix);
        }
    }

    private void animateToStartMatrix() {
        this.animateScaleAndTranslationToMatrix(this.startMatrix, 200);
    }

    private void animateScaleAndTranslationToMatrix(final Matrix targetMatrix, int duration) {
        float[] targetValues = new float[9];
        targetMatrix.getValues(targetValues);
        final Matrix beginMatrix = new Matrix(this.getImageMatrix());
        beginMatrix.getValues(this.matrixValues);
        final float xsdiff = targetValues[0] - this.matrixValues[0];
        final float ysdiff = targetValues[4] - this.matrixValues[4];
        final float xtdiff = targetValues[2] - this.matrixValues[2];
        final float ytdiff = targetValues[5] - this.matrixValues[5];
        ValueAnimator anim2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        anim2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            final Matrix activeMatrix;
            final float[] values;
            {
                this.activeMatrix = new Matrix(ZoomageView.this.getImageMatrix());
                this.values = new float[9];
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                float val = ((Float)animation.getAnimatedValue()).floatValue();
                this.activeMatrix.set(beginMatrix);
                this.activeMatrix.getValues(this.values);
                this.values[2] = this.values[2] + xtdiff * val;
                this.values[5] = this.values[5] + ytdiff * val;
                this.values[0] = this.values[0] + xsdiff * val;
                this.values[4] = this.values[4] + ysdiff * val;
                this.activeMatrix.setValues(this.values);
                ZoomageView.this.setImageMatrix(this.activeMatrix);
            }
        });
        anim2.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                ZoomageView.this.setImageMatrix(targetMatrix);
            }
        });
        anim2.setDuration((long)duration);
        anim2.start();
    }

    private void animateTranslationX() {
        if (this.getCurrentDisplayedWidth() > (float)this.getWidth()) {
            if (this.bounds.left > 0.0f) {
                this.animateMatrixIndex(2, 0.0f);
            } else if (this.bounds.right < (float)this.getWidth()) {
                this.animateMatrixIndex(2, this.bounds.left + (float)this.getWidth() - this.bounds.right);
            }
        } else if (this.bounds.left < 0.0f) {
            this.animateMatrixIndex(2, 0.0f);
        } else if (this.bounds.right > (float)this.getWidth()) {
            this.animateMatrixIndex(2, this.bounds.left + (float)this.getWidth() - this.bounds.right);
        }
    }

    private void animateTranslationY() {
        if (this.getCurrentDisplayedHeight() > (float)this.getHeight()) {
            if (this.bounds.top > 0.0f) {
                this.animateMatrixIndex(5, 0.0f);
            } else if (this.bounds.bottom < (float)this.getHeight()) {
                this.animateMatrixIndex(5, this.bounds.top + (float)this.getHeight() - this.bounds.bottom);
            }
        } else if (this.bounds.top < 0.0f) {
            this.animateMatrixIndex(5, 0.0f);
        } else if (this.bounds.bottom > (float)this.getHeight()) {
            this.animateMatrixIndex(5, this.bounds.top + (float)this.getHeight() - this.bounds.bottom);
        }
    }

    private void animateMatrixIndex(final int index, float to) {
        ValueAnimator animator2 = ValueAnimator.ofFloat((float[])new float[]{this.matrixValues[index], to});
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            final float[] values = new float[9];
            Matrix current = new Matrix();

            public void onAnimationUpdate(ValueAnimator animation) {
                this.current.set(ZoomageView.this.getImageMatrix());
                this.current.getValues(this.values);
                this.values[index] = ((Float)animation.getAnimatedValue()).floatValue();
                this.current.setValues(this.values);
                ZoomageView.this.setImageMatrix(this.current);
            }
        });
        animator2.setDuration(200L);
        animator2.start();
    }

    private float getXDistance(float toX, float fromX) {
        float xdistance = toX - fromX;
        if (this.restrictBounds) {
            xdistance = this.getRestrictedXDistance(xdistance);
        }
        if (this.bounds.right + xdistance < 0.0f) {
            xdistance = -this.bounds.right;
        } else if (this.bounds.left + xdistance > (float)this.getWidth()) {
            xdistance = (float)this.getWidth() - this.bounds.left;
        }
        return xdistance;
    }

    private float getRestrictedXDistance(float xdistance) {
        float restrictedXDistance = xdistance;
        if (this.getCurrentDisplayedWidth() >= (float)this.getWidth()) {
            if (this.bounds.left <= 0.0f && this.bounds.left + xdistance > 0.0f && !this.scaleDetector.isInProgress()) {
                restrictedXDistance = -this.bounds.left;
            } else if (this.bounds.right >= (float)this.getWidth() && this.bounds.right + xdistance < (float)this.getWidth() && !this.scaleDetector.isInProgress()) {
                restrictedXDistance = (float)this.getWidth() - this.bounds.right;
            }
        } else if (!this.scaleDetector.isInProgress()) {
            if (this.bounds.left >= 0.0f && this.bounds.left + xdistance < 0.0f) {
                restrictedXDistance = -this.bounds.left;
            } else if (this.bounds.right <= (float)this.getWidth() && this.bounds.right + xdistance > (float)this.getWidth()) {
                restrictedXDistance = (float)this.getWidth() - this.bounds.right;
            }
        }
        return restrictedXDistance;
    }

    private float getYDistance(float toY, float fromY) {
        float ydistance = toY - fromY;
        if (this.restrictBounds) {
            ydistance = this.getRestrictedYDistance(ydistance);
        }
        if (this.bounds.bottom + ydistance < 0.0f) {
            ydistance = -this.bounds.bottom;
        } else if (this.bounds.top + ydistance > (float)this.getHeight()) {
            ydistance = (float)this.getHeight() - this.bounds.top;
        }
        return ydistance;
    }

    private float getRestrictedYDistance(float ydistance) {
        float restrictedYDistance = ydistance;
        if (this.getCurrentDisplayedHeight() >= (float)this.getHeight()) {
            if (this.bounds.top <= 0.0f && this.bounds.top + ydistance > 0.0f && !this.scaleDetector.isInProgress()) {
                restrictedYDistance = -this.bounds.top;
            } else if (this.bounds.bottom >= (float)this.getHeight() && this.bounds.bottom + ydistance < (float)this.getHeight() && !this.scaleDetector.isInProgress()) {
                restrictedYDistance = (float)this.getHeight() - this.bounds.bottom;
            }
        } else if (!this.scaleDetector.isInProgress()) {
            if (this.bounds.top >= 0.0f && this.bounds.top + ydistance < 0.0f) {
                restrictedYDistance = -this.bounds.top;
            } else if (this.bounds.bottom <= (float)this.getHeight() && this.bounds.bottom + ydistance > (float)this.getHeight()) {
                restrictedYDistance = (float)this.getHeight() - this.bounds.bottom;
            }
        }
        return restrictedYDistance;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        this.scaleBy = this.startScale * detector.getScaleFactor() / this.matrixValues[0];
        float projectedScale = this.scaleBy * this.matrixValues[0];
        if (projectedScale < this.calculatedMinScale) {
            this.scaleBy = this.calculatedMinScale / this.matrixValues[0];
        } else if (projectedScale > this.calculatedMaxScale) {
            this.scaleBy = this.calculatedMaxScale / this.matrixValues[0];
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.startScale = this.matrixValues[0];
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.scaleBy = 1.0f;
    }

    private class SimpleAnimatorListener
    implements Animator.AnimatorListener {
        private SimpleAnimatorListener() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

