/*
 * Decompiled with CFR 0.152.
 */
package faye;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.hippo.HippoConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguFileDetails;
import com.hippo.utils.DateUtils;
import com.hippo.utils.HippoLog;
import faye.BaseSocketClient;
import faye.ConnectionError;
import faye.FayeAgentListener;
import faye.FayeClientListener;
import faye.FayeServiceListener;
import faye.MetaMessage;
import faye.WebSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.util.Date;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FayeClient
extends BaseSocketClient
implements FuguAppConstant {
    private static final String LOG_TAG = FayeClient.class.getSimpleName();
    private static final String FAYE_LOG = "FAYE_LOG ";
    private WebSocket mWebSocket = null;
    private FayeClientListener mConnectionListener = null;
    private FayeServiceListener serviceListener = null;
    private FayeAgentListener mAgentListener = null;
    private HashSet<String> mChannels;
    private String mServerUrl = "";
    private boolean mFayeConnected = false;
    private boolean mIsConnectedServer = false;
    private MetaMessage mMetaMessage;
    private Handler mMessageHandler;

    public FayeClient(String url, MetaMessage meta) {
        HandlerThread thread = new HandlerThread("FayeHandler");
        thread.start();
        this.mMessageHandler = new Handler(thread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        HippoLog.i(LOG_TAG, "onOpen() executed");
                        HippoLog.w("FAYE_LOG handleMessage", "on_open");
                        FayeClient.this.mIsConnectedServer = true;
                        FayeClient.this.handShake();
                        break;
                    }
                    case 2: {
                        HippoLog.i(LOG_TAG, "onClosed() executed");
                        HippoLog.w("FAYE_LOG handleMessage", "on_close");
                        FayeClient.this.mIsConnectedServer = false;
                        FayeClient.this.mFayeConnected = false;
                        if (FayeClient.this.mAgentListener != null) {
                            FayeClient.this.mAgentListener.onDisconnectedServer(FayeClient.this);
                        }
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onDisconnectedServer(FayeClient.this);
                        break;
                    }
                    case 3: {
                        try {
                            HippoLog.i(LOG_TAG, "onMessage executed");
                            HippoLog.w("FAYE_LOG handleMessage", "on_message " + (String)msg.obj);
                            FayeClient.this.handleFayeMessage((String)msg.obj);
                        }
                        catch (NotYetConnectedException e) {
                            if (!HippoConfig.DEBUG) break;
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 5: {
                        HippoLog.w("FAYE_LOG handleMessage", "on_pong");
                        if (FayeClient.this.mAgentListener != null) {
                            FayeClient.this.mAgentListener.onPongReceived();
                        }
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onPongReceived();
                        break;
                    }
                    case 6: {
                        HippoLog.w("FAYE_LOG handleMessage", "on_not_connected");
                        if (FayeClient.this.mConnectionListener == null) break;
                        FayeClient.this.mConnectionListener.onNotConnected();
                    }
                }
            }
        };
        this.mServerUrl = url;
        HippoLog.e("TAG", "faye url = " + url);
        this.mMetaMessage = meta;
        this.mChannels = new HashSet();
        HippoLog.w("FAYE_LOG initialize", "url=" + url);
    }

    private void sendLocalBroadcast(int status) {
        block3: {
            try {
                if (HippoConfig.getInstance().getContext() != null) {
                    Intent mIntent = new Intent("fugu_listener_null");
                    mIntent.putExtra("status", status);
                    LocalBroadcastManager.getInstance((Context)HippoConfig.getInstance().getContext()).sendBroadcast(mIntent);
                }
            }
            catch (Exception e) {
                if (!HippoConfig.DEBUG) break block3;
                e.printStackTrace();
            }
        }
    }

    public FayeClientListener getmConnectionListener() {
        return this.mConnectionListener;
    }

    @Override
    public void setmConnectionListener(FayeClientListener mConnectionListener) {
        this.mConnectionListener = mConnectionListener;
    }

    public FayeServiceListener getServiceListener() {
        return this.serviceListener;
    }

    public void setServiceListener(FayeServiceListener serviceListener) {
        this.serviceListener = serviceListener;
    }

    public FayeAgentListener getAgentListener() {
        return this.mAgentListener;
    }

    @Override
    public void setAgentListener(FayeAgentListener listener) {
        this.mAgentListener = listener;
    }

    public void addChannel(String channel) {
        this.mChannels.add(channel);
    }

    public HashSet<String> getmChannels() {
        return this.mChannels;
    }

    @Override
    public boolean isConnectedServer() {
        return this.mIsConnectedServer;
    }

    public boolean isFayeConnected() {
        return this.mFayeConnected;
    }

    @Override
    public void connectServer() {
        this.openWebSocketConnection();
    }

    @Override
    public void disconnectServer() {
        for (String channel : this.mChannels) {
            this.unsubscribe(channel);
        }
        this.mChannels.clear();
        this.disconnect();
    }

    @Override
    public void subscribeChannel(String channel) {
        this.mChannels.add(channel);
        this.subscribe(channel);
        HippoLog.v("channel------>>>>>>>>>>--------------", channel);
    }

    public void subscribeToChannels(String ... channels) {
        for (String channel : channels) {
            this.mChannels.add(channel);
            this.subscribe(channel);
        }
    }

    @Override
    public void unsubscribeChannel(String channel) {
        if (this.mChannels.contains(channel)) {
            this.unsubscribe(channel);
            this.mChannels.remove(channel);
        }
    }

    public void unsubscribeChannels(String ... channels) {
        for (String channel : channels) {
            this.unsubscribe(channel);
        }
    }

    @Override
    public void unsubscribeAll() {
        for (String channel : this.mChannels) {
            this.unsubscribe(channel);
        }
    }

    public void publish(String message, int messageType, String url, String thumbnailUrl, FuguFileDetails fileDetails, int notificationType, String uuid, int position, String channel, Long userId, String userName, Long channelId, int isTyping) {
        JSONObject messageJson;
        block10: {
            messageJson = new JSONObject();
            String localDate = DateUtils.getFormattedDate(new Date());
            try {
                if (notificationType == 6) {
                    messageJson.put("notification_type", notificationType);
                    messageJson.put("channel_id", (Object)channelId);
                } else {
                    messageJson.put("full_name", (Object)userName);
                    messageJson.put("message", (Object)message);
                    messageJson.put("message_type", messageType);
                    messageJson.put("date_time", (Object)DateUtils.getInstance().convertToUTC(localDate));
                    if (position == 0) {
                        messageJson.put("message_index", position);
                    } else {
                        messageJson.put("message_index", position);
                    }
                    messageJson.put("UUID", (Object)uuid);
                    if (messageType == 10 && !url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                        messageJson.put("image_url", (Object)url);
                        messageJson.put("thumbnail_url", (Object)thumbnailUrl);
                    }
                    if (messageType == 11 && !url.trim().isEmpty()) {
                        messageJson.put("url", (Object)url);
                        messageJson.put("file_name", (Object)fileDetails.getFileName());
                        messageJson.put("file_size", (Object)fileDetails.getFileSize());
                    }
                    if (messageType == 1) {
                        messageJson.put("is_typing", isTyping);
                    } else {
                        messageJson.put("is_typing", 0);
                    }
                    messageJson.put("message_status", 4);
                }
                messageJson.put("user_id", (Object)String.valueOf(userId));
                messageJson.put("user_type", 1);
            }
            catch (JSONException e) {
                if (!HippoConfig.DEBUG) break block10;
                e.printStackTrace();
            }
        }
        this.publish(channel, messageJson, null, null);
    }

    public void publish(String channel, JSONObject data) {
        this.publish(channel, data, false);
    }

    @Override
    public void publish(String channel, JSONObject data, boolean b) {
        this.publish(channel, data, null, null);
    }

    public void publish(String channel, JSONObject data, String ext, String id2) {
        try {
            HippoLog.e("@@@@@@@@", channel + "%%%%%%%%%%%%%%%%%%%%%%% " + data);
            String publish = this.mMetaMessage.publish(channel, data, ext, id2);
            this.mWebSocket.send(publish);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Build publish message to JSON error" + e);
            this.connectServer();
        }
    }

    public void publish(String channel, JSONObject data, ConnectionError connectionError) {
        block2: {
            try {
                HippoLog.e("@@@@@@@@", "%%%%%%%%%%%%%%%%%%%%%%% " + data);
                String publish = this.mMetaMessage.publish(channel, data, null, null);
                this.mWebSocket.send(publish);
            }
            catch (Exception e) {
                HippoLog.e(LOG_TAG, "Build publish message to JSON error" + e);
                if (connectionError == null) break block2;
                connectionError.onError(data);
            }
        }
    }

    private Socket getSSLWebSocket() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, null, null);
            SSLSocketFactory factory = sslContext.getSocketFactory();
            return factory.createSocket();
        }
        catch (Exception e) {
            if (HippoConfig.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private void openWebSocketConnection() {
        WebSocketImpl.DEBUG = false;
        if (this.mWebSocket != null) {
            this.mWebSocket.close();
        }
        try {
            URI uri = new URI(this.mServerUrl);
            this.mWebSocket = new WebSocket(uri, this.mMessageHandler);
            this.mWebSocket.setConnectionLostTimeout(60);
            HippoLog.e("uri.getScheme()", "==" + uri.getScheme());
            if (uri.getScheme().equals("https") || uri.getScheme().equals("wss")) {
                this.mWebSocket.setSocket(this.getSSLWebSocket());
            }
            this.mWebSocket.connect();
            HippoLog.w("FAYE_LOG openWebSocketConnection", "uri.getScheme()=" + uri.getScheme());
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Server URL error" + e);
        }
    }

    private void closeWebSocketConnection() {
        if (this.mWebSocket != null) {
            this.mWebSocket.close();
            HippoLog.w("FAYE_LOG closeWebSocketConnection", "on_close");
        }
    }

    private void handShake() {
        block2: {
            try {
                String handshake = this.mMetaMessage.handShake();
                this.mWebSocket.send(handshake);
                HippoLog.w("FAYE_LOG handShake", "json = " + handshake);
            }
            catch (Exception e) {
                HippoLog.e(LOG_TAG, "HandShake message error" + e);
                if (this.mConnectionListener == null) break block2;
                this.mConnectionListener.onWebSocketError();
            }
        }
    }

    private void subscribe(String channel) {
        try {
            String subscribe = this.mMetaMessage.subscribe(channel);
            this.mWebSocket.send(subscribe);
            System.out.println(subscribe);
            HippoLog.w("FAYE_LOG subscribe", "json = " + subscribe);
        }
        catch (WebsocketNotConnectedException e) {
            if (this.mConnectionListener != null) {
                this.mConnectionListener.onWebSocketError();
            }
            if (this.mAgentListener != null) {
                this.mAgentListener.onWebSocketError();
            }
            this.mFayeConnected = false;
            if (HippoConfig.DEBUG) {
                e.printStackTrace();
            }
            HippoLog.e(LOG_TAG, "Subscribe message error" + (Object)((Object)e));
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Subscribe message error" + e);
        }
    }

    private void unsubscribe(String channel) {
        try {
            String unsubscribe = this.mMetaMessage.unsubscribe(channel);
            this.mWebSocket.send(unsubscribe);
            HippoLog.i(LOG_TAG, "UnSubscribe:" + channel);
            HippoLog.w("FAYE_LOG unsubscribe", "json = " + unsubscribe);
        }
        catch (Exception e) {
            if (HippoConfig.DEBUG) {
                e.printStackTrace();
            }
            HippoLog.e(LOG_TAG, "Unsubscribe message error: " + e);
        }
    }

    private void connect() {
        try {
            String connect = this.mMetaMessage.connect();
            this.mWebSocket.send(connect);
            this.mWebSocket.setConnectionLostTimeout(10);
            HippoLog.w("FAYE_LOG connect", "json = " + connect);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Connect message error" + e);
        }
    }

    private void disconnect() {
        try {
            String disconnect = this.mMetaMessage.disconnect();
            this.mWebSocket.send(disconnect);
            HippoLog.w("FAYE_LOG disconnect", "json = " + disconnect);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Disconnect message error" + e);
        }
    }

    public boolean hasSubscribed(String s) {
        return !this.mChannels.contains(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleFayeMessage(String message) {
        HippoLog.v("handleFayeMessage", "handleFayeMessage = " + message);
        JSONArray arr = null;
        try {
            arr = new JSONArray(message);
        }
        catch (Exception e) {
            HippoLog.e(LOG_TAG, "Unknown message type: " + message + e);
        }
        int length = arr.length();
        for (int i = 0; i < length; ++i) {
            JSONObject obj = arr.optJSONObject(i);
            if (obj == null) continue;
            String channel = obj.optString("channel");
            boolean successful = obj.optBoolean("successful");
            if (channel.equals("/meta/handshake")) {
                if (successful) {
                    this.mMetaMessage.setClient(obj.optString("clientId"));
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onConnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onConnectedServer(this);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onConnectedServer(this);
                    }
                    this.connect();
                    return;
                } else {
                    HippoLog.e(LOG_TAG, "Handshake Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/connect")) {
                if (successful) {
                    this.mFayeConnected = true;
                    this.connect();
                    return;
                } else {
                    String errorCode = obj.optString("error", "");
                    if (this.mConnectionListener != null && errorCode.contains("401:")) {
                        this.mConnectionListener.onSubscriptionError();
                        HippoLog.e(LOG_TAG, "Connecting Error with listener: " + obj.toString());
                        return;
                    } else {
                        HippoLog.e(LOG_TAG, "Connecting Error: " + obj.toString());
                    }
                }
                return;
            }
            if (channel.equals("/meta/disconnect")) {
                if (successful) {
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onDisconnectedServer(this);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onDisconnectedServer(this);
                    }
                    if (this.serviceListener != null) {
                        this.serviceListener.onDisconnectedServer(this);
                    }
                    this.mFayeConnected = false;
                    this.closeWebSocketConnection();
                    return;
                } else {
                    HippoLog.e(LOG_TAG, "Disconnecting Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/subscribe")) {
                String subscription = obj.optString("subscription");
                if (successful) {
                    this.mFayeConnected = true;
                    HippoLog.i(LOG_TAG, "Subscribed channel " + subscription);
                    return;
                } else {
                    HippoLog.e(LOG_TAG, "Subscribing channel " + subscription + " Error: " + obj.toString());
                }
                return;
            }
            if (channel.equals("/meta/unsubscribe")) {
                String subscription = obj.optString("subscription");
                if (successful) {
                    HippoLog.i(LOG_TAG, "Unsubscribed channel " + subscription);
                    return;
                } else {
                    HippoLog.e(LOG_TAG, "Unsubscribing channel " + subscription + " Error: " + obj.toString());
                }
                return;
            }
            if (this.mChannels.contains(channel)) {
                String data = obj.optString("data", null);
                HippoLog.e("data", "data in faye = " + data);
                if (data != null) {
                    if (this.mConnectionListener != null) {
                        this.mConnectionListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.mAgentListener != null) {
                        this.mAgentListener.onReceivedMessage(this, data, channel);
                    }
                    if (this.serviceListener == null) return;
                    this.serviceListener.onReceivedMessage(this, data, channel);
                    return;
                } else {
                    try {
                        if (!obj.has("error")) return;
                        if (this.serviceListener != null) {
                            this.serviceListener.onErrorReceived(this, obj.getString("error"), channel);
                        }
                        if (this.mConnectionListener == null) return;
                        this.mConnectionListener.onErrorReceived(this, obj.getString("error"), channel);
                        return;
                    }
                    catch (JSONException e) {
                        if (!HippoConfig.DEBUG) return;
                        e.printStackTrace();
                    }
                }
                return;
            }
            HippoLog.e(LOG_TAG, "Cannot handle this message: " + obj.toString());
            String data = obj.optString("data", null);
            if (data != null) {
                if (this.mConnectionListener != null) {
                    this.mConnectionListener.onReceivedMessage(this, data, channel);
                }
                if (this.mAgentListener != null) {
                    this.mAgentListener.onReceivedMessage(this, data, channel);
                }
                if (this.serviceListener != null) {
                    this.serviceListener.onReceivedMessage(this, data, channel);
                }
            }
            try {
                if (!obj.has("error")) return;
                if (this.serviceListener != null) {
                    this.serviceListener.onErrorReceived(this, obj.getString("error"), channel);
                }
                if (this.mConnectionListener == null) return;
                this.mConnectionListener.onErrorReceived(this, obj.getString("error"), channel);
                return;
            }
            catch (JSONException e) {
                if (!HippoConfig.DEBUG) return;
                e.printStackTrace();
            }
            return;
        }
    }

    @Override
    public boolean isOpened() {
        return this.mWebSocket != null && this.mWebSocket.isOpen() && this.mWebSocket.getSocket().isConnected();
    }

    @Override
    public void updateLang(@NotNull String lang) {
    }
}

