/*
 * Decompiled with CFR 0.152.
 */
package socket.io.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;
import okhttp3.WebSocket;
import socket.io.client.Manager;
import socket.io.client.Socket;
import socket.io.client.Url;

public class IO {
    private static final Logger logger = Logger.getLogger(IO.class.getName());
    private static final ConcurrentHashMap<String, Manager> managers = new ConcurrentHashMap();
    public static int protocol = 4;

    public static void setDefaultOkHttpWebSocketFactory(WebSocket.Factory factory) {
        Manager.defaultWebSocketFactory = factory;
    }

    public static void setDefaultOkHttpCallFactory(Call.Factory factory) {
        Manager.defaultCallFactory = factory;
    }

    private IO() {
    }

    public static Socket socket(String uri) throws URISyntaxException {
        return IO.socket(uri, null);
    }

    public static Socket socket(String uri, Options opts) throws URISyntaxException {
        return IO.socket(new URI(uri), opts);
    }

    public static Socket socket(URI uri) {
        return IO.socket(uri, null);
    }

    public static Socket socket(URI uri, Options opts) {
        Manager io;
        boolean newConnection;
        URI source;
        if (opts == null) {
            opts = new Options();
        }
        URL parsed = Url.parse(uri);
        try {
            source = parsed.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String id2 = Url.extractId(parsed);
        String path = parsed.getPath();
        boolean sameNamespace = managers.containsKey(id2) && IO.managers.get((Object)id2).nsps.containsKey(path);
        boolean bl = newConnection = opts.forceNew || !opts.multiplex || sameNamespace;
        if (newConnection) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("ignoring socket cache for %s", source));
            }
            io = new Manager(source, opts);
        } else {
            if (!managers.containsKey(id2)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(String.format("new io instance for %s", source));
                }
                managers.putIfAbsent(id2, new Manager(source, opts));
            }
            io = managers.get(id2);
        }
        String query = parsed.getQuery();
        if (query != null && (opts.query == null || opts.query.isEmpty())) {
            opts.query = query;
        }
        return io.socket(parsed.getPath(), opts);
    }

    public static class Options
    extends Manager.Options {
        public boolean forceNew;
        public boolean multiplex = true;
    }
}

