/*
 * Decompiled with CFR 0.152.
 */
package io.hkhc.log.internal;

import io.hkhc.log.MetaTag;
import io.hkhc.log.providers.SimpleMetaTag;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u0012\u0010\u0011\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lio/hkhc/log/internal/TagMaker;", "", "()V", "mMetaTag", "", "metaTag", "getMetaTag", "()Ljava/lang/String;", "value", "Lio/hkhc/log/MetaTag;", "metaTagPolicy", "getMetaTagPolicy", "()Lio/hkhc/log/MetaTag;", "setMetaTagPolicy", "(Lio/hkhc/log/MetaTag;)V", "getClassNameAbbr", "className", "getLogTag", "clazz", "Ljava/lang/Class;", "getPackageNameAbbr", "packageName", "ihlog"})
public final class TagMaker {
    @NotNull
    private static MetaTag metaTagPolicy;
    private static String mMetaTag;
    @NotNull
    public static final TagMaker INSTANCE;

    @NotNull
    public final MetaTag getMetaTagPolicy() {
        return metaTagPolicy;
    }

    public final void setMetaTagPolicy(@NotNull MetaTag value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        metaTagPolicy = value;
        mMetaTag = metaTagPolicy.getTag();
    }

    @NotNull
    public final String getMetaTag() {
        return mMetaTag;
    }

    @NotNull
    public final String getPackageNameAbbr(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        StringBuilder builder = new StringBuilder();
        StringTokenizer token = new StringTokenizer(packageName, ".");
        while (token.hasMoreTokens()) {
            String t = token.nextToken();
            char c = t.charAt(0);
            boolean bl = false;
            char c2 = c;
            boolean bl2 = false;
            builder.append(Character.toUpperCase(c2));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String getClassNameAbbr(@NotNull String className) {
        String string;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String name = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)StringsKt.substringAfterLast$default((String)className, (String)".", null, (int)2, null), (String)"$Companion", null, (int)2, null), (String)"$$", null, (int)2, null);
        StringBuilder longBuilder = new StringBuilder();
        StringBuilder shortBuilder = new StringBuilder();
        String string2 = name;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = string3.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        char[] nameArray = cArray;
        char c = nameArray[0];
        bl = false;
        char c2 = c;
        int n = 0;
        nameArray[0] = Character.toUpperCase(c2);
        boolean isLastCap = false;
        int shortGroup = 0;
        for (char c3 : nameArray) {
            boolean isCap;
            boolean bl2 = isCap = Character.isUpperCase(c3) || Character.isDigit(c3);
            if (isCap) {
                longBuilder.append(c3);
            }
            if (shortGroup <= 2) {
                if (isCap) {
                    shortBuilder.append(c3);
                    ++shortGroup;
                } else if (isLastCap) {
                    shortBuilder.append(c3);
                }
            }
            isLastCap = isCap;
        }
        if (shortGroup > 2) {
            String string4 = longBuilder.toString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"longBuilder.toString()");
        } else {
            String string5 = shortBuilder.toString();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"shortBuilder.toString()");
        }
        return string;
    }

    @NotNull
    public final String getLogTag(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String delimiter = Intrinsics.areEqual((Object)this.getMetaTag(), (Object)"") ? "" : "_";
        StringBuilder stringBuilder = new StringBuilder().append(this.getMetaTag()).append(delimiter);
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
        return stringBuilder.append(this.getClassNameAbbr(string)).toString();
    }

    private TagMaker() {
    }

    static {
        TagMaker tagMaker;
        INSTANCE = tagMaker = new TagMaker();
        metaTagPolicy = new SimpleMetaTag("");
        mMetaTag = "";
    }
}

