/*
 * Decompiled with CFR 0.152.
 */
package io.hkhc.log.providers;

import io.hkhc.log.AbstractIHLog;
import io.hkhc.log.IHLog;
import io.hkhc.log.IHLogProvider;
import io.hkhc.log.Priority;
import io.hkhc.log.SystemTimeSource;
import io.hkhc.log.TimeSource;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\tR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/hkhc/log/providers/PrintWriterLogProvider;", "Lio/hkhc/log/IHLogProvider;", "writer", "Ljava/io/Writer;", "(Ljava/io/Writer;)V", "timeSource", "Lio/hkhc/log/TimeSource;", "(Ljava/io/Writer;Lio/hkhc/log/TimeSource;)V", "printWriter", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;Lio/hkhc/log/TimeSource;)V", "getLog", "Lio/hkhc/log/IHLog;", "defaultTag", "", "getLogWriter", "PrintWriterLog", "ihlog"})
public class PrintWriterLogProvider
implements IHLogProvider {
    private PrintWriter printWriter;
    private TimeSource timeSource;

    @Override
    @NotNull
    public IHLog getLog(@NotNull String defaultTag) {
        Intrinsics.checkNotNullParameter((Object)defaultTag, (String)"defaultTag");
        return new PrintWriterLog(defaultTag, this.printWriter, this.timeSource);
    }

    @NotNull
    public final PrintWriter getLogWriter() {
        return this.printWriter;
    }

    public PrintWriterLogProvider(@NotNull PrintWriter printWriter, @NotNull TimeSource timeSource) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.printWriter = printWriter;
        this.timeSource = timeSource;
    }

    public /* synthetic */ PrintWriterLogProvider(PrintWriter printWriter, TimeSource timeSource, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            timeSource = new SystemTimeSource();
        }
        this(printWriter, timeSource);
    }

    public PrintWriterLogProvider(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this(new PrintWriter(writer, true), null, 2, null);
    }

    public PrintWriterLogProvider(@NotNull Writer writer, @NotNull TimeSource timeSource) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this(new PrintWriter(writer, true), timeSource);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\"\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/hkhc/log/providers/PrintWriterLogProvider$PrintWriterLog;", "Lio/hkhc/log/AbstractIHLog;", "defaultTag", "", "writer", "Ljava/io/PrintWriter;", "timeSource", "Lio/hkhc/log/TimeSource;", "(Ljava/lang/String;Ljava/io/PrintWriter;Lio/hkhc/log/TimeSource;)V", "dateFormat", "Ljava/text/SimpleDateFormat;", "pidStr", "useTimestamp", "", "getWriter", "()Ljava/io/PrintWriter;", "setWriter", "(Ljava/io/PrintWriter;)V", "getProcessID", "", "getVerbosityChar", "", "priority", "Lio/hkhc/log/Priority;", "log", "", "tag", "message", "logImpl", "msg", "ihlog"})
    public static final class PrintWriterLog
    extends AbstractIHLog {
        private SimpleDateFormat dateFormat;
        private String pidStr;
        private final boolean useTimestamp;
        @NotNull
        private PrintWriter writer;
        private TimeSource timeSource;

        private final int getProcessID() {
            int n;
            try {
                Class<?> clazz = Class.forName("android.os.Process");
                Method m = clazz.getMethod("myPid", new Class[0]);
                Object object = m.invoke(null, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                n = (Integer)object;
            }
            catch (ClassNotFoundException t) {
                n = 0;
            }
            catch (NoSuchMethodException t) {
                n = 0;
            }
            catch (SecurityException t) {
                n = 0;
            }
            return n;
        }

        private final char getVerbosityChar(Priority priority) {
            int n;
            Priority priority2 = priority;
            if (Intrinsics.areEqual((Object)priority2, (Object)Priority.Info.INSTANCE)) {
                n = 105;
            } else if (Intrinsics.areEqual((Object)priority2, (Object)Priority.Warn.INSTANCE)) {
                n = 119;
            } else if (Intrinsics.areEqual((Object)priority2, (Object)Priority.Debug.INSTANCE)) {
                n = 100;
            } else if (Intrinsics.areEqual((Object)priority2, (Object)Priority.Fatal.INSTANCE)) {
                n = 102;
            } else if (Intrinsics.areEqual((Object)priority2, (Object)Priority.Error.INSTANCE)) {
                n = 101;
            } else if (Intrinsics.areEqual((Object)priority2, (Object)Priority.Trace.INSTANCE)) {
                n = 116;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return (char)n;
        }

        private final void logImpl(Priority priority, String tag, String msg) {
            String timestamp = this.useTimestamp ? this.dateFormat.format(this.timeSource.getTime()) + ' ' : "";
            StringBuilder stringBuilder = new StringBuilder().append(timestamp).append(' ').append(this.pidStr).append('/');
            String string = tag;
            if (string == null) {
                string = this.getDefaultTag();
            }
            String prefix = stringBuilder.append(string).append(' ').append(this.getVerbosityChar(priority)).append('/').toString();
            this.writer.println(prefix + msg);
        }

        @Override
        public void log(@NotNull Priority priority, @Nullable String tag, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Sequence $this$forEach$iv = StringsKt.lineSequence((CharSequence)message);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl = false;
                this.logImpl(priority, tag, line);
            }
        }

        @NotNull
        public final PrintWriter getWriter() {
            return this.writer;
        }

        public final void setWriter(@NotNull PrintWriter printWriter) {
            Intrinsics.checkNotNullParameter((Object)printWriter, (String)"<set-?>");
            this.writer = printWriter;
        }

        public PrintWriterLog(@NotNull String defaultTag, @NotNull PrintWriter writer, @NotNull TimeSource timeSource) {
            Intrinsics.checkNotNullParameter((Object)defaultTag, (String)"defaultTag");
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
            super(defaultTag);
            this.writer = writer;
            this.timeSource = timeSource;
            this.dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
            this.useTimestamp = true;
            int pid = this.getProcessID();
            this.pidStr = pid == 0 ? "-" : Integer.toString(pid);
        }
    }
}

