/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common;

import io.holixon.avro.adapter.api.AvroPayloadAndSchemaId;
import io.holixon.avro.adapter.api.AvroSchemaWithId;
import io.holixon.avro.adapter.api.ext.ByteArrayExt;
import io.holixon.avro.adapter.api.type.AvroPayloadAndSchemaIdData;
import io.holixon.avro.adapter.common.DefaultSchemaIdSupplier;
import io.holixon.avro.adapter.common.DefaultSchemaRevisionResolver;
import io.holixon.avro.adapter.common.converter.DefaultSchemaCompatibilityResolver;
import io.holixon.avro.adapter.common.registry.InMemoryAvroSchemaRegistry;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.ClassUtils;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00020\u00170\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0007J\u0012\u0010\u001a\u001a\u00020\u001b*\b\u0012\u0004\u0012\u00020\u00170\u0018H\u0007J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0007J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0006H\u0007J\f\u0010\u001f\u001a\u00020 *\u00020\u0006H\u0002J\u000e\u0010!\u001a\u00020\"*\u00060\u0006j\u0002`#J\f\u0010$\u001a\u00020\u0006*\u00020\u0017H\u0007J\f\u0010%\u001a\u00020\u001e*\u00020\u0017H\u0007J\u001b\u0010&\u001a\u00020'\"\b\b\u0000\u0010(*\u00020\u0017*\u0002H(H\u0007\u00a2\u0006\u0002\u0010)J#\u0010*\u001a\u0002H(\"\b\b\u0000\u0010(*\u00020\u0017*\u00020'2\u0006\u0010+\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/holixon/avro/adapter/common/AvroAdapterDefault;", "", "()V", "AVRO_HEADER_LENGTH", "", "AVRO_V1_HEADER", "", "PROPERTY_REVISION", "", "defaultSchemaCompatibilityResolver", "Lio/holixon/avro/adapter/common/converter/DefaultSchemaCompatibilityResolver;", "reflectionBasedDecoderSpecificRecordClassResolver", "Lio/holixon/avro/adapter/common/AvroAdapterDefault$DecoderSpecificRecordClassResolver;", "getReflectionBasedDecoderSpecificRecordClassResolver$annotations", "getReflectionBasedDecoderSpecificRecordClassResolver", "()Lio/holixon/avro/adapter/common/AvroAdapterDefault$DecoderSpecificRecordClassResolver;", "schemaIdSupplier", "Lio/holixon/avro/adapter/common/DefaultSchemaIdSupplier;", "schemaRevisionResolver", "Lio/holixon/avro/adapter/common/DefaultSchemaRevisionResolver;", "inMemorySchemaRegistry", "Lio/holixon/avro/adapter/common/registry/InMemoryAvroSchemaRegistry;", "fromByteArray", "Lorg/apache/avro/specific/SpecificRecordBase;", "Ljava/lang/Class;", "bytes", "getSchema", "Lorg/apache/avro/Schema;", "isAvroSingleObjectEncoded", "", "Ljava/nio/ByteBuffer;", "readLong", "", "readPayloadAndSchemaId", "Lio/holixon/avro/adapter/api/AvroPayloadAndSchemaId;", "Lio/holixon/avro/adapter/api/AvroSingleObjectEncoded;", "toByteArray", "toByteBuffer", "toGenericDataRecord", "Lorg/apache/avro/generic/GenericData$Record;", "T", "(Lorg/apache/avro/specific/SpecificRecordBase;)Lorg/apache/avro/generic/GenericData$Record;", "toSpecificDataRecord", "schema", "(Lorg/apache/avro/generic/GenericData$Record;Lorg/apache/avro/Schema;)Lorg/apache/avro/specific/SpecificRecordBase;", "DecoderSpecificRecordClassResolver", "avro-registry-adapter-default"})
public final class AvroAdapterDefault {
    @NotNull
    public static final AvroAdapterDefault INSTANCE = new AvroAdapterDefault();
    @NotNull
    public static final String PROPERTY_REVISION = "revision";
    @JvmField
    @NotNull
    public static final byte[] AVRO_V1_HEADER;
    private static final int AVRO_HEADER_LENGTH;
    @JvmField
    @NotNull
    public static final DefaultSchemaRevisionResolver schemaRevisionResolver;
    @JvmField
    @NotNull
    public static final DefaultSchemaIdSupplier schemaIdSupplier;
    @NotNull
    private static final DecoderSpecificRecordClassResolver reflectionBasedDecoderSpecificRecordClassResolver;
    @JvmField
    @NotNull
    public static final DefaultSchemaCompatibilityResolver defaultSchemaCompatibilityResolver;

    private AvroAdapterDefault() {
    }

    @NotNull
    public final AvroPayloadAndSchemaId readPayloadAndSchemaId(@NotNull byte[] $this$readPayloadAndSchemaId) {
        Intrinsics.checkNotNullParameter((Object)$this$readPayloadAndSchemaId, (String)"<this>");
        if (!($this$readPayloadAndSchemaId.length > AVRO_HEADER_LENGTH)) {
            boolean $i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$32 = false;
            String $i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$32 = "Single object encoded bytes must have at least length > " + AVRO_HEADER_LENGTH + ", was: " + $this$readPayloadAndSchemaId.length + ".";
            throw new IllegalArgumentException($i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$32.toString());
        }
        if (!AvroAdapterDefault.isAvroSingleObjectEncoded($this$readPayloadAndSchemaId)) {
            boolean $i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$42 = false;
            String $i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$42 = "Single object encoded bytes need to start with " + ByteArrayExt.toHexString((byte[])AVRO_V1_HEADER) + ".";
            throw new IllegalArgumentException($i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$42.toString());
        }
        int[] $i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$42 = new int[]{AVRO_V1_HEADER.length, AVRO_HEADER_LENGTH};
        List list = ByteArrayExt.INSTANCE.split($this$readPayloadAndSchemaId, $i$a$-require-AvroAdapterDefault$readPayloadAndSchemaId$42);
        byte[] idBytes = (byte[])list.get(1);
        byte[] payloadBytes = (byte[])list.get(2);
        return (AvroPayloadAndSchemaId)new AvroPayloadAndSchemaIdData(String.valueOf(this.readLong(idBytes)), payloadBytes);
    }

    private final long readLong(byte[] $this$readLong) {
        if (!($this$readLong.length == 8)) {
            boolean bl = false;
            String string = "Size must be exactly Long.SIZE_BYTES (8.";
            throw new IllegalArgumentException(string.toString());
        }
        return ByteArrayExt.INSTANCE.buffer($this$readLong).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    @JvmStatic
    public static final boolean isAvroSingleObjectEncoded(@NotNull ByteBuffer $this$isAvroSingleObjectEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$isAvroSingleObjectEncoded, (String)"<this>");
        return Arrays.equals(ByteArrayExt.INSTANCE.extract($this$isAvroSingleObjectEncoded, 0, Integer.valueOf(AVRO_V1_HEADER.length)), AVRO_V1_HEADER);
    }

    @JvmStatic
    public static final boolean isAvroSingleObjectEncoded(@NotNull byte[] $this$isAvroSingleObjectEncoded) {
        Intrinsics.checkNotNullParameter((Object)$this$isAvroSingleObjectEncoded, (String)"<this>");
        return AvroAdapterDefault.isAvroSingleObjectEncoded(ByteArrayExt.INSTANCE.buffer($this$isAvroSingleObjectEncoded));
    }

    @NotNull
    public final InMemoryAvroSchemaRegistry inMemorySchemaRegistry() {
        return new InMemoryAvroSchemaRegistry(schemaIdSupplier, schemaRevisionResolver);
    }

    @JvmStatic
    @NotNull
    public static final ByteBuffer toByteBuffer(@NotNull SpecificRecordBase $this$toByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteBuffer, (String)"<this>");
        Object object = $this$toByteBuffer.getClass().getDeclaredMethod("toByteBuffer", new Class[0]).invoke((Object)$this$toByteBuffer, new Object[0]);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.nio.ByteBuffer");
        }
        return (ByteBuffer)object;
    }

    @JvmStatic
    @NotNull
    public static final <T extends SpecificRecordBase> GenericData.Record toGenericDataRecord(@NotNull T $this$toGenericDataRecord) {
        Intrinsics.checkNotNullParameter($this$toGenericDataRecord, (String)"<this>");
        Object object = GenericData.get().deepCopy($this$toGenericDataRecord.getSchema(), $this$toGenericDataRecord);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.avro.generic.GenericData.Record");
        }
        return (GenericData.Record)object;
    }

    @JvmStatic
    @NotNull
    public static final <T extends SpecificRecordBase> T toSpecificDataRecord(@NotNull GenericData.Record $this$toSpecificDataRecord, @NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)$this$toSpecificDataRecord, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Object object = SpecificData.get().deepCopy(schema, (Object)$this$toSpecificDataRecord);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of io.holixon.avro.adapter.common.AvroAdapterDefault.toSpecificDataRecord");
        }
        return (T)((SpecificRecordBase)object);
    }

    @JvmStatic
    @NotNull
    public static final byte[] toByteArray(@NotNull SpecificRecordBase $this$toByteArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toByteArray, (String)"<this>");
        byte[] byArray = AvroAdapterDefault.toByteBuffer($this$toByteArray).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this.toByteBuffer().array()");
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final SpecificRecordBase fromByteArray(@NotNull Class<SpecificRecordBase> $this$fromByteArray, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter($this$fromByteArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Object[] objectArray = new Class[]{ByteBuffer.class};
        Method method = $this$fromByteArray.getDeclaredMethod("fromByteBuffer", (Class<?>[])objectArray);
        objectArray = new Object[]{ByteBuffer.wrap(bytes)};
        Object object = method.invoke(null, objectArray);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.avro.specific.SpecificRecordBase");
        }
        return (SpecificRecordBase)object;
    }

    @JvmStatic
    @NotNull
    public static final Schema getSchema(@NotNull Class<SpecificRecordBase> $this$getSchema) {
        Intrinsics.checkNotNullParameter($this$getSchema, (String)"<this>");
        Object object = $this$getSchema.getDeclaredField("SCHEMA$").get(null);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.avro.Schema");
        }
        return (Schema)object;
    }

    @NotNull
    public final DecoderSpecificRecordClassResolver getReflectionBasedDecoderSpecificRecordClassResolver() {
        return reflectionBasedDecoderSpecificRecordClassResolver;
    }

    public static /* synthetic */ void getReflectionBasedDecoderSpecificRecordClassResolver$annotations() {
    }

    private static final Class reflectionBasedDecoderSpecificRecordClassResolver$lambda-3(AvroSchemaWithId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Class clazz = ClassUtils.forName((String)it.getCanonicalName());
        if (clazz == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<org.apache.avro.specific.SpecificRecordBase>");
        }
        return clazz;
    }

    static {
        byte[] byArray = new byte[]{-61, 1};
        AVRO_V1_HEADER = byArray;
        AVRO_HEADER_LENGTH = AVRO_V1_HEADER.length + 8;
        schemaRevisionResolver = new DefaultSchemaRevisionResolver();
        schemaIdSupplier = new DefaultSchemaIdSupplier();
        reflectionBasedDecoderSpecificRecordClassResolver = AvroAdapterDefault::reflectionBasedDecoderSpecificRecordClassResolver$lambda-3;
        defaultSchemaCompatibilityResolver = new DefaultSchemaCompatibilityResolver(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001\u00a8\u0006\u0005"}, d2={"Lio/holixon/avro/adapter/common/AvroAdapterDefault$DecoderSpecificRecordClassResolver;", "Ljava/util/function/Function;", "Lio/holixon/avro/adapter/api/AvroSchemaWithId;", "Ljava/lang/Class;", "Lorg/apache/avro/specific/SpecificRecordBase;", "avro-registry-adapter-default"})
    public static interface DecoderSpecificRecordClassResolver
    extends Function<AvroSchemaWithId, Class<SpecificRecordBase>> {
    }
}

