/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common.converter;

import io.holixon.avro.adapter.api.AvroSchemaIncompatibilityResolver;
import io.holixon.avro.adapter.api.ext.FunctionalExt;
import io.holixon.avro.adapter.common.AvroAdapterDefault;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fJ\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00060\tj\u0002`\n*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/holixon/avro/adapter/common/converter/DefaultSchemaCompatibilityResolver;", "Lio/holixon/avro/adapter/api/AvroSchemaIncompatibilityResolver;", "ignoredIncompatibilityTypes", "", "Lorg/apache/avro/SchemaCompatibility$SchemaIncompatibilityType;", "(Ljava/util/Set;)V", "getIgnoredIncompatibilityTypes", "()Ljava/util/Set;", "schemaId", "", "Lio/holixon/avro/adapter/api/AvroSchemaId;", "Lorg/apache/avro/Schema;", "getSchemaId", "(Lorg/apache/avro/Schema;)Ljava/lang/String;", "filterIgnored", "", "incompatibilities", "resolve", "readerSchema", "writerSchema", "avro-registry-adapter-default"})
public class DefaultSchemaCompatibilityResolver
implements AvroSchemaIncompatibilityResolver {
    @NotNull
    private final Set<SchemaCompatibility.SchemaIncompatibilityType> ignoredIncompatibilityTypes;

    @JvmOverloads
    public DefaultSchemaCompatibilityResolver(@NotNull Set<? extends SchemaCompatibility.SchemaIncompatibilityType> ignoredIncompatibilityTypes) {
        Intrinsics.checkNotNullParameter(ignoredIncompatibilityTypes, (String)"ignoredIncompatibilityTypes");
        this.ignoredIncompatibilityTypes = ignoredIncompatibilityTypes;
    }

    public /* synthetic */ DefaultSchemaCompatibilityResolver(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        this(set);
    }

    @NotNull
    public final Set<SchemaCompatibility.SchemaIncompatibilityType> getIgnoredIncompatibilityTypes() {
        return this.ignoredIncompatibilityTypes;
    }

    @NotNull
    public Schema resolve(@NotNull Schema readerSchema, @NotNull Schema writerSchema) {
        Schema schema;
        Intrinsics.checkNotNullParameter((Object)readerSchema, (String)"readerSchema");
        Intrinsics.checkNotNullParameter((Object)writerSchema, (String)"writerSchema");
        SchemaCompatibility.SchemaPairCompatibility compatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)readerSchema, (Schema)writerSchema);
        SchemaCompatibility.SchemaCompatibilityType schemaCompatibilityType = compatibility.getResult().getCompatibility();
        Intrinsics.checkNotNull((Object)schemaCompatibilityType);
        switch (WhenMappings.$EnumSwitchMapping$0[schemaCompatibilityType.ordinal()]) {
            case 1: {
                schema = readerSchema;
                break;
            }
            case 2: {
                Collection<SchemaCompatibility.SchemaIncompatibilityType> collection;
                SchemaCompatibility.Incompatibility it;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = compatibility.getResult().getIncompatibilities();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"compatibility.result.incompatibilities");
                iterable = iterable;
                DefaultSchemaCompatibilityResolver defaultSchemaCompatibilityResolver = this;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    SchemaCompatibility.Incompatibility incompatibility = (SchemaCompatibility.Incompatibility)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getType());
                }
                if (defaultSchemaCompatibilityResolver.filterIgnored((List)destination$iv$iv).isEmpty()) {
                    schema = readerSchema;
                    break;
                }
                String string = this.getSchemaId(readerSchema);
                String string2 = this.getSchemaId(writerSchema);
                $this$map$iv = compatibility.getResult().getIncompatibilities();
                Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"compatibility.result.incompatibilities");
                $this$map$iv = $this$map$iv;
                DefaultSchemaCompatibilityResolver defaultSchemaCompatibilityResolver2 = this;
                String string3 = string2;
                String string4 = string;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (SchemaCompatibility.Incompatibility)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getType());
                }
                collection = (List)destination$iv$iv;
                String string5 = "Reader schema[" + string4 + "] is not compatible with Writer schema[" + string3 + "]. The incompatibilities are: " + defaultSchemaCompatibilityResolver2.filterIgnored((List<? extends SchemaCompatibility.SchemaIncompatibilityType>)collection);
                throw new IllegalArgumentException(string5);
            }
            case 3: {
                throw new IllegalArgumentException("Recursion in progress for compatibility check for Reader schema[" + this.getSchemaId(readerSchema) + "] and Writer schema[" + this.getSchemaId(writerSchema) + "].");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return schema;
    }

    private final String getSchemaId(Schema $this$schemaId) {
        return (String)FunctionalExt.INSTANCE.invoke((Function)((Object)AvroAdapterDefault.schemaIdSupplier), (Object)$this$schemaId);
    }

    @NotNull
    public final List<SchemaCompatibility.SchemaIncompatibilityType> filterIgnored(@NotNull List<? extends SchemaCompatibility.SchemaIncompatibilityType> incompatibilities) {
        Intrinsics.checkNotNullParameter(incompatibilities, (String)"incompatibilities");
        return CollectionsKt.minus((Iterable)incompatibilities, (Iterable)this.ignoredIncompatibilityTypes);
    }

    @JvmOverloads
    public DefaultSchemaCompatibilityResolver() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SchemaCompatibility.SchemaCompatibilityType.values().length];
            nArray[SchemaCompatibility.SchemaCompatibilityType.COMPATIBLE.ordinal()] = 1;
            nArray[SchemaCompatibility.SchemaCompatibilityType.INCOMPATIBLE.ordinal()] = 2;
            nArray[SchemaCompatibility.SchemaCompatibilityType.RECURSION_IN_PROGRESS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

