/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common.converter;

import io.holixon.avro.adapter.api.AvroSchemaIncompatibilityResolver;
import io.holixon.avro.adapter.api.AvroSchemaResolver;
import io.holixon.avro.adapter.api.AvroSchemaWithId;
import io.holixon.avro.adapter.common.AvroAdapterDefault;
import io.holixon.avro.adapter.common.ext.DefaultSchemaExt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificRecordBase;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0002J\u0012\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u000e2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/holixon/avro/adapter/common/converter/SchemaResolutionSupport;", "", "schemaResolver", "Lio/holixon/avro/adapter/api/AvroSchemaResolver;", "decoderSpecificRecordClassResolver", "Lio/holixon/avro/adapter/common/AvroAdapterDefault$DecoderSpecificRecordClassResolver;", "schemaIncompatibilityResolver", "Lio/holixon/avro/adapter/api/AvroSchemaIncompatibilityResolver;", "(Lio/holixon/avro/adapter/api/AvroSchemaResolver;Lio/holixon/avro/adapter/common/AvroAdapterDefault$DecoderSpecificRecordClassResolver;Lio/holixon/avro/adapter/api/AvroSchemaIncompatibilityResolver;)V", "getClassForSchema", "Ljava/lang/Class;", "T", "Lorg/apache/avro/specific/SpecificRecordBase;", "avroSchemaWithId", "Lio/holixon/avro/adapter/api/AvroSchemaWithId;", "resolveReaderSchema", "schemaId", "", "Lio/holixon/avro/adapter/api/AvroSchemaId;", "bytes", "", "Lio/holixon/avro/adapter/api/AvroSingleObjectEncoded;", "record", "Lorg/apache/avro/generic/GenericData$Record;", "resolveWriterSchema", "avro-registry-adapter-default"})
public class SchemaResolutionSupport {
    @NotNull
    private final AvroSchemaResolver schemaResolver;
    @NotNull
    private final AvroAdapterDefault.DecoderSpecificRecordClassResolver decoderSpecificRecordClassResolver;
    @NotNull
    private final AvroSchemaIncompatibilityResolver schemaIncompatibilityResolver;

    @JvmOverloads
    public SchemaResolutionSupport(@NotNull AvroSchemaResolver schemaResolver, @NotNull AvroAdapterDefault.DecoderSpecificRecordClassResolver decoderSpecificRecordClassResolver, @NotNull AvroSchemaIncompatibilityResolver schemaIncompatibilityResolver) {
        Intrinsics.checkNotNullParameter((Object)schemaResolver, (String)"schemaResolver");
        Intrinsics.checkNotNullParameter((Object)decoderSpecificRecordClassResolver, (String)"decoderSpecificRecordClassResolver");
        Intrinsics.checkNotNullParameter((Object)schemaIncompatibilityResolver, (String)"schemaIncompatibilityResolver");
        this.schemaResolver = schemaResolver;
        this.decoderSpecificRecordClassResolver = decoderSpecificRecordClassResolver;
        this.schemaIncompatibilityResolver = schemaIncompatibilityResolver;
    }

    public /* synthetic */ SchemaResolutionSupport(AvroSchemaResolver avroSchemaResolver, AvroAdapterDefault.DecoderSpecificRecordClassResolver decoderSpecificRecordClassResolver, AvroSchemaIncompatibilityResolver avroSchemaIncompatibilityResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            decoderSpecificRecordClassResolver = AvroAdapterDefault.INSTANCE.getReflectionBasedDecoderSpecificRecordClassResolver();
        }
        if ((n & 4) != 0) {
            avroSchemaIncompatibilityResolver = AvroAdapterDefault.defaultSchemaCompatibilityResolver;
        }
        this(avroSchemaResolver, decoderSpecificRecordClassResolver, avroSchemaIncompatibilityResolver);
    }

    @NotNull
    public final AvroSchemaWithId resolveReaderSchema(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String schemaId = AvroAdapterDefault.INSTANCE.readPayloadAndSchemaId(bytes).getSchemaId();
        return this.resolveReaderSchema(schemaId);
    }

    @NotNull
    public final AvroSchemaWithId resolveReaderSchema(@NotNull GenericData.Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Schema schema = record.getSchema();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"record.schema");
        return this.resolveReaderSchema(DefaultSchemaExt.INSTANCE.getAvroSchemaWithId(schema).getSchemaId());
    }

    @NotNull
    public final AvroSchemaWithId resolveWriterSchema(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String schemaId = AvroAdapterDefault.INSTANCE.readPayloadAndSchemaId(bytes).getSchemaId();
        Object t = ((Optional)this.schemaResolver.apply((Object)schemaId)).orElseThrow(() -> SchemaResolutionSupport.resolveWriterSchema$lambda-0(schemaId));
        Intrinsics.checkNotNullExpressionValue(t, (String)"schemaResolver.apply(sch\u2026ema for id=$schemaId.\") }");
        return (AvroSchemaWithId)t;
    }

    @NotNull
    public final <T extends SpecificRecordBase> Class<T> getClassForSchema(@NotNull AvroSchemaWithId avroSchemaWithId) {
        Intrinsics.checkNotNullParameter((Object)avroSchemaWithId, (String)"avroSchemaWithId");
        return (Class)this.decoderSpecificRecordClassResolver.apply(avroSchemaWithId);
    }

    private final AvroSchemaWithId resolveReaderSchema(String schemaId) {
        AvroSchemaWithId writerSchemaWithId = (AvroSchemaWithId)((Optional)this.schemaResolver.apply((Object)schemaId)).orElseThrow(() -> SchemaResolutionSupport.resolveReaderSchema$lambda-1(schemaId));
        Intrinsics.checkNotNullExpressionValue((Object)writerSchemaWithId, (String)"writerSchemaWithId");
        Class<SpecificRecordBase> targetClass = this.getClassForSchema(writerSchemaWithId);
        Schema readerSchema = AvroAdapterDefault.getSchema(targetClass);
        return DefaultSchemaExt.INSTANCE.getAvroSchemaWithId(this.schemaIncompatibilityResolver.resolve(readerSchema, writerSchemaWithId.getSchema()));
    }

    @JvmOverloads
    public SchemaResolutionSupport(@NotNull AvroSchemaResolver schemaResolver, @NotNull AvroAdapterDefault.DecoderSpecificRecordClassResolver decoderSpecificRecordClassResolver) {
        Intrinsics.checkNotNullParameter((Object)schemaResolver, (String)"schemaResolver");
        Intrinsics.checkNotNullParameter((Object)decoderSpecificRecordClassResolver, (String)"decoderSpecificRecordClassResolver");
        this(schemaResolver, decoderSpecificRecordClassResolver, null, 4, null);
    }

    @JvmOverloads
    public SchemaResolutionSupport(@NotNull AvroSchemaResolver schemaResolver) {
        Intrinsics.checkNotNullParameter((Object)schemaResolver, (String)"schemaResolver");
        this(schemaResolver, null, null, 6, null);
    }

    private static final IllegalArgumentException resolveWriterSchema$lambda-0(String $schemaId) {
        Intrinsics.checkNotNullParameter((Object)$schemaId, (String)"$schemaId");
        return new IllegalArgumentException("Can not resolve writer schema for id=" + $schemaId + ".");
    }

    private static final IllegalArgumentException resolveReaderSchema$lambda-1(String $schemaId) {
        Intrinsics.checkNotNullParameter((Object)$schemaId, (String)"$schemaId");
        return new IllegalArgumentException("Can not resolve writer schema for id=" + $schemaId + ".");
    }
}

