/*
 * Decompiled with CFR 0.152.
 */
package io.holixon.avro.adapter.common.registry;

import io.holixon.avro.adapter.api.AvroSchemaInfo;
import io.holixon.avro.adapter.api.AvroSchemaReadOnlyRegistry;
import io.holixon.avro.adapter.api.AvroSchemaRegistry;
import io.holixon.avro.adapter.api.AvroSchemaWithId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u0016J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\n\u0010\u0012\u001a\u00060\u000ej\u0002`\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/holixon/avro/adapter/common/registry/CompositeAvroSchemaReadOnlyRegistry;", "Lio/holixon/avro/adapter/api/AvroSchemaReadOnlyRegistry;", "registry", "", "Lio/holixon/avro/adapter/api/AvroSchemaRegistry;", "([Lio/holixon/avro/adapter/api/AvroSchemaRegistry;)V", "([Lio/holixon/avro/adapter/api/AvroSchemaReadOnlyRegistry;)V", "registries", "", "(Ljava/util/List;)V", "findAll", "Lio/holixon/avro/adapter/api/AvroSchemaWithId;", "findAllByCanonicalName", "namespace", "", "name", "findById", "Ljava/util/Optional;", "schemaId", "Lio/holixon/avro/adapter/api/AvroSchemaId;", "findByInfo", "info", "Lio/holixon/avro/adapter/api/AvroSchemaInfo;", "avro-registry-adapter-default"})
public final class CompositeAvroSchemaReadOnlyRegistry
implements AvroSchemaReadOnlyRegistry {
    @NotNull
    private final List<AvroSchemaReadOnlyRegistry> registries;

    public CompositeAvroSchemaReadOnlyRegistry(@NotNull List<? extends AvroSchemaReadOnlyRegistry> registries) {
        Intrinsics.checkNotNullParameter(registries, (String)"registries");
        this.registries = registries;
        if (!(!((Collection)this.registries).isEmpty())) {
            boolean bl = false;
            String string = "Composite Avro Schema Registry must contain at least one registry.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public CompositeAvroSchemaReadOnlyRegistry(AvroSchemaRegistry ... registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this(ArraysKt.asList((Object[])registry));
    }

    public CompositeAvroSchemaReadOnlyRegistry(AvroSchemaReadOnlyRegistry ... registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this(ArraysKt.asList((Object[])registry));
    }

    @NotNull
    public Optional<AvroSchemaWithId> findById(@NotNull String schemaId) {
        Intrinsics.checkNotNullParameter((Object)schemaId, (String)"schemaId");
        for (AvroSchemaReadOnlyRegistry registry : this.registries) {
            Optional result = registry.findById(schemaId);
            if (!result.isPresent()) continue;
            return result;
        }
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"empty()");
        return optional;
    }

    @NotNull
    public Optional<AvroSchemaWithId> findByInfo(@NotNull AvroSchemaInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (AvroSchemaReadOnlyRegistry registry : this.registries) {
            Optional result = registry.findByInfo(info);
            if (!result.isPresent()) continue;
            return result;
        }
        Optional optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"empty()");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AvroSchemaWithId> findAllByCanonicalName(@NotNull String namespace, @NotNull String name) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$flatMap$iv = this.registries;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AvroSchemaReadOnlyRegistry it = (AvroSchemaReadOnlyRegistry)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findAllByCanonicalName(namespace, name);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AvroSchemaWithId> findAll() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.registries;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AvroSchemaReadOnlyRegistry it = (AvroSchemaReadOnlyRegistry)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.findAll();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }
}

